/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.ErrorItemBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import com.oracle.subversion.server.impl.svnkit.SVNEditorCommandSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;

public class CommitCommand
extends AbstractCommand {
    @Override
    public void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.assertArgumentListType(parameters);
        ListItem items = (ListItem)parameters;
        Object value = items.getValue();
        StringItem commitMsgItem = (StringItem)value.get(0);
        int size = value.size();
        boolean keepLocks = true;
        Map<String, String> revProps = null;
        ListItem lockInfoItem = null;
        if (size > 1) {
            lockInfoItem = (ListItem)value.get(1);
        }
        if (size > 2) {
            WordItem keepLocksItem = (WordItem)value.get(2);
            keepLocks = Boolean.getBoolean(keepLocksItem.getValue());
        }
        if (size > 3) {
            ListItem revPropsItem = (ListItem)value.get(3);
            revProps = this.getRevisionPropertiesFrom(revPropsItem);
        }
        SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
        SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildEmptySuccess());
        SVNRepository repository = context.getRepository();
        SVNEditorCommandSet editorCommandSet = new SVNEditorCommandSet(repository);
        try {
            String message = commitMsgItem.getValue();
            editorCommandSet.processClientSideEditorCommands(context, revProps, message, lockInfoItem, keepLocks);
        }
        catch (SVNException e) {
            ListItem errors = new ListItem();
            errors.add(ErrorItemBuilder.buildError(e));
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildFailure(errors));
            throw new ExecutionException(e);
        }
    }

    private Map<String, String> getRevisionPropertiesFrom(ListItem revPropsItem) {
        HashMap<String, String> revProps = new HashMap<String, String>();
        Object revPropsList = revPropsItem.getValue();
        Iterator i$ = revPropsList.iterator();
        while (i$.hasNext()) {
            Item item = (Item)i$.next();
            ListItem propItem = (ListItem)item;
            Object propList = propItem.getValue();
            StringItem propKey = (StringItem)propList.get(0);
            StringItem propValue = (StringItem)propList.get(1);
            revProps.put(propKey.getValue(), propValue.getValue());
        }
        return revProps;
    }
}

