/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ItemType;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.Command;
import com.oracle.subversion.server.command.Condition;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import java.io.InputStream;
import java.util.Map;

public final class CommandProcessor {
    public static boolean process(InputStream in, Map<String, Command> commands, ExecutionContext context, Condition filter) throws MessageEncodingException, ExecutionException {
        Item item;
        boolean ret = false;
        while ((item = SvnMessageEncoding.deserialize(in)) != null) {
            String operationName;
            Command command;
            ItemType type = item.getType();
            if (type != ItemType.LIST) continue;
            ListItem list = (ListItem)item;
            Object value = list.getValue();
            Item operation = (Item)value.get(0);
            Item parameters = (Item)value.get(1);
            if (filter != null) {
                if (filter.fail(operation)) {
                    ret = false;
                    break;
                }
                if (filter.finish(operation)) {
                    ret = true;
                    break;
                }
            }
            if ((command = commands.get(operationName = (String)operation.getValue())) != null) {
                command.execute(context, parameters);
                continue;
            }
            throw new ExecutionException("Command for operation '" + operationName + "' not found");
        }
        return ret;
    }
}

