/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.Keyword;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NodeKind;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;

public class CheckPathCommand
extends AbstractCommand {
    @Override
    public void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        ListItem item;
        Object value;
        this.assertArgumentListType(parameters);
        ListItem list = (ListItem)parameters;
        Object items = list.getValue();
        Item pathItem = (Item)items.get(0);
        NumberItem revItem = null;
        if (items.size() > 1 && (value = (item = (ListItem)items.get(1)).getValue()).size() > 0) {
            revItem = (NumberItem)value.get(0);
        }
        String path = ((StringItem)pathItem).getValue();
        try {
            SVNNodeKind svnNodeKind = context.getRepository().checkPath(path, revItem == null ? -1L : revItem.getValue());
            if (svnNodeKind != null) {
                SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
                ListItem res = new ListItem();
                res.add(Keyword.SUCESS);
                ListItem arg = new ListItem();
                NodeKind kind = this.getNodeKind(svnNodeKind);
                arg.add(new WordItem(kind));
                res.add(arg);
                SvnMessageEncoding.serialize(context.getOutputStream(), res);
            }
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
    }

    private NodeKind getNodeKind(SVNNodeKind svnNodeKind) {
        NodeKind kind = NodeKind.UNKNOWN;
        if (svnNodeKind == SVNNodeKind.DIR) {
            kind = NodeKind.DIR;
        } else if (svnNodeKind == SVNNodeKind.FILE) {
            kind = NodeKind.FILE;
        } else if (svnNodeKind == SVNNodeKind.NONE) {
            kind = NodeKind.NONE;
        }
        return kind;
    }
}

