/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Capability;
import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.Keyword;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.command.SvnAuthenticator;
import com.oracle.subversion.server.exception.MessageEncodingException;

public class AuthenticationCommand
extends AbstractCommand {
    @Override
    public void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        try {
            ListItem res = SvnAuthenticator.authenticate(context);
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildSuccess(res));
            ListItem params = new ListItem();
            params.add(context.getRepository().getRepositoryUUID(true));
            int serverPort = (Integer)context.getVariable("serverPort");
            params.add("svn://localhost:" + serverPort);
            ListItem capabilities = new ListItem();
            capabilities.add(Capability.MERGEINFO);
            params.add(capabilities);
            ListItem response = new ListItem();
            response.add(Keyword.SUCESS);
            response.add(params);
            SvnMessageEncoding.serialize(context.getOutputStream(), response);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }
}

