/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ItemType;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.encoding.ErrorItemBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.Command;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;

public abstract class AbstractCommand
implements Command {
    @Override
    public void execute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        try {
            this.doExecute(context, parameters);
        }
        catch (ExecutionException e) {
            ListItem errors = new ListItem();
            errors.add(ErrorItemBuilder.buildError(e));
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildFailure(errors));
            throw e;
        }
        catch (MessageEncodingException e) {
            ListItem errors = new ListItem();
            errors.add(ErrorItemBuilder.buildError(e));
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildFailure(errors));
            throw new ExecutionException(e);
        }
    }

    protected abstract void doExecute(ExecutionContext var1, Item var2) throws ExecutionException, MessageEncodingException;

    protected void assertArgumentListType(Item arg) throws ExecutionException {
        if (arg.getType() != ItemType.LIST) {
            throw new ExecutionException("Invalid parameter type:" + (Object)((Object)arg.getType()) + ". Expected type: " + (Object)((Object)ItemType.LIST));
        }
    }
}

