/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server;

import com.oracle.subversion.server.ServerHandler;
import com.oracle.subversion.server.exception.ServerException;
import java.io.IOException;
import java.net.ServerSocket;

public final class Server {
    private int port;
    private ServerSocket providerSocket;
    private String repositoryPath;
    private ServerHandler serverHandler;

    public Server(int port, String repositoryPath) {
        this.port = port;
        this.repositoryPath = repositoryPath;
    }

    public static void main(String[] args) {
        Server server = new Server(8000, "/home/imanzano/bacRepo/testSec");
        Runtime.getRuntime().addShutdownHook(new ScriptShutdown(server));
        try {
            server.start();
        }
        catch (ServerException e) {
            e.printStackTrace();
            server.stop();
        }
    }

    public void start() throws ServerException {
        try {
            System.out.println("Starting Server...");
            this.providerSocket = new ServerSocket(this.port);
            this.serverHandler = new ServerHandler(this.providerSocket, this.repositoryPath);
            this.serverHandler.run();
        }
        catch (IOException e) {
            throw new ServerException(e);
        }
    }

    public void stop() {
        try {
            System.out.println("Stopping Server...");
            this.serverHandler.stop();
            this.providerSocket.close();
            System.out.println("Server stopped.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static final class ScriptShutdown
    extends Thread {
        private Server server;

        public ScriptShutdown(Server server) {
            this.server = server;
        }

        @Override
        public void run() {
            try {
                this.server.stop();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }
}

