/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server;

import com.oracle.subversion.server.State;
import com.oracle.subversion.server.command.Command;
import com.oracle.subversion.server.command.CommandProcessor;
import com.oracle.subversion.server.command.Commands;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import com.oracle.subversion.server.impl.svnkit.SvnManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.tmatesoft.svn.core.io.SVNRepository;

public class NioServerHandler
extends Thread {
    private InputStream in;
    private OutputStream out;
    private String repositoryPath;
    private int serverPort;
    private final AtomicReference<State> state = new AtomicReference<State>(State.STOPPED);

    public NioServerHandler(InputStream in, OutputStream out, String repositoryPath, int port) {
        this.in = in;
        this.out = out;
        this.repositoryPath = repositoryPath;
        this.serverPort = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.state.compareAndSet(State.STOPPED, State.RUNNING)) {
            return;
        }
        SVNRepository repository = null;
        try {
            OutputStream outputStream = this.out;
            InputStream inputStream = this.in;
            repository = SvnManager.createLocalRepository(this.repositoryPath);
            ExecutionContext context = new ExecutionContext(inputStream, outputStream, repository);
            context.setVariable("serverPort", this.serverPort);
            Command command = Commands.MAIN_CMD_SET.get("greetings");
            command.execute(context, null);
            command = Commands.MAIN_CMD_SET.get("authentication");
            command.execute(context, null);
            CommandProcessor.process(context.getInputStream(), Commands.MAIN_CMD_SET, context, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (MessageEncodingException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.state.set(State.STOPPED);
            }
            catch (Exception e) {}
            if (repository != null) {
                repository.closeSession();
            }
        }
    }
}

