/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server;

import com.oracle.subversion.server.NioServerHandler;
import com.oracle.subversion.server.exception.ServerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.handler.stream.StreamIoHandler;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class NioServer {
    private NioSocketAcceptor acceptor;
    private InetSocketAddress localAddress = null;
    private int port;
    private String repositoryPath;

    public NioServer(int port, String repositoryPath) {
        this.port = port;
        this.repositoryPath = repositoryPath;
    }

    public static void main(String[] args) {
        NioServer server = new NioServer(8000, "/home/imanzano/bacRepo/testSec");
        Runtime.getRuntime().addShutdownHook(new ScriptShutdown(server));
        try {
            server.start();
        }
        catch (ServerException e) {
            e.printStackTrace();
            server.stop();
        }
    }

    public String getURL() {
        StringBuilder url = new StringBuilder();
        url.append("svn://localhost:").append(this.port);
        return url.toString();
    }

    public void start() throws ServerException {
        try {
            System.out.println("Starting Server...");
            this.acceptor = new NioSocketAcceptor();
            this.acceptor.setCloseOnDeactivation(false);
            this.acceptor.setHandler((IoHandler)new SVNHandler(this.port, this.repositoryPath));
            this.localAddress = new InetSocketAddress(this.port);
            this.acceptor.bind((SocketAddress)this.localAddress);
        }
        catch (IOException e) {
            throw new ServerException(e);
        }
    }

    public void stop() {
        System.out.println("Stopping Server...");
        this.acceptor.unbind((SocketAddress)this.localAddress);
        this.acceptor.dispose();
        System.out.println("Server stopped.");
    }

    static final class SVNHandler
    extends StreamIoHandler {
        private int port;
        private String repo;

        public SVNHandler(int port, String repositoryPath) {
            this.repo = repositoryPath;
            this.port = port;
        }

        protected void processStreamIo(IoSession ioSession, InputStream inputStream, OutputStream outputStream) {
            new NioServerHandler(inputStream, outputStream, this.repo, this.port).start();
        }
    }

    static final class ScriptShutdown
    extends Thread {
        private NioServer server;

        public ScriptShutdown(NioServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            try {
                this.server.stop();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }
}

