/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.security.sasl;

import com.oracle.subversion.security.sasl.PasswordValidationCallback;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.tmatesoft.svn.core.internal.util.SVNBase64;

public final class PlainSaslServer
implements SaslServer {
    public boolean complete = false;
    private String authID = null;
    private CallbackHandler cbh;

    PlainSaslServer(CallbackHandler cbh) {
        this.cbh = cbh;
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        String password;
        String authnID;
        String authzID = null;
        int start = 0;
        int end = 0;
        int elementIdx = 0;
        try {
            int passIdx;
            int usernameIdx;
            for (byte b : response) {
                if (b == 0) {
                    if (end - start == 0) {
                        if (elementIdx != 0) {
                            throw new SaslException("null auth data");
                        }
                    } else {
                        String element = new String(response, start, end - start, "UTF-8");
                        start = end + 1;
                        switch (elementIdx) {
                            case 0: {
                                authzID = element;
                                break;
                            }
                            case 1: {
                                authnID = element;
                                break;
                            }
                            default: {
                                throw new SaslException("Unexpected data in packet");
                            }
                        }
                    }
                    ++elementIdx;
                }
                ++end;
            }
            if (start == end) {
                throw new SaslException("null auth data");
            }
            StringBuffer x = new StringBuffer(new String(response, 0, end - start, "UTF-8"));
            byte[] ss = new byte[response.length];
            SVNBase64.base64ToByteArray((StringBuffer)x, (byte[])ss);
            for (usernameIdx = 1; usernameIdx < ss.length && ss[usernameIdx] != 0; ++usernameIdx) {
            }
            for (passIdx = usernameIdx + 1; passIdx < ss.length && ss[passIdx] != 0 && ss[passIdx] != -1; ++passIdx) {
            }
            password = new String(ss, usernameIdx + 1, passIdx - usernameIdx - 1, "UTF-8");
            authnID = new String(ss, 1, usernameIdx - 1, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SaslException("utf-8 encoding");
        }
        PasswordValidationCallback evc = new PasswordValidationCallback(authnID, password);
        AuthorizeCallback ac = new AuthorizeCallback(authnID, authzID);
        Callback[] cbList = new Callback[]{evc, ac};
        try {
            this.cbh.handle(cbList);
            if (!evc.isValidated()) {
                throw new SaslException("cannot validate password");
            }
            if (!ac.isAuthorized()) {
                throw new SaslException("user not authorized");
            }
            this.complete = true;
            return null;
        }
        catch (UnsupportedCallbackException ex) {
            throw new SaslException("unsupported callback", ex);
        }
        catch (IOException e) {
            if (e instanceof SaslException) {
                throw (SaslException)e;
            }
            throw new SaslException("Callback error", e);
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.complete) {
            throw new IllegalStateException("not complete");
        }
        return this.authID;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) {
        if (!this.complete) {
            throw new IllegalStateException("not complete");
        }
        byte[] result = new byte[len];
        System.arraycopy(incoming, offset, result, 0, len);
        return result;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) {
        if (!this.complete) {
            throw new IllegalStateException("not complete");
        }
        byte[] result = new byte[len];
        System.arraycopy(outgoing, offset, result, 0, len);
        return result;
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }
}

