/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.security.sasl;

import com.oracle.subversion.security.sasl.PasswordValidationCallback;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;

public abstract class AuthenticationCallbackHandler
implements CallbackHandler {
    private String username;

    public abstract String getRoles();

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        AuthorizeCallback ac = null;
        PasswordValidationCallback pc = null;
        String password = null;
        for (Callback callback : callbacks) {
            if (callback instanceof AuthorizeCallback) {
                ac = (AuthorizeCallback)callback;
                continue;
            }
            if (callback instanceof PasswordValidationCallback) {
                pc = (PasswordValidationCallback)callback;
                this.username = pc.getUsername();
                password = pc.getPassword();
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
        boolean auth = this.authenticate(this.username, password);
        if (ac != null) {
            ac.setAuthorized(auth);
            if (auth) {
                ac.setAuthorizedID(ac.getAuthenticationID());
            }
        }
        if (pc != null) {
            pc.setValidated(auth);
        }
    }

    abstract boolean authenticate(String var1, String var2);
}

