/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.protocol.encoding;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.encoding.EncodingHelper;
import com.oracle.subversion.protocol.encoding.ItemParser;
import com.oracle.subversion.server.exception.MessageEncodingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;

public final class SvnMessageEncoding {
    public static void serialize(OutputStream out, Item ... items) throws MessageEncodingException {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            if (items != null) {
                for (Item item : items) {
                    EncodingHelper.serialize(buffer, item);
                }
            }
            System.out.println("Message: '" + buffer.toString() + "' ");
            out.write(buffer.toByteArray());
        }
        catch (IOException e) {
            throw new MessageEncodingException(e);
        }
    }

    public static Item deserialize(InputStream in) throws MessageEncodingException {
        try {
            System.out.print("Response:'");
            ItemParser parser = new ItemParser(in);
            Item item = parser.item();
            System.out.println("'");
            return item;
        }
        catch (IOException e) {
            throw new MessageEncodingException(e);
        }
        catch (ParseException e) {
            throw new MessageEncodingException(e);
        }
    }
}

