/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.protocol.encoding;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.ItemToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;

public final class ItemParser {
    private int buffer = Integer.MAX_VALUE;
    private InputStream is;
    private int lastRead;
    private ItemToken next = null;

    public ItemParser(InputStream is) {
        this.is = is;
    }

    public Item item() throws ParseException, IOException {
        ItemToken token = this.consume();
        switch (token.type()) {
            case 1: {
                return new WordItem(token.getText());
            }
            case 2: {
                return new NumberItem(Integer.parseInt(token.getText()));
            }
            case 3: {
                return new StringItem(token.getBytes());
            }
            case 4: {
                return this.list();
            }
        }
        return null;
    }

    ItemToken nextToken() throws ParseException, IOException {
        int c;
        while ((c = this.read()) != -1 && Character.isWhitespace(c)) {
        }
        if (c == -1) {
            return ItemToken.EOF_TOKEN;
        }
        if (Character.isLetter(c)) {
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            while (this.isWord(c)) {
                baout.write(c);
                c = this.read();
            }
            return new ItemToken(1, baout.toByteArray());
        }
        if (this.isDigit(c)) {
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            while (this.isDigit(c)) {
                baout.write(c);
                c = this.read();
            }
            if (c == 58) {
                int count = Integer.parseInt(new String(baout.toByteArray()));
                baout = new ByteArrayOutputStream(count);
                for (int i = 0; i < count; ++i) {
                    c = this.read();
                    if (c == -1) {
                        String text = count + 58 + new String(baout.toByteArray());
                        return new ItemToken(-1, text.getBytes("UTF-8"));
                    }
                    baout.write(c);
                }
                return new ItemToken(3, baout.toByteArray());
            }
            this.unread();
            return new ItemToken(2, baout.toByteArray());
        }
        switch (c) {
            case 40: {
                return ItemToken.LPAREN_TOKEN;
            }
            case 41: {
                return ItemToken.RPAREN_TOKEN;
            }
        }
        this.unread();
        return ItemToken.ERROR_TOKEN;
    }

    private ListItem list() throws ParseException, IOException {
        ListItem listItem = new ListItem();
        while (this.la() != 5 && this.la() != 0) {
            listItem.add(this.item());
        }
        if (this.consume().type() != 5) {
            throw new ParseException("Unexpected EOF", 0);
        }
        return listItem;
    }

    private ItemToken consume() throws ParseException, IOException {
        if (this.next == null) {
            return this.nextToken();
        }
        ItemToken token = this.next;
        this.next = null;
        return token;
    }

    private int la() throws ParseException, IOException {
        if (this.next == null) {
            this.next = this.nextToken();
        }
        return this.next.type();
    }

    private boolean isWord(int c) {
        return c != -1 && (Character.isLetterOrDigit(c) || c == 45);
    }

    private boolean isDigit(int c) {
        return c != -1 && Character.isDigit(c);
    }

    private int read() throws IOException {
        if (this.buffer != Integer.MAX_VALUE) {
            this.lastRead = this.buffer;
            this.buffer = Integer.MAX_VALUE;
        } else {
            this.lastRead = this.is.read();
            System.out.print(Character.toString((char)this.lastRead));
        }
        return this.lastRead;
    }

    private void unread() {
        this.buffer = this.lastRead;
    }
}

