/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.protocol.encoding;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ListItem;

public final class ErrorItemBuilder {
    public static Item buildError(long errNro, String file, long lineNro, Throwable err) {
        ListItem errItem = new ListItem();
        errItem.add(errNro);
        errItem.add(err.getLocalizedMessage());
        errItem.add(file);
        errItem.add(lineNro);
        return errItem;
    }

    public static Item buildError(long errNro, String file, long lineNro, String msg) {
        ListItem errItem = new ListItem();
        errItem.add(errNro);
        errItem.add(msg);
        errItem.add(file);
        errItem.add(lineNro);
        return errItem;
    }

    public static Item buildError(Throwable err) {
        return ErrorItemBuilder.buildError(0L, "", 0L, err);
    }

    public static ListItem buildErrorsList(Throwable ... err) {
        ListItem errorList = new ListItem();
        for (Throwable throwable : err) {
            errorList.add(ErrorItemBuilder.buildError(throwable));
        }
        return errorList;
    }
}

