/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.protocol.encoding;

import com.oracle.subversion.protocol.BytesItem;
import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ItemType;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.AbstractItemEncoder;
import com.oracle.subversion.server.exception.MessageEncodingException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class EncodingHelper {
    private static Map<ItemType, AbstractItemEncoder<? extends Item>> encodingHashMap = new HashMap<ItemType, AbstractItemEncoder<? extends Item>>();

    EncodingHelper() {
    }

    public static void serialize(OutputStream out, Item item) throws MessageEncodingException {
        AbstractItemEncoder<? extends Item> itemEncoder = encodingHashMap.get((Object)item.getType());
        itemEncoder.serialize(out, item);
    }

    static {
        encodingHashMap.put(ItemType.LIST, new ListSerializer());
        encodingHashMap.put(ItemType.STRING, new StringItemEncoder());
        encodingHashMap.put(ItemType.WORD, new WordItemEncoder());
        encodingHashMap.put(ItemType.NUMBER, new NumberItemEncoder());
        encodingHashMap.put(ItemType.BYTES, new BytesItemEncoder());
    }

    private static class WordItemEncoder
    extends AbstractItemEncoder<WordItem> {
        private WordItemEncoder() {
        }

        @Override
        void doSerialize(OutputStream out, WordItem obj) throws IOException, MessageEncodingException {
            String value = obj.getValue() == null ? "" : obj.getValue();
            out.write(value.getBytes("UTF-8"));
            out.write(32);
        }
    }

    private static class StringItemEncoder
    extends AbstractItemEncoder<StringItem> {
        private StringItemEncoder() {
        }

        @Override
        void doSerialize(OutputStream out, StringItem obj) throws IOException, MessageEncodingException {
            out.write(Integer.toString(obj.getLenToWrite()).getBytes("UTF-8"));
            out.write(58);
            out.write(obj.getBytes(), obj.getOffset(), obj.getLenToWrite());
            out.write(32);
        }
    }

    private static class NumberItemEncoder
    extends AbstractItemEncoder<NumberItem> {
        private NumberItemEncoder() {
        }

        @Override
        void doSerialize(OutputStream out, NumberItem obj) throws IOException, MessageEncodingException {
            out.write(obj.getValue().toString().getBytes("UTF-8"));
            out.write(32);
        }
    }

    private static class ListSerializer
    extends AbstractItemEncoder<ListItem> {
        private ListSerializer() {
        }

        @Override
        void doSerialize(OutputStream out, ListItem list) throws IOException, MessageEncodingException {
            out.write(40);
            out.write(32);
            Iterator<Item> iterator = list.iterator();
            while (iterator.hasNext()) {
                Item item = iterator.next();
                EncodingHelper.serialize(out, item);
            }
            out.write(41);
            out.write(32);
        }
    }

    private static class BytesItemEncoder
    extends AbstractItemEncoder<BytesItem> {
        private BytesItemEncoder() {
        }

        @Override
        void doSerialize(OutputStream out, BytesItem obj) throws IOException, MessageEncodingException {
            out.write(String.valueOf(obj.getLen()).getBytes("UTF-8"));
            out.write(58);
            out.write(obj.getValue(), obj.getOffset(), obj.getLen());
            out.write(32);
        }
    }
}

