/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.protocol;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ItemType;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StringItem
implements Item<String> {
    private byte[] bytes;
    private int lenToWrite;
    private int offset;
    private static final DateFormat DATETIMEFORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'000Z'");

    public StringItem(String arg) throws UnsupportedEncodingException {
        this(arg == null ? new byte[]{} : arg.getBytes("UTF-8"));
    }

    public StringItem(Date date) throws UnsupportedEncodingException {
        this(DATETIMEFORMAT.format(date).getBytes("UTF-8"));
    }

    public StringItem(byte[] arg) {
        this(arg, arg.length, 0);
    }

    public StringItem(byte[] arg, int len, int offset) {
        this.bytes = arg;
        this.lenToWrite = len;
        this.offset = offset;
    }

    @Override
    public ItemType getType() {
        return ItemType.STRING;
    }

    @Override
    public String getValue() {
        return new String(this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLenToWrite() {
        return this.lenToWrite;
    }

    public String toString() {
        return this.getValue();
    }
}

