/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.protocol;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ItemType;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.Token;
import com.oracle.subversion.protocol.WordItem;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ListItem
implements Item<List<Item>> {
    private List<Item> items = new ArrayList<Item>();

    public void add(Item item) {
        this.items.add(item);
    }

    public void add(Date date) {
        try {
            this.items.add(new StringItem(date));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void add(String arg) {
        try {
            this.items.add(new StringItem(arg));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void add(Token arg) {
        this.items.add(new WordItem(arg));
    }

    public void add(WordItem arg) {
        this.items.add(arg);
    }

    public void add(int arg) {
        this.items.add(new NumberItem(arg));
    }

    public void add(ListItem arg) {
        this.items.add(arg);
    }

    @Override
    public ItemType getType() {
        return ItemType.LIST;
    }

    @Override
    public List<Item> getValue() {
        return this.items;
    }

    public Iterator<Item> iterator() {
        return this.items.iterator();
    }

    public void add(long arg) {
        this.items.add(new NumberItem(arg));
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("List size:").append(this.items.size());
        str.append(",[");
        for (Item item : this.items) {
            str.append(item.toString()).append(",");
        }
        str.append("]");
        return str.toString();
    }
}

