
PROCEDURE <API NAME WF>(itemtype in VARCHAR2,
                      itemkey in VARCHAR2,
                      actid in NUMBER,
                      funcmode in VARCHAR2,
                      resultout out VARCHAR2) 
IS
  case_table              VARCHAR2(62);
<WF ADDITIONAL TABLES DECLARATION>
  case_sql                VARCHAR2(32767);
  <WF ADDITIONAL SQLS DECLARATION>
  useTableViewInput       VARCHAR2(1);
  model_name              VARCHAR2(25);
  apply_result_name       VARCHAR2(30);
  feature_table_name      VARCHAR2(30);
  table_output            VARCHAR2(1);
  isTableOutput           BOOLEAN := FALSE;
  drop_output             VARCHAR2(1);
  isDropOutput            BOOLEAN := FALSE;
BEGIN
  IF (funcmode = 'RUN') THEN
    case_table := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'CASE_TABLE');
<WF RETRIEVE ADDITIONAL TABLES>
    case_sql := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'CASE_SQL');
<WF RETRIEVE ADDITIONAL SQLS>
    useTableViewInput := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'USE_TABLE_VIEW_INPUT');
    model_name := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'MODEL_NAME');
    feature_table_name := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'FEATURE_TABLE_NAME');
    apply_result_name := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'APPLY_RESULT_NAME');
    table_output := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'TABLE_OUTPUT');
    drop_output := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'DROP_OUTPUT');
    IF (drop_output = 'Y' OR drop_output = 'y') THEN
      isDropOutput := TRUE;
    END IF;
    IF (table_output = 'Y' OR table_output = 'y') THEN
      isTableOutput := TRUE;
    END IF;
    IF (useTableViewInput = 'Y' OR useTableViewInput = 'y') THEN
      BEGIN
        <API NAME TT>(case_table,
                      <additional_table_array>,
                      model_name,
                      feature_table_name,
                      apply_result_name,
                      isTableOutput,
                      isDropOutput);
        resultout :='COMPLETE:T';
      EXCEPTION WHEN OTHERS THEN
        resultout :='COMPLETE:F';
      END;
      RETURN;
    ELSE
      BEGIN
        <API NAME ST>(case_sql,
                      <additional_sql_array>,
                      model_name,
                      feature_table_name,
                      apply_result_name,
                      isTableOutput,
                      isDropOutput);
        resultout :='COMPLETE:T';
      EXCEPTION WHEN OTHERS THEN
        resultout :='COMPLETE:F';
      END;
      RETURN;
    END IF;
  END IF;

  IF (funcmode = 'CANCEL') THEN
    resultout :='COMPLETE:';
    RETURN;
  END IF;
  
  EXCEPTION
  WHEN others THEN
    wf_core.context('<PACKAGE NAME>', '<API NAME WF>', itemtype, itemkey, actid, funcmode);
    RAISE;
END;
