
FUNCTION <API NAME RT>(tempTables IN OUT NOCOPY TABLE_ARRAY,
                       case_data IN SQL_STATEMENT_TYPE,
                       additional_data IN QUERY_ARRAY,
                       model_name IN VARCHAR2,
                       feature_table IN VARCHAR2) RETURN NUMBER
IS
  apply_result_query  LSTMT_REC_TYPE;
  v_cursor            NUMBER;
BEGIN
  execute immediate 'Alter session set NLS_NUMERIC_CHARACTERS=".,"';

  IF (model_exist(model_name) = FALSE) THEN
    RAISE_APPLICATION_ERROR(-20002, 'Model does not exist: '||model_name);
  END IF;
  <API NAME HP>(tempTables, case_data, additional_data, model_name, feature_table, apply_result_query);
  
  v_cursor := DBMS_SQL.OPEN_CURSOR;
  -- use DBMS_PARSE to parse the apply_result_query and return the CURSOR
  --dump_varchar2a(apply_result_query.lstmt);
  DBMS_SQL.PARSE(
    c             => v_cursor,
    statement     => apply_result_query.lstmt, 
    lb            => apply_result_query.lb,
    ub            => apply_result_query.ub,
    lfflg         => FALSE,
    language_flag => dbms_sql.native);
  
  RETURN v_cursor;
 
EXCEPTION WHEN OTHERS THEN
  IF DBMS_SQL.IS_OPEN(v_cursor) THEN
    DBMS_SQL.CLOSE_CURSOR(v_cursor);
  END IF;
  RAISE; 
END;

/* Real time Apply, Input: SQL queries, Output: Result Set */
FUNCTION <API NAME SR>(case_sql IN VARCHAR2,
                    <additional_sql_params>,
                    model_name IN VARCHAR2 DEFAULT <model_name default>,
                    feature_table IN VARCHAR2 DEFAULT <feature_table_name default>) RETURN  <TYPE TABLE NAME>
IS
  additional_sql  QUERY_ARRAY := QUERY_ARRAY(
    <additional_sql_array>
  );
  v_tempTables  TABLE_ARRAY := TABLE_ARRAY();
  v_cursor      NUMBER;
  v_feedback    INTEGER;
<APPLY RESULT COLUMNS DECLARATION>
  v_result      <TYPE RECORD NAME>;
  v_resultSet   <TYPE TABLE NAME> :=  <TYPE TABLE NAME>();
BEGIN
  v_cursor := <API NAME RT>(v_tempTables,
                            case_sql,
                            additional_sql,
                            model_name,
                            feature_table);
  
  -- use DBMS_EXECUTE against the cursor and stuff the result into result set
<DEFINE APPLY RESULT COLUMNS>
  -- Execute
  v_feedback := DBMS_SQL.EXECUTE(v_cursor);  
  LOOP 
    -- Fetch a row 
    IF DBMS_SQL.FETCH_ROWS(v_cursor) > 0 THEN 
      -- Fetch columns from the row 
<RETRIEVE APPLY RESULT COLUMNS>
      v_resultSet.extend;
      v_result := <TYPE RECORD NAME>(<apply_result_type_list>);
      v_resultSet(v_resultSet.count) := v_result;
      -- Process 
    ELSE
      EXIT; 
    END IF; 
  END LOOP; 

  DBMS_SQL.CLOSE_CURSOR(v_cursor);
  DROP_TEMP_TABLES(v_tempTables);

  RETURN v_resultSet;
  
EXCEPTION WHEN OTHERS THEN
  DROP_TEMP_TABLES(v_tempTables);
  IF DBMS_SQL.IS_OPEN(v_cursor) THEN
    DBMS_SQL.CLOSE_CURSOR(v_cursor);
  END IF;
  RAISE;
END;

/* Real time Apply, Input: SQL queries, Output: Cursor */
FUNCTION <API NAME SC>(case_sql IN VARCHAR2,
                    <additional_sql_params>,
                    model_name IN VARCHAR2 DEFAULT <model_name default>,
                    feature_table IN VARCHAR2 DEFAULT <feature_table_name default>) RETURN NUMBER
IS
  additional_sql  QUERY_ARRAY := QUERY_ARRAY(
    <additional_sql_array>
  );
  v_tempTables  TABLE_ARRAY := TABLE_ARRAY();
  v_cursor      NUMBER;
  v_gen_caseId  BOOLEAN := <generate caseid default>;
  v_gen_text    BOOLEAN := <generate text default>;
BEGIN
  IF (v_gen_caseId) THEN
    RAISE_APPLICATION_ERROR(-20001, 'This function is not supported because of temp table creation for missing user specified caseid');
  END IF;
  
  IF (v_gen_text) THEN
    RAISE_APPLICATION_ERROR(-20002, 'This function is not supported because of temp table creation for text processing');
  END IF;

  v_cursor := <API NAME RT>(v_tempTables,
                            case_sql,
                            additional_sql,
                            model_name,
                            feature_table);
  RETURN v_cursor;

EXCEPTION WHEN OTHERS THEN
  RAISE; 
END;
