
PROCEDURE <API NAME HP>(tempTables IN OUT NOCOPY TABLE_ARRAY,
                        case_data IN SQL_STATEMENT_TYPE,
                        additional_data IN QUERY_ARRAY,
                        model_name IN VARCHAR2,
                        feature_table IN VARCHAR2,
                        apply_result_query IN OUT NOCOPY LSTMT_REC_TYPE)
IS
  v_2d_view                 LSTMT_REC_TYPE;
  v_txn_views               LSTMT_REC_TYPE_ARRAY := LSTMT_REC_TYPE_ARRAY();
  v_tmp_lstmt               LSTMT_REC_TYPE;
  v_case_data               SQL_STATEMENT_TYPE := case_data;
  v_gen_caseId              BOOLEAN := <generate caseid default>;
  v_txt_build               VARCHAR2(30);
  v_txt_test                VARCHAR2(30);
  v_content_index           VARCHAR2(30);
  v_content_index_pref      VARCHAR2(30);
  v_category_temp_table     VARCHAR2(30);
  v_term_final_table        VARCHAR2(30);
  v_term_final_table_index  VARCHAR2(30);
  v_term_final_table_test   VARCHAR2(30);
  pragma autonomous_transaction;
BEGIN 
  IF (v_gen_caseId) THEN
    v_case_data := ADD_TEMP_TABLE(tempTables, create_new_temp_table_name('DM$T'));
    EXECUTE IMMEDIATE 'CREATE TABLE '||v_case_data||' as SELECT rownum as <CASEID>, t.* FROM ('||case_data||') t ';
    EXECUTE IMMEDIATE 'ALTER TABLE '||v_case_data||' add constraint '||create_new_temp_table_name('PK')||' primary key (<CASEID>)';
  END IF;

<INPUT DATA PREPARATION>

<DATA TRANSFORMATIONS>
  
<MINING DATA PREPARATION>
  
<APPLY OPERATION>

  apply_result_query := v_tmp_lstmt;
  -- SELECT statement should be created with a long stack 

EXCEPTION WHEN OTHERS THEN
  RAISE; 
END;

PROCEDURE <API NAME BT>(case_data IN SQL_STATEMENT_TYPE,
                        additional_data IN QUERY_ARRAY,
                        model_name IN VARCHAR2,
                        feature_table IN VARCHAR2,
                        apply_result_name IN VARCHAR2,
                        table_output IN BOOLEAN,
                        drop_output IN BOOLEAN) 
IS
  v_tempTables        TABLE_ARRAY := TABLE_ARRAY();
  v_tmp_lstmt         LSTMT_REC_TYPE;
  apply_result_query  LSTMT_REC_TYPE;
  v_cursor            NUMBER;
  v_feedback          INTEGER;
  v_gen_caseId        BOOLEAN := <generate caseid default>;
  v_gen_text          BOOLEAN := <generate text default>;
BEGIN
  execute immediate 'Alter session set NLS_NUMERIC_CHARACTERS=".,"';

  IF (model_exist(model_name) = FALSE) THEN
    RAISE_APPLICATION_ERROR(-20002, 'Model does not exist: '||model_name);
  END IF;
  CHECK_RESULTS(drop_output, apply_result_name);
  
  <API NAME HP>(v_tempTables, case_data, additional_data, model_name, feature_table, v_tmp_lstmt);

  v_cursor := DBMS_SQL.OPEN_CURSOR;
  IF (table_output = FALSE) THEN
    IF (v_gen_caseId OR v_gen_text) THEN
      ls_append(apply_result_query, 'CREATE TABLE ');
    ELSE
      ls_append(apply_result_query, 'CREATE VIEW ');
    END IF;
  ELSE
    ls_append(apply_result_query, 'CREATE TABLE ');
  END IF;
  ls_append(apply_result_query, apply_result_name);
  ls_append(apply_result_query, ' AS ( ');
  ls_append(apply_result_query, v_tmp_lstmt);
  ls_append(apply_result_query, ' ) ');
  --dump_varchar2a(apply_result_query.lstmt);
  DBMS_SQL.PARSE(
    c             => v_cursor,
    statement     => apply_result_query.lstmt, 
    lb            => apply_result_query.lb,
    ub            => apply_result_query.ub,
    lfflg         => FALSE,
    language_flag => dbms_sql.native);
  v_feedback := DBMS_SQL.EXECUTE(v_cursor);
  DBMS_SQL.CLOSE_CURSOR(v_cursor);
  DROP_TEMP_TABLES(v_tempTables);
    
EXCEPTION WHEN OTHERS THEN
  DROP_TEMP_TABLES(v_tempTables);
  IF DBMS_SQL.IS_OPEN(v_cursor) THEN
    DBMS_SQL.CLOSE_CURSOR(v_cursor);
  END IF;
  RAISE;
END;

/* Batch Apply, Input: Tables/Views, Output: Tables/Views */
PROCEDURE <API NAME>(case_table IN VARCHAR2 DEFAULT <case_table default>,
                        <additional_table_params>,
                        model_name IN VARCHAR2 DEFAULT <model_name default>,
                        feature_table IN VARCHAR2 DEFAULT <feature_table_name default>,
                        apply_result_name IN VARCHAR2 DEFAULT <apply_result_name default>,
                        table_output IN BOOLEAN DEFAULT <table_output default>,
                        drop_output IN BOOLEAN DEFAULT <drop_output default>) 
IS
BEGIN
  <API NAME TT>(case_table,
              <additional_table_array>,
              model_name,
              feature_table,
              apply_result_name,
              table_output,
              drop_output);

EXCEPTION WHEN OTHERS THEN
    RAISE; 
END;

/* Batch Apply, Input: Tables/Views, Output: Tables/Views */
PROCEDURE <API NAME TT>(case_table IN VARCHAR2 DEFAULT <case_table default>,
                        <additional_table_params>,
                        model_name IN VARCHAR2 DEFAULT <model_name default>,
                        feature_table IN VARCHAR2 DEFAULT <feature_table_name default>,
                        apply_result_name IN VARCHAR2 DEFAULT <apply_result_name default>,
                        table_output IN BOOLEAN DEFAULT <table_output default>,
                        drop_output IN BOOLEAN DEFAULT <drop_output default>) 
IS
  additional_table  QUERY_ARRAY := QUERY_ARRAY(
    <additional_table_array>
  );
BEGIN
  <API NAME BT>(case_table,
              additional_table,
              model_name,
              feature_table,
              apply_result_name,
              table_output,
              drop_output);

EXCEPTION WHEN OTHERS THEN
    RAISE; 
END;

/* Batch Apply, Input: SQL queries, Output: Tables/Views */
PROCEDURE <API NAME ST>(case_sql IN VARCHAR2,
                        <additional_sql_params>,
                        model_name IN VARCHAR2 DEFAULT <model_name default>,
                        feature_table IN VARCHAR2 DEFAULT <feature_table_name default>,
                        apply_result_name IN VARCHAR2 DEFAULT <apply_result_name default>,
                        table_output IN BOOLEAN DEFAULT <table_output default>,
                        drop_output IN BOOLEAN DEFAULT <drop_output default>)
IS
  additional_sql  QUERY_ARRAY := QUERY_ARRAY(
    <additional_sql_array>
  );
BEGIN
  <API NAME BT>(case_sql,
              additional_sql,
              model_name,
              feature_table,
              apply_result_name,
              table_output,
              drop_output);

EXCEPTION WHEN OTHERS THEN
    RAISE; 
END;
