
PROCEDURE <API NAME>(case_table IN VARCHAR2 DEFAULT <case_table default>,
                        <additional_table_params>,
                        model_name IN VARCHAR2 DEFAULT <model_name default>,
                        feature_table IN VARCHAR2 DEFAULT <feature_table_name default>,
                        mapping_table IN VARCHAR2 DEFAULT <mapping_table_name default>,
                        drop_model IN BOOLEAN DEFAULT <drop_output default>)
IS
  additional_data  TABLE_ARRAY := TABLE_ARRAY(
    <additional_table_array>
  );
  v_tempTables              TABLE_ARRAY := TABLE_ARRAY();
  v_2d_view                 VARCHAR2(30);
  v_2d_temp_view            VARCHAR2(30);
  v_txn_views               TABLE_ARRAY := TABLE_ARRAY();
  v_txn_temp_views          TABLE_ARRAY := TABLE_ARRAY();
  v_case_data               SQL_STATEMENT_TYPE := case_table;
  v_case_id                 VARCHAR2(30) := '<CASEID>';
  v_tmp_lstmt               LSTMT_REC_TYPE;
  v_build_data              VARCHAR2(30);
  v_build_setting           VARCHAR2(30);
  v_gen_caseId              BOOLEAN := <generate caseid default>;
  v_txt_build               VARCHAR2(30);
  v_txt_test                VARCHAR2(30);
  v_content_index           VARCHAR2(30);
  v_content_index_pref      VARCHAR2(30);
  v_category_temp_table     VARCHAR2(30);
  v_term_final_table        VARCHAR2(30);
  v_term_final_table_index  VARCHAR2(30);
  v_mapping_table_index     VARCHAR2(30);
  pragma autonomous_transaction;
BEGIN
  execute immediate 'Alter session set NLS_NUMERIC_CHARACTERS=".,"';

  CHECK_MODEL(drop_model, model_name);
  CHECK_RESULTS(drop_model, feature_table);
  CHECK_RESULTS(drop_model, mapping_table);

  IF (v_gen_caseId) THEN
    v_case_data := ADD_TEMP_TABLE(v_tempTables, create_new_temp_table_name('DM$T'));
    EXECUTE IMMEDIATE 'CREATE TABLE '||v_case_data||' as SELECT rownum as <CASEID>, t.* FROM ('||case_table||') t ';
    EXECUTE IMMEDIATE 'ALTER TABLE '||v_case_data||' add constraint '||create_new_temp_table_name('PK')||' primary key (<CASEID>)';
  END IF;
  
<INPUT DATA PREPARATION>

<DATA TRANSFORMATIONS>
  
<MINING DATA PREPARATION>
  
<BUILD SETTING>

  -- BUILD MODEL
  DBMS_DATA_MINING.CREATE_MODEL(
    model_name          => model_name,
    mining_function     => dbms_data_mining.clustering,
    data_table_name     => v_build_data,
    case_id_column_name => v_case_id,
    settings_table_name => v_build_setting);

  DROP_TEMP_TABLES(v_tempTables);

EXCEPTION WHEN OTHERS THEN
  DROP_TEMP_TABLES(v_tempTables);
  RAISE; 
END;
