/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import java.util.Dictionary;
import oracle.bali.ewt.worker.InvocationContext;
import oracle.bali.ewt.worker.Worker;
import oracle.bali.ewt.worker.WorkerStatusAdapter;
import oracle.bali.ewt.worker.WorkerStatusListener;
import oracle.bali.ewt.worker.WorkerUtils;

public class SpawningWorkerStatus
extends WorkerStatusAdapter {
    private Worker _successWorker;
    private WorkerStatusListener _successListener;
    private Worker _failureWorker;
    private WorkerStatusListener _failureListener;

    public SpawningWorkerStatus(Worker worker, Worker worker2) {
        this(worker, null, worker2, null);
    }

    public SpawningWorkerStatus(Worker worker, WorkerStatusListener workerStatusListener, Worker worker2, WorkerStatusListener workerStatusListener2) {
        this._successWorker = worker;
        this._successListener = workerStatusListener;
        this._failureWorker = worker2;
        this._failureListener = workerStatusListener2;
    }

    public void workerSucceeded(InvocationContext invocationContext) {
        SpawningWorkerStatus._runOrQueueResult(this._successWorker, invocationContext, WorkerUtils.getMainResult(invocationContext), this._successListener);
    }

    public void workerFailed(InvocationContext invocationContext) {
        SpawningWorkerStatus._runOrQueueResult(this._failureWorker, invocationContext, WorkerUtils.getFailureCause(invocationContext), this._failureListener);
    }

    private static void _runOrQueueResult(Worker worker, InvocationContext invocationContext, Object object, WorkerStatusListener workerStatusListener) {
        if (worker != null) {
            Dictionary dictionary = WorkerUtils.createParameters(InvocationContext.PARENT_CONTEXT, invocationContext);
            WorkerUtils.putNullableValue(dictionary, InvocationContext.PARAMETER_VALUE, object);
            WorkerUtils.runOrQueueWorker(worker, dictionary, workerStatusListener);
        }
    }
}

