/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.model.BooleanModel;
import oracle.bali.ewt.worker.AbstractWorker;
import oracle.bali.ewt.worker.Worker;

public abstract class ControlledWorker
extends AbstractWorker {
    public static final String WORKER_ENABLED_MODEL = "EnabledModel";
    private transient ChangeListener _enabledListener;
    private transient boolean _isModelEnabled = true;

    protected ControlledWorker() {
    }

    public static void setEnabledModel(Worker worker, BooleanModel booleanModel) {
        worker.putValue(WORKER_ENABLED_MODEL, booleanModel);
    }

    public static BooleanModel getEnabledModel(Worker worker) {
        return (BooleanModel)worker.getValue(WORKER_ENABLED_MODEL);
    }

    public final void setEnabledModel(BooleanModel booleanModel) {
        ControlledWorker.setEnabledModel(this, booleanModel);
    }

    public final BooleanModel getEnabledModel() {
        return ControlledWorker.getEnabledModel(this);
    }

    public boolean isEnabled() {
        return this._isModelEnabled && super.isEnabled();
    }

    public Object putValue(Object object, Object object2) {
        Object object3 = super.putValue(object, object2);
        if (WORKER_ENABLED_MODEL.equals(object)) {
            boolean bl = this.isEnabled();
            BooleanModel booleanModel = (BooleanModel)object3;
            BooleanModel booleanModel2 = (BooleanModel)object2;
            if (booleanModel != booleanModel2) {
                if (this._enabledListener != null) {
                    booleanModel.removeChangeListener(this._enabledListener);
                }
                if (booleanModel2 != null) {
                    if (this._enabledListener == null) {
                        this._enabledListener = new EnabledListener();
                    }
                    this._isModelEnabled = booleanModel2.getState();
                    booleanModel2.addChangeListener(this._enabledListener);
                } else {
                    this._isModelEnabled = true;
                    this._enabledListener = null;
                }
                this.fireEnabledPropertyChange(bl);
            }
        }
        return object3;
    }

    public Object clone() {
        ControlledWorker controlledWorker = (ControlledWorker)super.clone();
        BooleanModel booleanModel = this.getEnabledModel();
        EnabledListener enabledListener = null;
        if (booleanModel != null) {
            enabledListener = controlledWorker.new EnabledListener();
            booleanModel.addChangeListener(enabledListener);
        }
        controlledWorker._enabledListener = enabledListener;
        return controlledWorker;
    }

    private class EnabledListener
    implements ChangeListener {
        private EnabledListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            boolean bl = ((BooleanModel)changeEvent.getSource()).getState();
            if (ControlledWorker.this._isModelEnabled != bl) {
                boolean bl2 = ControlledWorker.this.isEnabled();
                ControlledWorker.this._isModelEnabled = bl;
                ControlledWorker.this.fireEnabledPropertyChange(bl2);
            }
        }
    }
}

