/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardPage;

public class ReentrantWizard
extends BaseWizard {
    private static final int _WIDTH;
    private static final int _HEIGHT;
    private JTabbedPane _tabPanel;
    boolean _dontValidate;
    private Model _model = new Model();
    private static final String _TAB_NAME = "Reentrant_TabbedPane";

    public ReentrantWizard() {
        this(false);
    }

    public ReentrantWizard(boolean bl) {
        super(bl);
        this._tabPanel = new JTabbedPane();
        this._tabPanel.setName(_TAB_NAME);
        this._tabPanel.setModel(this._model);
        this._tabPanel.addChangeListener(this._model);
        this.add((Component)this._tabPanel, "Center");
    }

    public synchronized WizardPage addPage(WizardPage wizardPage, WizardPage wizardPage2) {
        int n = wizardPage2 == null ? this._tabPanel.getTabCount() : this._tabPanel.indexOfComponent(wizardPage2.getContent());
        super.addPageImpl(wizardPage, wizardPage2);
        this._tabPanel.insertTab(wizardPage.getLabel(), null, wizardPage.getContent(), wizardPage.getLabel(), n);
        if (!wizardPage.isEnabled()) {
            this._tabPanel.setEnabledAt(n, false);
        }
        if (!wizardPage.isVisible()) {
            this._tabPanel.removeTabAt(n);
        }
        if (this.getSelectedPage() == null && wizardPage.isEnabled() && wizardPage.isVisible()) {
            this.selectPage(wizardPage, false);
        }
        return wizardPage;
    }

    public synchronized void removePage(WizardPage wizardPage) {
        this._dontValidate = true;
        this._tabPanel.remove(wizardPage.getContent());
        this._dontValidate = false;
        super.removePage(wizardPage);
    }

    public synchronized void removeAllPages() {
        int n = this.getPageCount();
        while (--n >= 0) {
            this.removePage(this.getPageAt(n));
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(_WIDTH, _HEIGHT);
    }

    public void dispose() {
        super.dispose();
        if (this._tabPanel == null) {
            return;
        }
        this._tabPanel.removeChangeListener(this._model);
        this._tabPanel = null;
        this._model = null;
    }

    protected void doPrevious() {
        WizardPage wizardPage = this.getPreviousPage(this.getSelectedPage());
        if (wizardPage != null) {
            this.selectPage(wizardPage);
        }
    }

    protected void doNext() {
        WizardPage wizardPage = this.getNextPage(this.getSelectedPage());
        if (wizardPage != null) {
            this.selectPage(wizardPage);
        }
    }

    protected boolean getMustFinish() {
        return false;
    }

    protected void selectPage(WizardPage wizardPage, boolean bl) {
        WizardPage wizardPage2 = this.getSelectedPage();
        if (bl && !this.pageSelectionChanging(wizardPage)) {
            return;
        }
        this._dontValidate = true;
        super.selectPage(wizardPage, bl);
        wizardPage = this.getSelectedPage();
        if (wizardPage != null) {
            this._tabPanel.setSelectedComponent(wizardPage.getContent());
        }
        this._dontValidate = false;
    }

    protected boolean pageSelectionChanging(WizardPage wizardPage) {
        return true;
    }

    protected void resetFocus(WizardPage wizardPage) {
        if (!this._tabPanel.hasFocus()) {
            super.resetFocus(wizardPage);
        }
    }

    protected void enableButtons() {
        super.enableButtons();
        this._tabPanel.setEnabled(this.isEnabled());
    }

    protected void pagePropertyChange(WizardPage wizardPage, PropertyChangeEvent propertyChangeEvent) {
        super.pagePropertyChange(wizardPage, propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        int n = this._getPageIndex(wizardPage);
        if (string.equals("enabled")) {
            this._tabPanel.setEnabledAt(n, (Boolean)object);
        } else if (string.equals("visible")) {
            boolean bl = (Boolean)object;
            if (bl) {
                this._tabPanel.insertTab(wizardPage.getLabel(), null, wizardPage.getContent(), wizardPage.getLabel(), n);
            } else {
                this._tabPanel.removeTabAt(n);
            }
        } else if (string.equals("content")) {
            this._tabPanel.setComponentAt(n, (Component)object);
        } else if (string.equals("label")) {
            this._tabPanel.setTitleAt(n, (String)object);
            this._tabPanel.setToolTipTextAt(n, (String)object);
        }
    }

    private int _getPageIndex(WizardPage wizardPage) {
        int n = this.getPageCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            WizardPage wizardPage2 = this.getPageAt(n3);
            if (wizardPage2 == wizardPage) break;
            if (wizardPage2.isVisible()) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private WizardPage _getPageAt(int n) {
        int n2 = this.getPageCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            WizardPage wizardPage = this.getPageAt(n4);
            if (wizardPage.isVisible()) {
                if (n3 == n) {
                    return wizardPage;
                }
                ++n3;
            }
            ++n4;
        }
        return null;
    }

    static {
        if (Toolkit.getDefaultToolkit().getScreenResolution() < 120) {
            _WIDTH = 600;
            _HEIGHT = 430;
        } else {
            _WIDTH = 750;
            _HEIGHT = 530;
        }
    }

    private class Model
    extends DefaultSingleSelectionModel
    implements ChangeListener {
        private Model() {
        }

        public void setSelectedIndex(int n) {
            if (n >= 0) {
                WizardPage wizardPage = ReentrantWizard.this._getPageAt(n);
                if (!(ReentrantWizard.this._dontValidate || ReentrantWizard.this.pageSelectionChanging(wizardPage) && ReentrantWizard.this.validateSelectedPage())) {
                    return;
                }
            }
            super.setSelectedIndex(n);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!ReentrantWizard.this._dontValidate) {
                int n = this.getSelectedIndex();
                WizardPage wizardPage = n >= 0 ? ReentrantWizard.this._getPageAt(n) : null;
                ReentrantWizard.this.selectPage(wizardPage, false);
            }
        }
    }
}

