/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.spinBox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.access.OracleAccessibleRole;
import oracle.bali.ewt.elaf.EWTSpinnerUI;
import oracle.bali.ewt.spinBox.BuddyTextField;
import oracle.bali.ewt.spinBox.NumericSpinBoxModel;
import oracle.bali.ewt.spinBox.SpinAccelerator;
import oracle.bali.ewt.spinBox.SpinBoxModel;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.bali.ewt.spinBox.SpinButton;
import oracle.bali.ewt.spinBox.SpinButtonEvent;
import oracle.bali.ewt.spinBox.SpinButtonListener;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.collection.Range;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.util.IntegerUtils;

public class SpinBox
extends LWComponent
implements Accessible,
SpinButtonListener {
    private SpinButton _spinButton;
    private SpinBuddy _buddy;
    private Component _buddyComponent;
    private Object _value;
    private SpinBoxModel _model;
    private ListenerManager _listeners;
    private static int _sInstanceCounter;
    private static final int _GAP = 1;
    private static final BackGroundChangeListener _BACKGROUND_CHANGE_LISTENER;
    private transient ChangeEvent _changeEvent;
    private SpinListener _spinListener = new SpinListener();

    public SpinBox() {
        this(new BuddyTextField(), new NumericSpinBoxModel(new Range(0, 0)));
    }

    public SpinBox(SpinBuddy spinBuddy, SpinBoxModel spinBoxModel) {
        if (spinBuddy == null) {
            throw new IllegalArgumentException();
        }
        if (spinBoxModel == null) {
            throw new IllegalArgumentException();
        }
        this.addKeyListener(this._spinListener);
        this.addFocusListener(this._spinListener);
        this._spinButton = this.createSpinButton();
        this._spinButton.addSpinButtonListener(this);
        this.setLayout(null);
        this.setSpinBuddy(spinBuddy);
        this.setModel(spinBoxModel);
        this.add(this.getSpinButton());
        this.updateUI();
    }

    public void updateUI() {
        this.setUI((EWTSpinnerUI)UIManager.getUI(this));
        this._updateBackground();
    }

    private void _updateBackground() {
        if (this._buddyComponent == null || this.getUIDefaults() == null) {
            return;
        }
        Color color = this._buddyComponent.getBackground();
        if (color == null) {
            color = this.getUIDefaults().getColor("EWTSpinner.background");
        }
        this.setBackground(color);
    }

    public String getUIClassID() {
        return "EWTSpinnerUI";
    }

    public void setSpinBuddy(SpinBuddy spinBuddy) {
        if (spinBuddy == null) {
            throw new IllegalArgumentException();
        }
        if (this._buddyComponent != null) {
            this._buddyComponent.removeKeyListener(this._spinListener);
            this._buddyComponent.removeFocusListener(this._spinListener);
            this._buddyComponent.removePropertyChangeListener(_BACKGROUND_CHANGE_LISTENER);
            this.remove(this._buddyComponent);
        }
        this._buddy = spinBuddy;
        this._buddyComponent = (Component)((Object)this._buddy);
        Object object = this.getValue();
        if (object != null) {
            spinBuddy.setValue(object);
        }
        this._buddyComponent.addKeyListener(this._spinListener);
        this._buddyComponent.addFocusListener(this._spinListener);
        this._buddyComponent.addPropertyChangeListener(_BACKGROUND_CHANGE_LISTENER);
        this.add(this._buddyComponent);
    }

    public SpinAccelerator getAccelerator() {
        return this.getSpinButton().getAccelerator();
    }

    public void setAccelerator(SpinAccelerator spinAccelerator) {
        this.getSpinButton().setAccelerator(spinAccelerator);
    }

    public Object getValue() {
        return this._value;
    }

    public SpinBoxModel getModel() {
        return this._model;
    }

    public void setModel(SpinBoxModel spinBoxModel) {
        this._model = spinBoxModel;
        this._buddy.setValue(this._nextElement(true));
        this._updateEnabled();
        this.fireStateChanged();
    }

    public SpinBuddy getSpinBuddy() {
        return this._buddy;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._listeners.removeListener((EventListener)changeListener);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = UIManager.getInt("EWTSpinner.innerXMargin");
        Component component = this._buddyComponent;
        Dimension dimension2 = component.getPreferredSize();
        EWTSpinnerUI eWTSpinnerUI = (EWTSpinnerUI)this.ui;
        ImmInsets immInsets = this.getBorderInsets();
        ImmInsets immInsets2 = eWTSpinnerUI.getSpinButtonInsets(this);
        int n2 = immInsets.left + n;
        dimension.width -= n2 + immInsets.right;
        dimension.height -= immInsets.top + immInsets.bottom;
        int n3 = (dimension.height - dimension2.height) / 2;
        if (n3 < 0) {
            n3 = 0;
            dimension2.height = dimension.height;
        }
        SpinButton spinButton = this.getSpinButton();
        Dimension dimension3 = spinButton.getPreferredSize();
        int n4 = immInsets2.top;
        dimension3.height = dimension.height - (immInsets2.top + immInsets2.bottom);
        dimension3.width -= immInsets2.left + immInsets2.right;
        if (this.getActualAlignment() != 2) {
            component.setBounds(n2, n3 + immInsets.top, dimension.width - dimension3.width - 1, dimension2.height);
            spinButton.setBounds(dimension.width - dimension3.width + n2 + immInsets2.left, n4 + immInsets.top, dimension3.width, dimension3.height);
        } else {
            component.setBounds(dimension3.width + 1 + n2, n3 + immInsets.top, dimension.width - dimension3.width - 1, dimension2.height);
            spinButton.setBounds(n2 + immInsets2.left, n4 + immInsets.top, dimension3.width, dimension3.height);
        }
    }

    public boolean isFocusTraversable() {
        return !this._buddyComponent.isFocusTraversable();
    }

    public void requestFocus() {
        if (this._buddyComponent.isFocusTraversable()) {
            this._buddyComponent.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void setEnabled(boolean bl) {
        this.getSpinButton().setEnabled(bl);
        this._buddyComponent.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void setFont(Font font) {
        this._buddyComponent.setFont(font);
        super.setFont(font);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSpinBox();
        }
        return this.accessibleContext;
    }

    protected Object getPaintData(Object object) {
        if (object.equals("GapX")) {
            Rectangle rectangle = this._spinButton.getBounds();
            if (this.getActualAlignment() != 2) {
                return IntegerUtils.getInteger((int)(rectangle.x - 1));
            }
            return IntegerUtils.getInteger((int)(rectangle.x + rectangle.width));
        }
        return super.getPaintData(object);
    }

    protected String paramString() {
        return "value=" + this.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addImpl(Component component, Object object, int n) {
        if (component != this._spinButton && component != this._buddy) {
            if (!(component instanceof SpinBuddy)) throw new IllegalArgumentException();
            this.setSpinBuddy((SpinBuddy)((Object)component));
            return;
        } else {
            super.addImpl(component, object, n);
        }
    }

    public void spinButtonSpinning(SpinButtonEvent spinButtonEvent) {
        if (this._buddyComponent.isFocusTraversable()) {
            this._buddyComponent.requestFocus();
        } else {
            this.requestFocus();
        }
        this.doIncrement(spinButtonEvent.getType() == 1);
    }

    protected void fireStateChanged() {
        Object object;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (object = listenerManager.getListeners()) != null) {
            while (object.hasMoreElements()) {
                ChangeListener changeListener = (ChangeListener)object.nextElement();
                if (this._changeEvent == null) {
                    this._changeEvent = new ChangeEvent(this);
                }
                changeListener.stateChanged(this._changeEvent);
            }
        }
        if ((object = this.accessibleContext) != null) {
            ((AccessibleContext)object).firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }
    }

    protected void doIncrement(boolean bl) {
        this._model.setIteratingForward(bl);
        this.getSpinBuddy().setValue(this._nextElement(false));
        this._updateEnabled();
        this.fireStateChanged();
    }

    protected SpinButton createSpinButton() {
        return new SpinButton(false);
    }

    protected SpinButton getSpinButton() {
        return this._spinButton;
    }

    void _updateEnabled() {
        SpinBoxModel spinBoxModel = this._model;
        SpinButton spinButton = this.getSpinButton();
        boolean bl = spinBoxModel.isIteratingForward();
        spinBoxModel.setIteratingForward(true);
        spinButton.setIncrementEnabled(spinBoxModel.hasMoreElements());
        spinBoxModel.setIteratingForward(false);
        spinButton.setDecrementEnabled(spinBoxModel.hasMoreElements());
        spinBoxModel.setIteratingForward(bl);
    }

    private Object _nextElement(boolean bl) {
        SpinAccelerator spinAccelerator = this.getAccelerator();
        if (bl || spinAccelerator == null) {
            this._value = this._model.nextElement();
        } else {
            int n = this._model.remainingElements(spinAccelerator.getIncrement());
            this._value = this._model.skip(n);
        }
        return this._value;
    }

    static {
        _BACKGROUND_CHANGE_LISTENER = new BackGroundChangeListener();
    }

    private static class BackGroundChangeListener
    implements PropertyChangeListener {
        private BackGroundChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Component component;
            Container container;
            if ("background".equals(propertyChangeEvent.getPropertyName()) && (container = (component = (Component)propertyChangeEvent.getSource()).getParent()) instanceof SpinBox && component.getBackground() != null) {
                container.setBackground(component.getBackground());
            }
        }
    }

    private class SpinListener
    extends KeyAdapter
    implements FocusListener {
        private SpinListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            boolean bl;
            SpinButton spinButton = SpinBox.this.getSpinButton();
            int n = keyEvent.getKeyCode();
            boolean bl2 = bl = keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown() || keyEvent.isShiftDown();
            if (n != 38 && n != 40 || bl) {
                spinButton.setIncrementArmed(false);
                spinButton.setDecrementArmed(false);
            } else if (!keyEvent.isConsumed()) {
                boolean bl3;
                boolean bl4 = bl3 = n == 38;
                if (bl3 && spinButton.isIncrementEnabled() || !bl3 && spinButton.isDecrementEnabled()) {
                    if (bl3) {
                        spinButton.setIncrementArmed(true);
                    } else {
                        spinButton.setDecrementArmed(true);
                    }
                    SpinBox.this.doIncrement(bl3);
                    SpinAccelerator spinAccelerator = SpinBox.this.getAccelerator();
                    if (spinAccelerator != null) {
                        spinAccelerator.advance();
                    }
                }
                keyEvent.consume();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            boolean bl;
            boolean bl2 = bl = keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown() || keyEvent.isShiftDown();
            if (!bl && !keyEvent.isConsumed()) {
                switch (keyEvent.getKeyCode()) {
                    case 38: {
                        SpinBox.this.getSpinButton().setIncrementArmed(false);
                        break;
                    }
                    case 40: {
                        SpinBox.this.getSpinButton().setDecrementArmed(false);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                SpinAccelerator spinAccelerator = SpinBox.this.getAccelerator();
                if (spinAccelerator != null) {
                    spinAccelerator.reset();
                }
                keyEvent.consume();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            SpinButton spinButton = SpinBox.this.getSpinButton();
            spinButton.setIncrementArmed(false);
            spinButton.setDecrementArmed(false);
        }

        public void focusGained(FocusEvent focusEvent) {
        }
    }

    protected class AccessibleSpinBox
    extends JComponent.AccessibleJComponent {
        protected AccessibleSpinBox() {
            super(SpinBox.this);
        }

        public AccessibleRole getAccessibleRole() {
            return OracleAccessibleRole.SPIN_BOX;
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return super.getAccessibleName();
        }

        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            return super.getAccessibleDescription();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (accessibleStateSet.contains(AccessibleState.ENABLED)) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleValue getAccessibleValue() {
            SpinBuddy spinBuddy = SpinBox.this.getSpinBuddy();
            if (spinBuddy != null && spinBuddy instanceof Accessible) {
                return ((Accessible)((Object)spinBuddy)).getAccessibleContext().getAccessibleValue();
            }
            return null;
        }

        public AccessibleAction getAccessibleAction() {
            return SpinBox.this.getSpinButton().getAccessibleContext().getAccessibleAction();
        }
    }
}

