/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.ruler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import oracle.bali.ewt.elaf.EWTRulerUI;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.bali.ewt.ruler.RulerStyle;
import oracle.bali.ewt.scrolling.ScrollableComponent;

public class Ruler
extends ScrollableComponent
implements Accessible {
    public static final int MARKER_NOT_VISIBLE = -1;
    private static final int _DEFAULT_SIZE = 20;
    private static final String _TEST_STRING = "111";
    private static final int _NUMBERGAP = 2;
    private static final int _MINIMUMTICKGAP = 3;
    private static final int _EXTRA_SIZE = 7;
    private int _orientation;
    private boolean _showNumbers;
    private RulerStyle _rulerStyle;
    private int _markerPosition;
    private int _scrollPosition;
    private int _increment;

    public Ruler() {
        this(0);
    }

    public Ruler(int n) {
        this._orientation = n;
        this._markerPosition = -1;
        this._scrollPosition = 0;
        this._showNumbers = true;
        this._increment = 1;
        this.updateUI();
    }

    public int getMarkerPosition() {
        return this._markerPosition;
    }

    public int getScrollPosition() {
        return this._scrollPosition;
    }

    public RulerStyle getRulerStyle() {
        if (this._rulerStyle == null) {
            this._rulerStyle = RulerStyle.getInches();
        }
        return this._rulerStyle;
    }

    public int getOrientation() {
        return this._orientation;
    }

    public boolean getShowNumbers() {
        return this._showNumbers;
    }

    public void setRulerStyle(RulerStyle rulerStyle) {
        if (rulerStyle != this._rulerStyle) {
            RulerStyle rulerStyle2 = this._rulerStyle;
            this._rulerStyle = rulerStyle;
            AccessibleContext accessibleContext = this.accessibleContext;
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleVisibleData", rulerStyle2, this._rulerStyle);
            }
            this.repaintInterior();
        }
    }

    public void setOrientation(int n) {
        if (n != this._orientation) {
            int n2 = this._orientation;
            this._orientation = n;
            this.firePropertyChange("orientation", n2, n);
            this.repaintInterior();
        }
    }

    public void setMarkerPosition(int n) {
        if (this._markerPosition != n) {
            int n2 = this._markerPosition;
            this.freezeRepaints();
            try {
                if (this._isHorizontal()) {
                    this.repaintCanvas(this._markerPosition - 1, 0, 2, this.getInnerSize().height);
                } else {
                    this.repaintCanvas(0, this._markerPosition, this.getInnerSize().width, 2);
                }
                this._markerPosition = n;
                this.firePropertyChange("markerPosition", n2, n);
                if (this._isHorizontal()) {
                    this.repaintCanvas(this._markerPosition - 1, 0, 2, this.getInnerSize().height);
                } else {
                    this.repaintCanvas(0, this._markerPosition, this.getInnerSize().width, 2);
                }
                Object var4_3 = null;
                this.unfreezeRepaints();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.unfreezeRepaints();
                throw throwable;
            }
        }
    }

    public void setShowNumbers(boolean bl) {
        if (bl != this.getShowNumbers()) {
            Boolean bl2 = new Boolean(this._showNumbers);
            this._showNumbers = bl;
            this.firePropertyChange("showNumbers", !bl, bl);
            this.repaintInterior();
        }
    }

    public void setScrollPosition(int n) {
        if (n != this.getScrollPosition()) {
            int n2 = this._scrollPosition;
            this._scrollPosition = n;
            this.firePropertyChange("scrollPosition", n2, this._scrollPosition);
            if (this._isHorizontal()) {
                this.setCanvasOrigin(-this._scrollPosition, 0);
            } else {
                this.setCanvasOrigin(0, -this._scrollPosition);
            }
        }
    }

    public void setNumberIncrement(int n) {
        if (this._increment != n) {
            int n2 = this._increment;
            this._increment = n;
            this.firePropertyChange("numberIncrement", n2, this._increment);
            this.repaintInterior();
        }
    }

    public int getNumberIncrement() {
        return this._increment;
    }

    public EWTRulerUI getRulerUI() {
        return (EWTRulerUI)this.ui;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleRuler();
        }
        return this.accessibleContext;
    }

    public boolean isHScrollable() {
        return this._isHorizontal();
    }

    public boolean isVScrollable() {
        return !this._isHorizontal();
    }

    public void updateUI() {
        this.setUI((EWTRulerUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "EWTRulerUI";
    }

    protected Object getPaintData(Object object) {
        if ("ruler.horizontal".equals(object)) {
            return this._isHorizontal() ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getPaintData(object);
    }

    protected void paintCanvasInterior(Graphics graphics) {
        int n;
        int n2;
        int n3;
        boolean bl;
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            rectangle = this.getInnerBounds();
        }
        int n4 = (bl = this._isHorizontal()) ? this.getInnerHeight() : this.getInnerWidth();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Color color = graphics.getColor();
        Color color2 = this.getUIDefaults().getColor("EWTRuler.numberColor");
        int n5 = fontMetrics.getAscent() + fontMetrics.getLeading();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (bl) {
            n3 = rectangle.x + rectangle.width;
            n2 = n4;
        } else {
            n2 = n4;
            n3 = rectangle.y + rectangle.height;
        }
        int n6 = 2 + fontMetrics.stringWidth("888");
        n3 += n6;
        RulerStyle rulerStyle = this.getRulerStyle();
        if (rulerStyle.getTickCount() == 0) {
            this._paintMarker(graphics, n4);
            return;
        }
        double d = rulerStyle.getPixelsPerTick();
        if (d == 0.0) {
            this._paintMarker(graphics, n4);
            return;
        }
        int n7 = rulerStyle.getTick(0).getFrequency();
        if (n7 != 0) {
            d /= (double)n7;
        }
        int n8 = bl ? rectangle.x : rectangle.y;
        int n9 = rulerStyle.getTickCount();
        int n10 = (int)Math.round((double)(n8 -= n6) / d);
        while ((n = (int)Math.round(d * (double)n10)) <= n3) {
            int n11;
            int n12 = 0;
            int n13 = 0;
            while (n13 < n9) {
                n11 = rulerStyle.getTick(n13).getFrequency();
                if (n11 == 0) break;
                if (n10 % n11 == 0 && d * (double)n11 >= 3.0) {
                    n12 = rulerStyle.getTick(n13).getSize() * n2 / 100;
                    break;
                }
                ++n13;
            }
            if (n12 > 0) {
                graphics.setColor(color);
                if (bl) {
                    graphics.drawLine(n, n4 - n12 - 1, n, n4 - 1);
                } else {
                    graphics.drawLine(n4 - n12 - 1, n, n4 - 1, n);
                }
            }
            n11 = rulerStyle.getTick(0).getFrequency();
            if (this.getShowNumbers() && n11 != 0 && n10 % n11 == 0 && d * (double)n11 >= 3.0) {
                int n14;
                int n15;
                long l = (long)n10 * (long)this.getNumberIncrement();
                String string = Long.toString(l / (long)n11);
                if (bl) {
                    n15 = n + 2;
                    n14 = n5;
                } else {
                    n15 = 2;
                    n14 = n + n5;
                }
                graphics.setColor(color2);
                GraphicUtils.drawString(graphics, string, n15, n14);
            }
            ++n10;
        }
        this._paintMarker(graphics, n4);
    }

    protected Dimension layoutCanvas() {
        int n = 0;
        int n2 = 0;
        Font font = this.getFont();
        int n3 = font == null ? 20 : ((Component)this).getFontMetrics(font).stringWidth(_TEST_STRING) + 7;
        Dimension dimension = this._getScrollPaneContentPreferredSize();
        if (this._isHorizontal()) {
            n = dimension == null ? 0x1FFFFFFF : dimension.width;
            n2 = n3;
        } else {
            n2 = dimension == null ? 0x1FFFFFFF : dimension.height;
            n = n3;
        }
        return new Dimension(n, n2);
    }

    private Dimension _getScrollPaneContentPreferredSize() {
        JScrollPane jScrollPane;
        Container container;
        Object var1_1 = null;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane && (jScrollPane = (JScrollPane)container).getViewport() != null) {
            return jScrollPane.getViewport().getViewSize();
        }
        return null;
    }

    private void _paintMarker(Graphics graphics, int n) {
        int n2 = this.getMarkerPosition();
        if (n2 != -1) {
            graphics.setColor(this.getUIDefaults().getColor("EWTRuler.numberColor"));
            if (this._isHorizontal()) {
                graphics.drawLine(n2, 0, n2, n);
            } else {
                graphics.drawLine(0, n2, n, n2);
            }
        }
    }

    private boolean _isHorizontal() {
        return this.getOrientation() == 0;
    }

    protected class AccessibleRuler
    extends JComponent.AccessibleJComponent {
        protected AccessibleRuler() {
            super(Ruler.this);
        }
    }
}

