/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.print;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.print.PrinterGraphics;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JComponent;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.print.IntegerPrinterGraphics;
import oracle.bali.ewt.print.IntegerPrinterGraphics2D;
import oracle.bali.ewt.print.PrintPaintContext;
import oracle.bali.ewt.print.StackPrintGraphics;
import oracle.bali.share.collection.StringKey;
import oracle.bali.share.util.IntegerUtils;

public class PrinterUtils {
    public static final Object PAGE_KEY = new StringKey("CurrPage");
    public static final Object XYPAGE_KEY = new StringKey("CurrXYPage");
    public static final Object PAGE_DIMENSION_KEY = new StringKey("PageSize");
    public static final Object CONTENT_DIMENSION_KEY = new StringKey("ContentSize");
    public static final Object PAGE_COUNT_KEY = new StringKey("PageCount");

    private PrinterUtils() {
    }

    public static void print(JComponent jComponent, Dictionary dictionary, boolean bl, Frame frame, String string, Painter painter, Painter painter2, Painter painter3, double d, double d2, double d3, double d4) {
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(frame, string, null);
        if (printJob != null) {
            PrinterUtils.print(jComponent, dictionary, bl, printJob, painter, painter2, painter3, d, d2, d3, d4);
            printJob.end();
        }
    }

    public static void print(JComponent jComponent, Dictionary dictionary, boolean bl, PrintJob printJob, Painter painter, Painter painter2, Painter painter3, double d, double d2, double d3, double d4) {
        int n = printJob.getPageResolution();
        PrinterUtils.print(jComponent, dictionary, bl, printJob, painter, painter2, painter3, (int)((double)n * d), (int)((double)n * d2), (int)((double)n * d3), (int)((double)n * d4));
    }

    public static void print(JComponent jComponent, Dictionary dictionary, boolean bl, Frame frame, String string, Painter painter, Painter painter2, Painter painter3, int n, int n2, int n3, int n4) {
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(frame, string, null);
        if (printJob != null) {
            PrinterUtils.print(jComponent, dictionary, bl, printJob, painter, painter2, painter3, n, n2, n3, n4);
            printJob.end();
        }
    }

    public static void print(JComponent jComponent, Dictionary hashtable, boolean bl, PrintJob printJob, Painter painter, Painter painter2, Painter painter3, int n, int n2, int n3, int n4) {
        if (hashtable == null) {
            hashtable = new Hashtable<Object, Serializable>(1);
        }
        Dimension dimension = printJob.getPageDimension();
        int n5 = dimension.width - n2 - n4;
        int n6 = dimension.height - n - n3;
        ((Dictionary)hashtable).put(PAGE_DIMENSION_KEY, new Dimension(n5, n6));
        Graphics graphics = PrinterUtils._getPrintGraphics(printJob, jComponent);
        PrintPaintContext printPaintContext = new PrintPaintContext(jComponent, hashtable);
        int n7 = 1;
        Integer n8 = (Integer)((Dictionary)hashtable).get(PAGE_KEY);
        if (n8 != null) {
            n7 = n8 + 1;
        }
        int n9 = n7;
        int n10 = 1;
        printPaintContext.updatePage(graphics, n7, n10, n9);
        int n11 = 0;
        int n12 = 0;
        if (painter != null) {
            n11 = painter.getPreferredSize((PaintContext)printPaintContext).height;
        }
        if (painter2 != null) {
            n12 = painter2.getPreferredSize((PaintContext)printPaintContext).height;
        }
        LWComponent lWComponent = jComponent instanceof LWComponent ? (LWComponent)jComponent : null;
        int n13 = n5;
        int n14 = n6 - n11 - n12;
        ((Dictionary)hashtable).put(CONTENT_DIMENSION_KEY, new Dimension(n13, n14));
        Dimension dimension2 = lWComponent == null ? jComponent.getSize() : lWComponent.getDocumentSize(printPaintContext, hashtable);
        int n15 = 1;
        int n16 = 0;
        int n17 = 0;
        int n18 = 1;
        int n19 = dimension2.height;
        int n20 = dimension2.width;
        if (!bl) {
            n15 = 0;
            n16 = 1;
            n17 = 1;
            n18 = 0;
            n19 = dimension2.width;
            n20 = dimension2.height;
        }
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        while (n23 < n19) {
            int n24 = 0;
            Rectangle rectangle = null;
            while (n24 < n20) {
                if (n11 != 0) {
                    painter.paint(printPaintContext, graphics, n2, n, n5, n11);
                }
                if (n12 != 0) {
                    painter2.paint(printPaintContext, graphics, n2, dimension.height - n3 - n12, n5, n12);
                }
                rectangle = lWComponent == null ? new Rectangle(n13, n14, n13, n14) : lWComponent.getPageBounds(printPaintContext, hashtable, n21, n22, n13, n14);
                int n25 = rectangle.height;
                graphics.translate(n2, n + n11);
                graphics.setClip(0, 0, rectangle.width, rectangle.height);
                graphics.translate(-n21, -n22);
                if (lWComponent == null) {
                    jComponent.print(graphics);
                } else {
                    lWComponent.printPage(printPaintContext, hashtable, graphics);
                }
                if (painter3 != null) {
                    painter3.paint(printPaintContext, graphics, n21, n22, rectangle.width, rectangle.height);
                }
                if ((n24 = bl ? (n21 += rectangle.x) : (n22 += rectangle.y)) >= n20) continue;
                graphics.dispose();
                graphics = PrinterUtils._getPrintGraphics(printJob, jComponent);
                printPaintContext.updatePage(graphics, ++n7, n10 += n18, n9 += n17);
            }
            if (bl) {
                n21 = 0;
                n10 = 1;
                n23 = n22 += rectangle.y;
            } else {
                n22 = 0;
                n9 = 1;
                n23 = n21 += rectangle.x;
            }
            if (n23 >= n19) continue;
            graphics.dispose();
            graphics = PrinterUtils._getPrintGraphics(printJob, jComponent);
            printPaintContext.updatePage(graphics, ++n7, n10 += n16, n9 += n15);
        }
        ((Dictionary)hashtable).put(PAGE_KEY, IntegerUtils.getInteger((int)n7));
    }

    public static Object getPrinterProperty(Dictionary dictionary, Object object, Object object2) {
        Object v;
        if (dictionary != null && (v = dictionary.get(object)) != null) {
            return v;
        }
        return object2;
    }

    public static boolean getPrinterProperty(Dictionary dictionary, Object object, boolean bl) {
        try {
            Boolean bl2 = (Boolean)PrinterUtils.getPrinterProperty(dictionary, object, null);
            if (bl2 != null) {
                return bl2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static Graphics getIntegerPrintGraphics(PrinterGraphics printerGraphics) {
        if (printerGraphics instanceof Graphics2D) {
            return new IntegerPrinterGraphics2D(printerGraphics);
        }
        return new IntegerPrinterGraphics(printerGraphics);
    }

    private static Graphics _getPrintGraphics(PrintJob printJob, JComponent jComponent) {
        StackPrintGraphics stackPrintGraphics = new StackPrintGraphics(printJob.getGraphics());
        ((Graphics)stackPrintGraphics).setColor(jComponent.getForeground());
        ((Graphics)stackPrintGraphics).setFont(jComponent.getFont());
        return stackPrintGraphics;
    }
}

