/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIManager;
import oracle.bali.ewt.elaf.EWTPivotGridGridUI;
import oracle.bali.ewt.elaf.EWTPivotGridHeaderUI;
import oracle.bali.ewt.elaf.EWTPivotGridUI;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.NullOneDModel;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotGridLayout;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEvent;

public class PivotGrid
extends SpreadTable {
    private int _dragItem;
    private boolean _horizontal;
    private boolean _resizing;
    private PivotTable _pivotTable;
    private _DSListen _modelListener = new _DSListen();
    private PropertyChangeListener _focusChangeListener = new FocusChangeListener();

    public PivotGrid(TwoDModel twoDModel) {
        Grid grid = this.getGrid();
        this.setModel(twoDModel);
        grid.setUpperLeft(false);
        grid.setUpperRight(false);
        grid.setLowerLeft(false);
        grid.setLowerRight(true);
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(2, 2, 2);
        grid.setGridSelectionManager(generalGridSelectionManager);
        grid.setVerticalSeparatorsVisible(true);
        grid.setHorizontalSeparatorsVisible(true);
        grid.setDrawFocusCellHighlite(true);
        Header header = this.getColumnHeader();
        GeneralHeaderSelectionManager generalHeaderSelectionManager = new GeneralHeaderSelectionManager(2);
        header.setHeaderSelectionManager(generalHeaderSelectionManager);
        header.setCanMoveItems(false);
        header.addPropertyChangeListener(this._focusChangeListener);
        header = this.getRowHeader();
        generalHeaderSelectionManager = new GeneralHeaderSelectionManager(2);
        header.setHeaderSelectionManager(generalHeaderSelectionManager);
        header.setCanMoveItems(false);
        header.addPropertyChangeListener(this._focusChangeListener);
        this._dragItem = -1;
        this.updateUI();
    }

    public void dispose() {
        this.setModel(null);
        this._modelListener = null;
        this._focusChangeListener = null;
        super.dispose();
    }

    public String getUIClassID() {
        return "EWTPivotGridUI";
    }

    public final TwoDModel getModel() {
        return this.getGrid().getModel();
    }

    public void setModel(TwoDModel twoDModel) {
        TwoDModel twoDModel2 = this.getModel();
        if (twoDModel2 != null) {
            twoDModel2.removeModelListener(this._modelListener);
        }
        if (twoDModel == null) {
            twoDModel = NullTwoDModel.getTwoDModel();
        }
        this.setModels(twoDModel, new NullOneDModel(twoDModel.getColumnCount()), new NullOneDModel(twoDModel.getRowCount()));
        twoDModel.addModelListener(this._modelListener);
    }

    public final AppearanceManager getAppearanceManager() {
        return this.getGrid().getAppearanceManager();
    }

    public final void setAppearanceManager(AppearanceManager appearanceManager) {
        this.getGrid().setAppearanceManager(appearanceManager);
    }

    public final PivotTable getPivotTable() {
        return this._pivotTable;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getGrid().getPreferredSize();
        dimension.height += this.getColumnHeaderHeight();
        dimension.width += this.getRowHeaderWidth();
        return this.convertInnerToOuterSize(dimension.width, dimension.height);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getGrid().getMinimumSize();
        dimension.height += this.getColumnHeaderHeight();
        dimension.width += this.getRowHeaderWidth();
        return this.convertInnerToOuterSize(dimension.width, dimension.height);
    }

    public void updateUI() {
        this.setUI((EWTPivotGridUI)UIManager.getUI(this));
        this.getGrid().setOverlayBorderVisible(false);
        this.getGrid().setBorder(null);
        if (this.getPivotTable() != null) {
            this.updateLayout();
            this.getPivotTable().__updateHorizontalSizes();
            this.getPivotTable().__updateVerticalSizes();
        }
    }

    public void setDrawRaised(boolean bl) {
        super.setDrawRaised(bl);
        this.getRowHeader().setDrawRaised(bl);
        this.getColumnHeader().setDrawRaised(bl);
    }

    protected LayoutManager createLayoutManager() {
        return new PivotGridLayout();
    }

    protected void processResizeEvent(TableEvent tableEvent) {
        super.processResizeEvent(tableEvent);
        if (tableEvent instanceof Cancelable && ((Cancelable)((Object)tableEvent)).isCancelled()) {
            return;
        }
        int n = tableEvent.getID();
        switch (n) {
            case 2001: {
                this._dragItem = tableEvent.getColumn();
                this._horizontal = true;
                break;
            }
            case 2003: {
                this._dragItem = tableEvent.getRow();
                this._horizontal = false;
                break;
            }
            case 2002: {
                this._dragItem = -1;
                break;
            }
            case 2004: {
                this._dragItem = -1;
            }
        }
        PivotTable pivotTable = this.getPivotTable();
        if (this._horizontal) {
            pivotTable.getColumnPivotHeader().setResizeItem(this._dragItem);
        } else {
            pivotTable.getRowPivotHeader().setResizeItem(this._dragItem);
        }
    }

    protected boolean isSelectAllEnabled() {
        Grid grid = this.getGrid();
        return this.isColumnHeaderVisible() && this.isRowHeaderVisible() && grid.getColumnCount() != 0 && grid.getRowCount() != 0;
    }

    protected final EWTPivotGridUI getPivotGridUI() {
        return (EWTPivotGridUI)this.ui;
    }

    protected final Header createColumnHeader(OneDModel oneDModel) {
        return this.createPivotGridColumnHeader(oneDModel);
    }

    protected PivotGridHeader createPivotGridColumnHeader(OneDModel oneDModel) {
        return new PivotGridHeader(oneDModel, 0);
    }

    protected final Header createRowHeader(OneDModel oneDModel) {
        return this.createPivotGridRowHeader(oneDModel);
    }

    protected PivotGridHeader createPivotGridRowHeader(OneDModel oneDModel) {
        return new PivotGridHeader(oneDModel, 1);
    }

    protected final Grid createGrid(TwoDModel twoDModel) {
        return this.createPivotGridGrid(twoDModel);
    }

    protected PivotGridGrid createPivotGridGrid(TwoDModel twoDModel) {
        return new PivotGridGrid(twoDModel);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
    }

    void setPivotTable(PivotTable pivotTable) {
        this._pivotTable = pivotTable;
    }

    void setCurrentlyResizing(boolean bl) {
        this._resizing = bl;
    }

    boolean currentlyResizing() {
        return this._resizing;
    }

    void checkColumnHeader(int n) {
        PivotTable pivotTable = this.getPivotTable();
        PivotHeader pivotHeader = pivotTable.getColumnPivotHeader();
        int n2 = pivotHeader.getGrid().getCanvasOriginY();
        pivotHeader.getGrid().setCanvasOrigin(n, n2);
    }

    void checkRowHeader(int n) {
        PivotTable pivotTable = this.getPivotTable();
        PivotHeader pivotHeader = pivotTable.getRowPivotHeader();
        int n2 = pivotHeader.getGrid().getCanvasOriginX();
        pivotHeader.getGrid().setCanvasOrigin(n2, n);
    }

    void updateFeedback() {
        if (this._dragItem != -1) {
            PivotTable pivotTable = this.getPivotTable();
            if (this._horizontal) {
                int n = this.getColumnHeader().getItemSize(this._dragItem);
                pivotTable.setColumnWidth(this._dragItem, n);
            } else {
                int n = this.getRowHeader().getItemSize(this._dragItem);
                pivotTable.setRowHeight(this._dragItem, n);
            }
        }
    }

    private class FocusChangeListener
    implements PropertyChangeListener {
        private FocusChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("focusItem".equals(propertyChangeEvent.getPropertyName())) {
                // empty if block
            }
        }
    }

    private class _DSListen
    extends TwoDModelAdapter {
        private _DSListen() {
        }

        public void rowsAdded(TwoDModelEvent twoDModelEvent) {
            NullOneDModel nullOneDModel = (NullOneDModel)PivotGrid.this.getRowHeader().getModel();
            nullOneDModel.addItems(twoDModelEvent.getRowStartIndex(), twoDModelEvent.getRowCount());
        }

        public void rowsRemoved(TwoDModelEvent twoDModelEvent) {
            NullOneDModel nullOneDModel = (NullOneDModel)PivotGrid.this.getRowHeader().getModel();
            nullOneDModel.removeItems(twoDModelEvent.getRowStartIndex(), twoDModelEvent.getRowCount());
        }

        public void columnsAdded(TwoDModelEvent twoDModelEvent) {
            NullOneDModel nullOneDModel = (NullOneDModel)PivotGrid.this.getColumnHeader().getModel();
            nullOneDModel.addItems(twoDModelEvent.getColumnStartIndex(), twoDModelEvent.getColumnCount());
        }

        public void columnsRemoved(TwoDModelEvent twoDModelEvent) {
            NullOneDModel nullOneDModel = (NullOneDModel)PivotGrid.this.getColumnHeader().getModel();
            nullOneDModel.removeItems(twoDModelEvent.getColumnStartIndex(), twoDModelEvent.getColumnCount());
        }
    }

    public class PivotGridHeader
    extends Header {
        public PivotGridHeader(OneDModel oneDModel, int n) {
            super(oneDModel, n);
            this.updateUI();
        }

        public String getUIClassID() {
            return "EWTPivotGridHeaderUI";
        }

        public final void setCanvasOrigin(int n, int n2) {
            if (!PivotGrid.this.currentlyResizing()) {
                super.setCanvasOrigin(n, n2);
            }
        }

        public final Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        protected final Component getScrollParent() {
            return this.getParent();
        }

        protected final void paintExtraCanvas(Graphics graphics, PaintContext paintContext, int n, int n2, int n3, int n4) {
        }

        protected final void processMouseMotionEvent(MouseEvent mouseEvent) {
            PivotTable pivotTable = PivotGrid.this.getPivotTable();
            if (pivotTable != null) {
                pivotTable.freezeRepaints();
            }
            try {
                super.processMouseMotionEvent(mouseEvent);
                if (mouseEvent.getID() == 506) {
                    PivotGrid.this.updateFeedback();
                }
                Object var4_3 = null;
                if (pivotTable != null) {
                    pivotTable.unfreezeRepaints();
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (pivotTable != null) {
                    pivotTable.unfreezeRepaints();
                }
                throw throwable;
            }
        }

        public void updateUI() {
            this.setUI((EWTPivotGridHeaderUI)UIManager.getUI(this));
        }
    }

    public class PivotGridGrid
    extends Grid {
        public PivotGridGrid(TwoDModel twoDModel) {
            super(twoDModel);
            this.updateUI();
        }

        public String getUIClassID() {
            return "EWTPivotGridGridUI";
        }

        public final void updateUI() {
            this.setUI((EWTPivotGridGridUI)UIManager.getUI(this));
        }

        public final Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        protected final Component getScrollParent() {
            return PivotGrid.this.getPivotTable() == null ? super.getScrollParent() : PivotGrid.this.getPivotTable();
        }

        public final void setCanvasOrigin(int n, int n2) {
            if (!PivotGrid.this.currentlyResizing()) {
                super.setCanvasOrigin(n, n2);
            }
        }

        public final void setVerticalSeparatorPainter(Painter painter) {
            super.setVerticalSeparatorPainter(painter);
            if (PivotGrid.this != null && PivotGrid.this.getPivotTable() != null) {
                PivotGrid.this.getPivotTable().__updateVerticalSizes();
            }
        }

        public final void setVerticalSeparatorsVisible(boolean bl) {
            super.setVerticalSeparatorsVisible(bl);
            if (PivotGrid.this != null && PivotGrid.this.getPivotTable() != null) {
                PivotGrid.this.getPivotTable().__updateVerticalSizes();
            }
        }

        public final void setHorizontalSeparatorPainter(Painter painter) {
            super.setHorizontalSeparatorPainter(painter);
            if (PivotGrid.this != null && PivotGrid.this.getPivotTable() != null) {
                PivotGrid.this.getPivotTable().__updateHorizontalSizes();
            }
        }

        public final void setHorizontalSeparatorsVisible(boolean bl) {
            super.setHorizontalSeparatorsVisible(bl);
            if (PivotGrid.this != null && PivotGrid.this.getPivotTable() != null) {
                PivotGrid.this.getPivotTable().__updateHorizontalSizes();
            }
        }

        public final Dimension layoutCanvas() {
            int n = this.getCanvasOriginX();
            int n2 = this.getCanvasOriginY();
            Dimension dimension = super.layoutCanvas();
            int n3 = this.getCanvasOriginX();
            int n4 = this.getCanvasOriginY();
            if (n != n3) {
                PivotGrid.this.checkColumnHeader(n3);
            }
            if (n2 != n4) {
                PivotGrid.this.checkRowHeader(n4);
            }
            return dimension;
        }
    }
}

