/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.IOException;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragGestureListener;
import oracle.bali.ewt.dnd.DragGestureRecognizer;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DragSourceListener;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTransfer;
import oracle.bali.share.datatransfer.TransferUtils;

class PivotDragDropAdapter
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    PivotHeader _pivotHeader;
    private DragGestureRecognizer _headerRecognizer;
    private DragGestureRecognizer _gridRecognizer;
    private DropTarget _gridDropTarget;
    private DropTarget _headerDropTarget;

    public PivotDragDropAdapter(PivotHeader pivotHeader) {
        this._pivotHeader = pivotHeader;
        Header header = PivotDragDropAdapter._isHorizontal(this._pivotHeader) ? this._pivotHeader.getRowHeader() : this._pivotHeader.getColumnHeader();
        this._headerRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(header, 2, this);
        this._headerDropTarget = new DropTarget(header, this);
        Grid grid = this._pivotHeader.getGrid();
        this._gridRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(grid, 2, this);
        this._gridDropTarget = new DropTarget(this._pivotHeader.getGrid(), this);
    }

    public void dispose() {
        this._headerDropTarget.setComponent(null);
        this._headerDropTarget.removeDropTargetListener(this);
        this._headerDropTarget = null;
        this._gridDropTarget.setComponent(null);
        this._gridDropTarget.removeDropTargetListener(this);
        this._gridDropTarget = null;
        this._headerRecognizer.setComponent(null);
        this._headerRecognizer.removeDragGestureListener(this);
        this._headerRecognizer = null;
        this._gridRecognizer.setComponent(null);
        this._gridRecognizer.removeDragGestureListener(this);
        this._gridRecognizer = null;
        this._pivotHeader = null;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._acceptDrag(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        boolean bl = dropTargetDragEvent.getDropTargetContext().getComponent() instanceof Header;
        Point point = dropTargetDragEvent.getLocation();
        boolean bl2 = this._pivotHeader.isSwap(point, bl);
        int n = this._pivotHeader.getDropIndex(point, bl, bl2);
        this._setDropLocation(n, bl2);
    }

    public void dragScroll(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this._setDropLocation(-1, false);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(1);
        this._setDropLocation(-1, false);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        Object object = null;
        try {
            object = transferable.getTransferData(PivotTransfer.DATA_FLAVOR);
        }
        catch (IOException iOException) {
            object = null;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            object = null;
        }
        boolean bl = false;
        if (object != null && object instanceof PivotTransfer) {
            PivotTransfer pivotTransfer = (PivotTransfer)object;
            Object object2 = pivotTransfer.getSource();
            int n = pivotTransfer.getIndex();
            PivotHeader pivotHeader = this._pivotHeader;
            Point point = dropTargetDropEvent.getLocation();
            boolean bl2 = dropTargetDropEvent.getDropTargetContext().getComponent() instanceof Header;
            boolean bl3 = this._pivotHeader.isSwap(point, bl2);
            int n2 = this._pivotHeader.getDropIndex(dropTargetDropEvent.getLocation(), bl2, bl3);
            boolean bl4 = true;
            if (object2 == pivotHeader) {
                if (!bl3 && n < n2) {
                    --n2;
                }
                if (n == n2) {
                    bl4 = false;
                }
            }
            if (bl4) {
                if (!bl3) {
                    this._pivotHeader.firePivotEvent(object2, n, pivotHeader, n2);
                } else {
                    this._pivotHeader.fireSwapEvent(object2, n, pivotHeader, n2);
                }
            }
            bl = true;
        }
        dropTargetDropEvent.dropComplete(bl);
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        boolean bl;
        if (!this._pivotHeader.isDragEnabled() || this._pivotHeader.isDrilling() || this._pivotHeader.getResizeItem() != -1) {
            return;
        }
        Point point = dragGestureEvent.getDragOrigin();
        int n = this._pivotHeader.getDragIndex(point, bl = dragGestureEvent.getComponent() != this._pivotHeader.getGrid());
        if (n != -1) {
            Image image = this._pivotHeader.getDragImage(n);
            this._pivotHeader.setDragItem(n);
            this._adjustOrigin(point, bl, n);
            dragGestureEvent.startDrag(null, image, point, PivotTransfer.createTransferable(this._pivotHeader, n), this);
            Object[] objectArray = dragGestureEvent.toArray();
            Object object = objectArray[objectArray.length - 1];
            if (object instanceof InputEvent) {
                ((InputEvent)object).consume();
            }
        }
    }

    private void _adjustOrigin(Point point, boolean bl, int n) {
        boolean bl2;
        boolean bl3 = bl2 = this._pivotHeader.getOrientation() == 0;
        if (bl) {
            Header header = this._pivotHeader.getHeader();
            int n2 = header.getItemAt(point.x, point.y);
            if (n2 != -1) {
                if (bl2) {
                    point.x = 5;
                    point.y -= header.getItemPosition(n2);
                    point.y = -point.y;
                } else {
                    point.x -= header.getItemPosition(n2);
                    point.x = -point.x;
                    point.y = 5;
                }
            }
        } else {
            Grid grid = this._pivotHeader.getGrid();
            int n3 = grid.getColumnAt(point.x);
            int n4 = grid.getRowAt(point.y);
            if (n3 != -1 && n4 != -1) {
                if (bl2) {
                    point.x = 5;
                    point.y -= grid.getRowPosition(n4);
                    point.y = -point.y;
                } else {
                    point.x -= grid.getColumnPosition(n3);
                    point.x = -point.x;
                    point.y = 5;
                }
            }
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this._pivotHeader.setDragItem(-1);
    }

    private boolean _acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._pivotHeader.isEnabled()) {
            return false;
        }
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        if (dataFlavorArray == null) {
            return false;
        }
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (TransferUtils.supportsDataFlavor((DataFlavor)dataFlavorArray[n], (DataFlavor)PivotTransfer.DATA_FLAVOR)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void _setDropLocation(int n, boolean bl) {
        this._pivotHeader.setDropLocation(n, bl);
    }

    private static boolean _isHorizontal(PivotHeader pivotHeader) {
        return pivotHeader.getOrientation() == 0;
    }
}

