/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.text.View;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.AbstractWrappingPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.share.collection.StringKey;

class ViewPainter
extends AbstractWrappingPainter {
    public static final Object VIEW_KEY = new StringKey("View");
    private static Painter _sInstance;

    public static boolean hasView(JComponent jComponent) {
        return jComponent.getClientProperty("html") != null;
    }

    public static View getHTMLView(JComponent jComponent) {
        Object object = jComponent.getClientProperty("html");
        if (object instanceof View) {
            return (View)object;
        }
        return null;
    }

    public ViewPainter(Painter painter) {
        super(painter);
    }

    protected final Painter getWrappedPainter(PaintContext paintContext) {
        if (paintContext.getPaintData(VIEW_KEY) != null) {
            return ViewPainter._getViewPainter();
        }
        return super.getWrappedPainter(paintContext);
    }

    private static Painter _getViewPainter() {
        if (_sInstance == null) {
            _sInstance = new _Painter();
        }
        return _sInstance;
    }

    private static class _Painter
    extends AbstractPainter {
        public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            View view = this._getView(paintContext);
            if (view != null) {
                view.paint(graphics, new Rectangle(n, n2, n3, n4));
            }
        }

        public Dimension getPreferredSize(PaintContext paintContext) {
            View view = this._getView(paintContext);
            int n = 0;
            int n2 = 0;
            if (view != null) {
                n = (int)view.getPreferredSpan(0);
                n2 = (int)view.getPreferredSpan(1);
            }
            return new Dimension(n, n2);
        }

        public Dimension getMinimumSize(PaintContext paintContext) {
            View view = this._getView(paintContext);
            int n = 0;
            int n2 = 0;
            if (view != null) {
                n = (int)view.getMinimumSpan(0);
                n2 = (int)view.getMinimumSpan(1);
            }
            return new Dimension(n, n2);
        }

        public Dimension getMaximumSize(PaintContext paintContext) {
            View view = this._getView(paintContext);
            int n = 0;
            int n2 = 0;
            if (view != null) {
                n = (int)view.getMaximumSpan(0);
                n2 = (int)view.getMaximumSpan(1);
            }
            return new Dimension(n, n2);
        }

        public boolean isTransparent(PaintContext paintContext) {
            return true;
        }

        private View _getView(PaintContext paintContext) {
            return (View)paintContext.getPaintData(VIEW_KEY);
        }
    }
}

