/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.BoundedRangeModel;
import javax.swing.JProgressBar;
import javax.swing.UIDefaults;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.StringUtils;

final class ProgressBarPainter
extends AbstractPainter {
    private static final int _MIN_PREFERRED_WIDTH = 100;
    private static final int _MIN_HEIGHT = 8;
    private static Painter _sInstance;

    private ProgressBarPainter() {
    }

    public static Painter getPainter() {
        if (_sInstance == null) {
            _sInstance = new ProgressBarPainter();
        }
        return _sInstance;
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        String string;
        Color color = graphics.getColor();
        BoundedRangeModel boundedRangeModel = this._getModel(paintContext);
        double d = this._getPercent(boundedRangeModel);
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        Color color2 = paintContext.getPaintForeground();
        int n5 = (int)((double)n3 * d);
        if (n5 > 0) {
            graphics.setColor(color2);
            graphics.fillRect(n, n2, n + n5, n4);
            graphics.setColor(color);
        }
        if ((string = (String)paintContext.getPaintData(PaintContext.LABEL_KEY)) != null) {
            string = StringUtils.getDisplayString(string, paintContext);
            FontMetrics fontMetrics = paintContext.getFontMetrics(paintContext.getPaintFont());
            int n6 = fontMetrics.stringWidth(string);
            int n7 = (n3 - n6) / 2;
            if (n7 < 0) {
                n7 = 0;
            }
            int n8 = fontMetrics.getAscent();
            int n9 = (n4 - (n8 + fontMetrics.getDescent())) / 2 + n8;
            if (n5 > n7) {
                graphics.setColor(uIDefaults.getColor("ProgressBar.textSelectionColor"));
                if (n5 < n7 + n6) {
                    Shape shape = graphics.getClip();
                    graphics.clipRect(n, n2, n5, n4);
                    GraphicUtils.drawString(graphics, string, n + n7, n2 + n9);
                    graphics.setClip(shape);
                    graphics.setColor(uIDefaults.getColor("ProgressBar.textNonSelectionColor"));
                    graphics.clipRect(n + n5, n2, n3 - n5, n4);
                    GraphicUtils.drawString(graphics, string, n + n7, n2 + n9);
                    graphics.setClip(shape);
                } else {
                    GraphicUtils.drawString(graphics, string, n + n7, n2 + n9);
                }
            } else {
                graphics.setColor(uIDefaults.getColor("ProgressBar.textNonSelectionColor"));
                GraphicUtils.drawString(graphics, string, n + n7, n2 + n9);
            }
        }
        graphics.setColor(color);
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        String string = (String)paintContext.getPaintData(PaintContext.LABEL_KEY);
        int n = 0;
        int n2 = 8;
        if (string != null) {
            FontMetrics fontMetrics = paintContext.getFontMetrics(paintContext.getPaintFont());
            n = fontMetrics.stringWidth(string);
            n2 = fontMetrics.getAscent() + fontMetrics.getDescent();
        }
        return new Dimension(n, n2);
    }

    public Dimension getPreferredSize(PaintContext paintContext) {
        BoundedRangeModel boundedRangeModel = this._getModel(paintContext);
        Dimension dimension = this.getMinimumSize(paintContext);
        if (dimension.width < 100) {
            dimension.width = 100;
        }
        return dimension;
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return 0;
    }

    private double _getPercent(BoundedRangeModel boundedRangeModel) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (boundedRangeModel != null) {
            n = boundedRangeModel.getValue();
            n2 = boundedRangeModel.getMinimum();
            n3 = boundedRangeModel.getMaximum();
        }
        double d = n == n2 ? 0.0 : (n == n3 ? 1.0 : ((double)n - (double)n2) / (double)(n3 - n2));
        return d;
    }

    private BoundedRangeModel _getModel(PaintContext paintContext) {
        JProgressBar jProgressBar = (JProgressBar)paintContext.getComponent();
        return jProgressBar.getModel();
    }
}

