/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.AbstractButtonPaintContext;
import oracle.bali.ewt.olaf.BrowserLookAndFeel;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.LabelFGChange;
import oracle.bali.ewt.olaf.OracleFocusPainter;
import oracle.bali.ewt.olaf.OracleInsetBorderPainter;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.olaf.PainterComponent;
import oracle.bali.ewt.olaf.PainterUI;
import oracle.bali.ewt.olaf.ViewPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FGBGColorChange;
import oracle.bali.ewt.painter.FilledRectPainter;
import oracle.bali.ewt.painter.IconPainter;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TruncatingTextPainter;
import oracle.bali.ewt.plaf.DisablingPainter;
import oracle.bali.ewt.plaf.UIUtils;
import oracle.bali.ewt.util.ImmInsets;

public class OracleUIUtils {
    private static final Border _sWideInsetBorder = new oracle.bali.ewt.plaf.BorderAdapter(new OracleInsetBorderPainter(false));
    private static final Border _sNarrowInsetBorder = new oracle.bali.ewt.plaf.BorderAdapter(new OracleInsetBorderPainter(true));
    private static BorderPainter _sFocusPainter;
    private static Painter _sIconPainter;
    private static Painter _sBackgroundPainter;
    private static Painter _sHTMLTextPainter;
    private static Painter _sLabelTextPainter;
    static /* synthetic */ Class class$oracle$bali$ewt$olaf$OracleUIUtils;

    public static int getPaintState(Component component) {
        if (component instanceof JComponent) {
            return OracleUIUtils.getPaintContext((JComponent)component).getPaintState();
        }
        return JPaintContext.getBasePaintState(component);
    }

    public static boolean isLeftToRight(PaintContext paintContext) {
        return paintContext.getReadingDirection() == 1;
    }

    public static int getActualHorizontalAlignment(PaintContext paintContext, int n) {
        if (n == 10) {
            n = OracleUIUtils.isLeftToRight(paintContext) ? 2 : 4;
        } else if (n == 11) {
            n = OracleUIUtils.isLeftToRight(paintContext) ? 4 : 2;
        }
        return n;
    }

    public static boolean pointIsInChild(Container container, int n, int n2) {
        int n3 = container.getComponentCount();
        int n4 = n3 - 1;
        while (n4 >= 0) {
            Component component = container.getComponent(n4);
            if (component != null) {
                int n5;
                int n6;
                Serializable serializable;
                if (component instanceof JComponent) {
                    serializable = (JComponent)component;
                    n6 = ((JComponent)serializable).getX();
                    n5 = ((JComponent)serializable).getY();
                } else {
                    serializable = component.getLocation();
                    n6 = ((Point)serializable).x;
                    n5 = ((Point)serializable).y;
                }
                if (component.contains(n - n6, n2 - n5)) {
                    return true;
                }
            }
            --n4;
        }
        return false;
    }

    public static void putPaintContext(JComponent jComponent) {
        OracleUIUtils.putPaintContext(jComponent, OracleUIUtils._createDefaultContext(jComponent));
    }

    public static void putPaintContext(JComponent jComponent, PaintContext paintContext) {
        JPaintContext.putPaintContext(jComponent, paintContext);
    }

    public static void removePaintContext(JComponent jComponent) {
        JPaintContext.removePaintContext(jComponent);
    }

    public static UIDefaults getUIDefaults(JComponent jComponent) {
        return OracleUIUtils.getPaintContext(jComponent).getPaintUIDefaults();
    }

    public static PaintContext getPaintContext(JComponent jComponent) {
        PaintContext paintContext = JPaintContext.getPaintContext(jComponent);
        if (paintContext != null) {
            return paintContext;
        }
        return OracleUIUtils._createDefaultContext(jComponent);
    }

    public static Dimension getMinimumSize(PainterUI painterUI, JComponent jComponent) {
        return UIUtils.getMinimumSize(OracleUIUtils._getPainter(painterUI, jComponent), OracleUIUtils.getPaintContext(jComponent), jComponent);
    }

    public static Dimension getPreferredSize(PainterUI painterUI, JComponent jComponent) {
        return UIUtils.getPreferredSize(OracleUIUtils._getPainter(painterUI, jComponent), OracleUIUtils.getPaintContext(jComponent), jComponent);
    }

    public static Dimension getMaximumSize(PainterUI painterUI, JComponent jComponent) {
        return UIUtils.getMaximumSize(OracleUIUtils._getPainter(painterUI, jComponent), OracleUIUtils.getPaintContext(jComponent), jComponent);
    }

    public static void paint(PainterUI painterUI, Graphics graphics, JComponent jComponent) {
        UIUtils.paint(graphics, OracleUIUtils._getPainter(painterUI, jComponent), OracleUIUtils.getPaintContext(jComponent), jComponent);
    }

    public static boolean contains(PainterUI painterUI, JComponent jComponent, int n, int n2) {
        return UIUtils.contains(OracleUIUtils._getPainter(painterUI, jComponent), OracleUIUtils.getPaintContext(jComponent), jComponent, n, n2);
    }

    public static ImmInsets getInsets(JComponent jComponent) {
        return UIUtils.getInsets(jComponent);
    }

    public static void fillBackground(Graphics graphics, JComponent jComponent) {
        UIUtils.fillBackground(graphics, jComponent);
    }

    public static Painter getPainter(JComponent jComponent, Object object) {
        Object object2 = OracleUIUtils.getUIDefaults(jComponent).get(object);
        if (object2 instanceof Painter) {
            return (Painter)object2;
        }
        return null;
    }

    public static Painter getIconPainter() {
        if (_sIconPainter == null) {
            _sIconPainter = new IconPainter();
        }
        return _sIconPainter;
    }

    public static Painter getHTMLTextPainter() {
        if (_sHTMLTextPainter == null) {
            _sHTMLTextPainter = new ViewPainter(new DisablingPainter(new TruncatingTextPainter()));
        }
        return _sHTMLTextPainter;
    }

    public static Painter getLabelTextPainter() {
        if (_sLabelTextPainter == null) {
            _sLabelTextPainter = new LabelFGChange(OracleUIUtils.getHTMLTextPainter());
        }
        return _sLabelTextPainter;
    }

    public static Painter getBackgroundPainter() {
        if (_sBackgroundPainter == null) {
            _sBackgroundPainter = new FGBGColorChange(FilledRectPainter.getPainter(), false);
        }
        return _sBackgroundPainter;
    }

    public static Painter getFocusPainter() {
        if (_sFocusPainter == null) {
            _sFocusPainter = new OracleFocusPainter(NullPainter.getPainter());
        }
        return _sFocusPainter;
    }

    public static Border getNarrowInsetBorder() {
        return _sNarrowInsetBorder;
    }

    public static Border getWideInsetBorder() {
        return _sWideInsetBorder;
    }

    public static Image getImage(String string) {
        return ImageUtils.getImageResource(class$oracle$bali$ewt$olaf$OracleUIUtils == null ? (class$oracle$bali$ewt$olaf$OracleUIUtils = OracleUIUtils.class$("oracle.bali.ewt.olaf.OracleUIUtils")) : class$oracle$bali$ewt$olaf$OracleUIUtils, "icons/" + string);
    }

    public static ColorScheme getColorScheme() {
        if (UIManager.getLookAndFeel() instanceof BrowserLookAndFeel) {
            return BrowserLookAndFeel.getColorScheme();
        }
        return OracleLookAndFeel.getColorScheme();
    }

    public static Image getColorizedImage(String string, ColorScheme colorScheme) {
        return ImageUtils.createFilteredImage(OracleUIUtils.getImage(string), colorScheme.createColorizingFilter());
    }

    public static Object cImageInst(UIDefaults uIDefaults, Object object, String string) {
        int n = string.lastIndexOf("%");
        if (n < 0) {
            return OracleUIUtils.getColorizedImage(string, OracleUIUtils.getColorScheme());
        }
        String string2 = string.substring(0, n);
        ColorScheme colorScheme = OracleUIUtils.getColorScheme();
        return OracleUIUtils.getColorizedImage(string2, colorScheme);
    }

    public static Object cIconInst(UIDefaults uIDefaults, Object object, String string) {
        return new ImageIcon((Image)OracleUIUtils.cImageInst(uIDefaults, object, string));
    }

    public static Object imageInst(UIDefaults uIDefaults, Object object, String string) {
        return OracleUIUtils.getImage(string);
    }

    private static ImmInsets _getInsets(JComponent jComponent, boolean bl) {
        ImmInsets immInsets = ImmInsets.getEmptyInsets();
        Border border = jComponent.getBorder();
        if (border != null) {
            if (border instanceof BorderAdapter) {
                BorderPainter borderPainter = ((BorderAdapter)border).getBorderPainter();
                immInsets = bl ? borderPainter.getFillInsets(OracleUIUtils.getPaintContext(jComponent)) : borderPainter.getInsets(OracleUIUtils.getPaintContext(jComponent));
            } else {
                immInsets = new ImmInsets(border.getBorderInsets(jComponent));
            }
        }
        return immInsets;
    }

    private static PaintContext _createDefaultContext(JComponent jComponent) {
        if (jComponent instanceof AbstractButton) {
            return new AbstractButtonPaintContext((AbstractButton)jComponent);
        }
        return new JPaintContext(jComponent);
    }

    private static void _addInsets(JComponent jComponent, Dimension dimension) {
        ImmInsets immInsets = OracleUIUtils.getInsets(jComponent);
        dimension.width += immInsets.left + immInsets.right;
        dimension.height += immInsets.top + immInsets.bottom;
    }

    static Painter _getPainter(PainterUI painterUI, JComponent jComponent) {
        if (jComponent instanceof PainterComponent) {
            return ((PainterComponent)((Object)jComponent)).getPainter();
        }
        return painterUI.getPainter(jComponent);
    }

    private OracleUIUtils() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

