/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.OracleWindowBorder;
import oracle.bali.ewt.olaf.TitleBar;
import oracle.bali.ewt.plaf.BorderAdapter;

public class OracleDesktopIconUI
extends BasicDesktopIconUI {
    private JComponent _iconPane;

    public static ComponentUI createUI(JComponent jComponent) {
        return new OracleDesktopIconUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(new BorderAdapter(new OracleWindowBorder(this._iconPane)));
        jComponent.setOpaque(false);
        LookAndFeel.installColors(jComponent, "DesktopIcon.background", "DesktopIcon.background");
        OracleUIUtils.putPaintContext(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        OracleUIUtils.removePaintContext(jComponent);
    }

    protected void installComponents() {
        this.frame = this.desktopIcon.getInternalFrame();
        this._iconPane = new TitleBar(this.frame);
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this._iconPane, "Center");
    }

    protected void uninstallComponents() {
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this._iconPane);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this._iconPane.getMinimumSize();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        int n = this._iconPane.getPreferredSize().height;
        Border border = this.desktopIcon.getBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets(this.desktopIcon);
            n += insets.top + insets.bottom;
        }
        return new Dimension(dimension.width, n);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this._iconPane.getMaximumSize();
    }

    private OracleDesktopIconUI() {
    }
}

