/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.SwingConstants;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterJoiner;
import oracle.bali.share.collection.StringKey;

class AlignedPainterJoiner
extends PainterJoiner
implements SwingConstants {
    public static final Object HORIZONTAL_TEXT_POSITION = new StringKey("HorizTextPos");
    public static final Object VERTICAL_TEXT_POSITION = new StringKey("VerticalTextPos");
    private static final int _MAIN_INDEX = 0;
    private static final int _SECOND_INDEX = 1;
    private Painter _main;
    private Painter _second;

    public AlignedPainterJoiner(Painter painter, Painter painter2) {
        super(painter, painter2);
        this._main = painter;
        this._second = painter2;
    }

    protected int getActualAlignment(PaintContext paintContext) {
        Object object;
        Object object2 = paintContext.getPaintData(HORIZONTAL_TEXT_POSITION);
        if (object2 != null && object2 instanceof Integer && (object = paintContext.getPaintData(VERTICAL_TEXT_POSITION)) != null && object instanceof Integer) {
            int n = 0;
            int n2 = (Integer)object2;
            switch (OracleUIUtils.getActualHorizontalAlignment(paintContext, n2)) {
                case 4: {
                    n = 6;
                    break;
                }
                case 0: {
                    n = 3;
                    break;
                }
            }
            switch ((Integer)object) {
                case 0: {
                    ++n;
                    break;
                }
                case 3: {
                    n += 2;
                    break;
                }
            }
            return n;
        }
        return super.getActualAlignment(paintContext);
    }

    public Dimension getSize(PaintContext paintContext, int n, int n2) {
        Rectangle[] rectangleArray = this._getPainterBounds(paintContext, 0, 0, n, n2);
        return this._getCombinedSize(paintContext, new Dimension(rectangleArray[0].width, rectangleArray[0].height), new Dimension(rectangleArray[1].width, rectangleArray[1].height), true);
    }

    public Dimension getPreferredSize(PaintContext paintContext) {
        return this._getCombinedSize(paintContext, this._main.getPreferredSize(paintContext), this._second.getPreferredSize(paintContext), true);
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        return this._getCombinedSize(paintContext, this._main.getMinimumSize(paintContext), this._second.getMinimumSize(paintContext), true);
    }

    public Dimension getMaximumSize(PaintContext paintContext) {
        return this._getCombinedSize(paintContext, this._main.getMaximumSize(paintContext), this._second.getMaximumSize(paintContext), false);
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Rectangle[] rectangleArray = this._getPainterBounds(paintContext, n, n2, n3, n4);
        Rectangle rectangle = rectangleArray[0];
        if (rectangle.width > 0 && rectangle.height > 0) {
            this._main.paint(paintContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        Rectangle rectangle2 = rectangleArray[1];
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            this._second.paint(paintContext, graphics, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
    }

    public Painter getPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        Rectangle[] rectangleArray = this._getPainterBounds(paintContext, 0, 0, n, n2);
        Rectangle rectangle = rectangleArray[1];
        Painter painter2 = this._second.getPainterAt(paintContext, rectangle.width, rectangle.height, n3 - rectangle.x, n4 - rectangle.y, painter);
        if (painter2 == null) {
            Rectangle rectangle2 = rectangleArray[0];
            painter2 = this._main.getPainterAt(paintContext, rectangle2.width, rectangle2.height, n3 - rectangle2.x, n4 - rectangle2.y, painter);
        }
        if (painter == this && painter2 != null) {
            painter2 = this;
        }
        return painter2;
    }

    private Dimension _getCombinedSize(PaintContext paintContext, Dimension dimension, Dimension dimension2, boolean bl) {
        int n = this.getActualAlignment(paintContext);
        if (n / 3 != 1 || n % 3 == 1) {
            if (bl) {
                if (dimension2.height > dimension.height) {
                    dimension.height = dimension2.height;
                }
            } else if (dimension2.height < dimension.height) {
                dimension.height = dimension2.height;
            }
        } else {
            dimension.height += dimension2.height;
        }
        if (n / 3 == 1) {
            if (bl) {
                if (dimension2.width > dimension.width) {
                    dimension.width = dimension2.width;
                }
            } else if (dimension2.width < dimension.width) {
                dimension.width = dimension2.width;
            }
        } else {
            dimension.width += dimension2.width;
        }
        return dimension;
    }

    private Rectangle[] _getPainterBounds(PaintContext paintContext, int n, int n2, int n3, int n4) {
        Rectangle[] rectangleArray = new Rectangle[2];
        Dimension dimension = this._main.getPreferredSize(paintContext);
        Dimension dimension2 = this._second.getPreferredSize(paintContext);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        rectangleArray[0] = rectangle;
        rectangleArray[1] = rectangle2;
        rectangle.x = n;
        rectangle.y = n2;
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        rectangle2.x = n;
        rectangle2.y = n2;
        rectangle2.height = dimension2.height;
        int n5 = this.getActualAlignment(paintContext);
        switch (n5 % 3) {
            case 0: {
                if (n5 / 3 != 1) break;
                rectangle2.height = n4 - rectangle.height;
                if (rectangle2.height < 0) {
                    rectangle2.height = 0;
                }
                if (rectangle2.height > dimension2.height) {
                    rectangle2.height = dimension2.height;
                }
                rectangle.y += rectangle2.height;
                break;
            }
            case 1: {
                rectangle2.y += (n4 - dimension2.height + 1) / 2;
                rectangle.y += (n4 - dimension.height + 1) / 2;
                break;
            }
            case 2: {
                if (n5 / 3 != 1) {
                    int n6 = Math.max(dimension.height, dimension2.height);
                    if (n6 > n4) {
                        if (dimension2.height == n6) {
                            rectangle.y = n2 + n6 - dimension.height;
                            break;
                        }
                        rectangle2.y = n2 + n6 - dimension2.height;
                        break;
                    }
                    rectangle.y = n2 + n6 - dimension.height;
                    rectangle2.y = n2 + n6 - dimension2.height;
                    break;
                }
                rectangle2.y += rectangle.height;
                rectangle2.height = n4 - rectangle.height;
                if (rectangle2.height < 0) {
                    rectangle2.height = 0;
                }
                if (rectangle2.height <= dimension2.height) break;
                rectangle2.height = dimension2.height;
            }
        }
        switch (n5 / 3) {
            case 0: {
                rectangle2.width = n3 - rectangle.width;
                if (rectangle2.width < 0) {
                    rectangle2.width = 0;
                }
                if (rectangle2.width > dimension2.width) {
                    rectangle2.width = dimension2.width;
                }
                rectangle.x += rectangle2.width;
                break;
            }
            case 1: {
                rectangle2.x += (n3 - dimension2.width) / 2;
                rectangle.x += (n3 - dimension.width) / 2;
                rectangle2.width = dimension2.width;
                break;
            }
            case 2: {
                rectangle2.x += rectangle.width;
                rectangle2.width = n3 - rectangle.width;
                if (rectangle2.width < 0) {
                    rectangle2.width = 0;
                }
                if (rectangle2.width <= dimension2.width) break;
                rectangle2.width = dimension2.width;
            }
        }
        if (rectangle.width > n3) {
            rectangle.width = n3;
        }
        if (rectangle.height > n4) {
            rectangle.height = n4;
        }
        return rectangleArray;
    }
}

