/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.model;

import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.bali.ewt.model.EmptyOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.bali.share.event.ListenerManager;

public class OneDListModel
implements ListModel {
    private OneDModel _toAdapt;
    private ListenerManager _listeners;

    public OneDListModel(OneDModel oneDModel) {
        if (oneDModel == null) {
            oneDModel = EmptyOneDModel.getOneDModel();
        }
        this._toAdapt = oneDModel;
        this._toAdapt.addModelListener(new ModelListener());
    }

    public OneDModel getModel() {
        return this._toAdapt;
    }

    public int getSize() {
        return this.getModel().getItemCount();
    }

    public Object getElementAt(int n) {
        return this.getModel().getData(n);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)listDataListener);
        }
    }

    private void _fireEvent(ListDataEvent listDataEvent) {
        if (this._listeners == null) {
            return;
        }
        Enumeration enumeration = this._listeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (listDataEvent.getType()) {
            case 1: {
                while (enumeration.hasMoreElements()) {
                    ((ListDataListener)enumeration.nextElement()).intervalAdded(listDataEvent);
                }
                break;
            }
            case 2: {
                while (enumeration.hasMoreElements()) {
                    ((ListDataListener)enumeration.nextElement()).intervalRemoved(listDataEvent);
                }
                break;
            }
            case 0: {
                while (enumeration.hasMoreElements()) {
                    ((ListDataListener)enumeration.nextElement()).contentsChanged(listDataEvent);
                }
                break;
            }
        }
    }

    private class ModelListener
    implements OneDModelListener {
        private ModelListener() {
        }

        public void itemsAdded(OneDModelEvent oneDModelEvent) {
            ListDataEvent listDataEvent = new ListDataEvent(this, 1, oneDModelEvent.getStartIndex(), oneDModelEvent.getStartIndex() + oneDModelEvent.getItemCount() - 1);
            OneDListModel.this._fireEvent(listDataEvent);
        }

        public void itemsRemoved(OneDModelEvent oneDModelEvent) {
            ListDataEvent listDataEvent = new ListDataEvent(this, 2, oneDModelEvent.getStartIndex(), oneDModelEvent.getStartIndex() + oneDModelEvent.getItemCount() - 1);
            OneDListModel.this._fireEvent(listDataEvent);
        }

        public void invalidateItems(OneDModelEvent oneDModelEvent) {
            ListDataEvent listDataEvent = new ListDataEvent(this, 0, oneDModelEvent.getStartIndex(), oneDModelEvent.getStartIndex() + oneDModelEvent.getItemCount() - 1);
            OneDListModel.this._fireEvent(listDataEvent);
        }
    }
}

