/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.help;

import java.awt.Component;
import javax.swing.JComponent;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;

public class HelpUtils {
    private static final String _PROPERTY_PROVIDER = "JEWT.HelpProvider";
    private static final String _PROPERTY_HELPSET = "HelpSet";
    private static final String _PROPERTY_ID = "HelpID";
    private static HelpProvider _sDefaultProvider;
    private static Object _sDefaultHelpSet;
    private static String _sDefaultHelpID;

    private HelpUtils() {
    }

    public static void showHelp(Component component) throws HelpUnavailableException {
        HelpProvider helpProvider = HelpUtils.getHelpProvider(component);
        if (helpProvider == null) {
            throw new HelpUnavailableException(null, "No help provider");
        }
        helpProvider.showHelp(component);
    }

    public static void setDefaultHelpProvider(HelpProvider helpProvider) {
        _sDefaultProvider = helpProvider;
    }

    public static HelpProvider getDefaultHelpProvider() {
        return _sDefaultProvider;
    }

    public static void setDefaultHelpSet(Object object) {
        _sDefaultHelpSet = object;
    }

    public static Object getDefaultHelpSet() {
        return _sDefaultHelpSet;
    }

    public static void setDefaultHelpID(String string) {
        _sDefaultHelpID = string;
    }

    public static String getDefaultHelpID() {
        return _sDefaultHelpID;
    }

    public static void setHelpProvider(JComponent jComponent, HelpProvider helpProvider) {
        jComponent.putClientProperty(_PROPERTY_PROVIDER, helpProvider);
    }

    public static void setHelpSet(JComponent jComponent, Object object) {
        jComponent.putClientProperty(_PROPERTY_HELPSET, object);
    }

    public static void setHelpID(JComponent jComponent, String string) {
        jComponent.putClientProperty(_PROPERTY_ID, string);
    }

    public static HelpProvider getHelpProvider(Component component) {
        while (component != null) {
            Object object;
            if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty(_PROPERTY_PROVIDER)) instanceof HelpProvider) {
                return (HelpProvider)object;
            }
            component = component.getParent();
        }
        return HelpUtils.getDefaultHelpProvider();
    }

    public static Object getHelpSet(Component component) {
        while (component != null) {
            Object object;
            if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty(_PROPERTY_HELPSET)) != null) {
                return object;
            }
            component = component.getParent();
        }
        return HelpUtils.getDefaultHelpSet();
    }

    public static String getHelpID(Component component) {
        while (component != null) {
            JComponent jComponent;
            Object object;
            if (component instanceof JComponent && (object = (jComponent = (JComponent)component).getClientProperty(_PROPERTY_ID)) instanceof String) {
                return (String)object;
            }
            component = component.getParent();
        }
        return HelpUtils.getDefaultHelpID();
    }
}

