/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.header;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import oracle.bali.ewt.header.Header;

class AutoScroller
implements ActionListener {
    private static final int _INITIAL_SCROLLING_DELAY = 200;
    private static final int _REPEAT_SCROLLING_DELAY = 100;
    private static AutoScroller _sAutoScroller;
    private Timer _timer = new Timer(200, this);
    private Header _scrollee;
    private boolean _decrease;
    private boolean _cancel;
    private int _newIndex;

    public static AutoScroller getAutoScroller() {
        if (_sAutoScroller == null) {
            _sAutoScroller = new AutoScroller();
        }
        return _sAutoScroller;
    }

    public void schedule(Header header, boolean bl) {
        this._scrollee = header;
        this._decrease = bl;
        this._cancel = false;
        this._timer.setDelay(200);
        this._timer.start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this._cancel || this._scrollee == null) {
            return;
        }
        Point point = this._scrollee.getCanvasOrigin();
        if (this._decrease) {
            int n = this._scrollee._isHorizontal() ? -point.x : -point.y;
            this._newIndex = this._scrollee.getGeometryManager().getItemAt(n);
            if (this._newIndex != -1) {
                this._newIndex = this._scrollee.getPreviousVisibleItem(this._newIndex);
            }
        } else {
            Dimension dimension = this._scrollee.getInnerSize();
            int n = this._scrollee._isHorizontal() ? -point.x + dimension.width : -point.y + dimension.height;
            this._newIndex = this._scrollee.getGeometryManager().getItemAt(n);
            if (this._newIndex != -1) {
                this._scrollee.scrollItemIntoView(this._newIndex);
                this._scrollee.growItemSelection(this._newIndex);
                this._newIndex = this._scrollee.getNextVisibleItem(this._newIndex);
            }
        }
        if (this._newIndex == -1) {
            return;
        }
        this._scrollee.scrollItemIntoView(this._newIndex);
        this._timer.setDelay(100);
        this._timer.restart();
    }

    public void cancel() {
        this._cancel = true;
        this._scrollee = null;
        this._timer.stop();
    }

    public void cancel(Header header) {
        if (this._scrollee == header) {
            this.cancel();
        }
    }

    public Header getScrollee() {
        return this._scrollee;
    }

    protected AutoScroller() {
    }

    protected int getNewIndex() {
        return this._newIndex;
    }

    protected boolean isCancelled() {
        return this._cancel;
    }
}

