/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.model.TwoDModelListener;

public class RowGroupingAppearance
implements AppearanceManager {
    private BackGroundChangeListener _backgroundChangeListener = new BackGroundChangeListener();
    private Grid _grid;
    private int _rows;
    private Color _color;
    private Appearance _a1;
    private Appearance _a2;

    public RowGroupingAppearance() {
        this(new Color(255, 255, 200), 1);
    }

    public RowGroupingAppearance(Color color, int n) {
        this.setColor(color);
        this.setRows(n);
    }

    public void setColor(Color color) {
        if (this.getColor() != color) {
            this._color = color;
            if (this._a1 != null) {
                this._a1.setBackground(color);
            }
            if (this._grid != null) {
                this._grid.repaint();
            }
        }
    }

    public Color getColor() {
        return this._color;
    }

    public void setRows(int n) {
        if (this.getRows() != n) {
            this._rows = n;
            if (this._grid != null) {
                this._grid.repaint();
            }
        }
    }

    public int getRows() {
        return this._rows;
    }

    public void setGrid(Grid grid) {
        if (this._grid != grid) {
            if (this._grid != null) {
                this._grid.removePropertyChangeListener(this._backgroundChangeListener);
            }
            this._grid = grid;
            if (this._grid != null) {
                this._grid.addPropertyChangeListener(this._backgroundChangeListener);
            }
        }
    }

    public Appearance getCellPaintingAppearance(int n, int n2) {
        int n3 = this._grid.getRowVisibleIndex(n2);
        return this._getAppearance(n3);
    }

    public TwoDModelListener getTwoDModelListener() {
        return null;
    }

    public void updateUI() {
        if (this._a1 instanceof UIResource) {
            this._a1 = null;
        }
        if (this._a2 instanceof UIResource) {
            this._a2 = null;
        }
    }

    private Appearance _getAppearance(int n) {
        Appearance appearance;
        int n2 = this.getRows();
        int n3 = n % (n2 * 2);
        if (n3 < n2) {
            if (this._a1 == null) {
                this._a1 = ((Appearance)UIManager.get("Grid.DefaultAppearance")).copy();
                this._a1.setBackground(this.getColor());
            }
            appearance = this._a1;
        } else {
            if (this._a2 == null) {
                this._a2 = ((Appearance)UIManager.get("Grid.DefaultAppearance")).copy();
                this._a2.setBackground(this._grid.getBackground());
            }
            appearance = this._a2;
        }
        return appearance;
    }

    private class BackGroundChangeListener
    implements PropertyChangeListener {
        private BackGroundChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("background".equals(propertyChangeEvent.getPropertyName()) && RowGroupingAppearance.this._a2 != null) {
                RowGroupingAppearance.this._a2.setBackground(RowGroupingAppearance.this._grid.getBackground());
            }
        }
    }
}

