/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import javax.swing.JTextField;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.TextFieldInputHandler;
import oracle.bali.ewt.text.NumberTextField;

public class NumberInputHandler
extends TextFieldInputHandler {
    public NumberInputHandler() {
    }

    public NumberInputHandler(NumberTextField numberTextField) {
        super(numberTextField);
    }

    public final NumberTextField getNumberTextField() {
        return (NumberTextField)this.getEditControl(null, -1, -1);
    }

    public void startEdit(Grid grid, int n, int n2, Object object) {
        if (object != null && !(object instanceof Number)) {
            throw new IllegalArgumentException("data " + object + " must be a number");
        }
        NumberTextField numberTextField = this.getNumberTextField();
        if (object != null) {
            numberTextField.setDataType(object.getClass());
            numberTextField.setNumber((Number)object);
        }
        super.startEdit(grid, n, n2, object == null ? null : this.getNumberTextField().getText());
    }

    public Object commitEdit(Grid grid, int n, int n2) {
        NumberTextField numberTextField = this.getNumberTextField();
        return numberTextField.getNumber();
    }

    public static CellInputHandler getCellInputHandler() {
        return new NumberInputHandler();
    }

    protected NumberTextField createNumberTextField() {
        return new NumberTextField();
    }

    protected final JTextField createTextField() {
        return this.createNumberTextField();
    }
}

