/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import oracle.bali.ewt.grid.Grid;

class GridAutoScroller
implements ActionListener {
    private static final int _INITIAL_SCROLLING_DELAY = 200;
    private static final int _REPEAT_SCROLLING_DELAY = 100;
    private static GridAutoScroller _sAutoScroller;
    private Timer _timer = new Timer(200, this);
    private Grid _scrollee;
    private boolean _hDecrease;
    private boolean _vDecrease;
    private boolean _horizontal;
    private boolean _vertical;
    private boolean _cancel;
    private boolean _scheduled;

    public static GridAutoScroller getAutoScroller() {
        if (_sAutoScroller == null) {
            _sAutoScroller = new GridAutoScroller();
        }
        return _sAutoScroller;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.run();
    }

    public void schedule(Grid grid, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this._scrollee = grid;
        this._horizontal = bl;
        this._vertical = bl3;
        this._hDecrease = bl2;
        this._vDecrease = bl4;
        this._cancel = false;
        if (this._scheduled) {
            return;
        }
        this._scheduled = true;
        this._timer.setDelay(200);
        this._timer.start();
    }

    public void cancel() {
        this._timer.stop();
        this._scheduled = false;
        this._cancel = true;
        this._scrollee = null;
    }

    public void cancel(Grid grid) {
        if (this._scrollee == grid) {
            this.cancel();
        }
    }

    public void run() {
        if (this._cancel || this._scrollee == null) {
            return;
        }
        Point point = this._scrollee.getCanvasOrigin();
        boolean bl = false;
        boolean bl2 = false;
        this._scrollee.freezeRepaints();
        try {
            int n;
            int n2;
            if (this._horizontal) {
                n2 = -1;
                if (this._hDecrease) {
                    n2 = this._scrollee.getColumnAt(-point.x);
                    if (n2 != -1) {
                        n2 = this._scrollee.getPreviousVisibleColumn(n2);
                    }
                } else {
                    n = -point.x + this._scrollee.getInnerSize().width;
                    n2 = this._scrollee.getColumnAt(n);
                    if (n2 != -1) {
                        this._scrollee.scrollColumnIntoView(n2);
                        this._scrollee.growSelection(true, n2);
                        n2 = this._scrollee.getNextVisibleColumn(n2);
                    }
                }
                if (n2 != -1) {
                    this._scrollee.scrollColumnIntoView(n2);
                    this._scrollee.growSelection(true, n2);
                    bl = true;
                }
            }
            if (this._vertical) {
                n2 = -1;
                if (this._vDecrease) {
                    n2 = this._scrollee.getRowAt(-point.y);
                    if (n2 != -1) {
                        n2 = this._scrollee.getPreviousVisibleRow(n2);
                    }
                } else {
                    n = -point.y + this._scrollee.getInnerSize().height;
                    n2 = this._scrollee.getRowAt(n);
                    if (n2 != -1) {
                        this._scrollee.scrollRowIntoView(n2);
                        this._scrollee.growSelection(false, n2);
                        n2 = this._scrollee.getNextVisibleRow(n2);
                    }
                }
                if (n2 != -1) {
                    this._scrollee.scrollRowIntoView(n2);
                    this._scrollee.growSelection(false, n2);
                    bl2 = true;
                }
            }
            Object var7_6 = null;
            this._scrollee.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this._scrollee.unfreezeRepaints();
            throw throwable;
        }
        if (bl || bl2) {
            this._timer.setDelay(100);
            this._timer.restart();
        } else {
            this._scheduled = false;
        }
    }

    private GridAutoScroller() {
    }
}

