/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterGraphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.elaf.EWTGridUI;
import oracle.bali.ewt.geometry.GeneralGeometryManager;
import oracle.bali.ewt.geometry.GeometryEvent;
import oracle.bali.ewt.geometry.GeometryListener;
import oracle.bali.ewt.geometry.GeometryManager;
import oracle.bali.ewt.geometry.ReversedGeometryManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.graphics.GraphicsProxy;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.GridAutoScroller;
import oracle.bali.ewt.grid.GridEditListener;
import oracle.bali.ewt.grid.GridEvent;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.GridToolTipManager;
import oracle.bali.ewt.grid.GridValidateEvent;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.grid.SingleAppearanceManager;
import oracle.bali.ewt.grid.StandardGridKeyHandler;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.grid.hGrid.HDataObject;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FormatPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.print.PrintGraphicsProxy;
import oracle.bali.ewt.print.PrinterGraphicsProxy;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.ewt.scrolling.ScrollableComponent;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.MultiLineToolTip;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.InputEventUtils;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.share.collection.Range;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.util.IntegerUtils;

public class Grid
extends ScrollableComponent
implements Accessible {
    public static final int ANCHOR_NONE = -1;
    public static final String CELL_KEY = "Cell";
    public static final String APPEARANCE_KEY = "Appearance";
    public static final String MODEL_KEY = "Model";
    public static final String GRID_KEY = "Grid";
    public static final String CLIP_RECT_KEY = "grid.clipRect";
    public static final String HORIZONTAL_SEPARATOR_COLOR_KEY = "horizontalSeparatorColor";
    public static final String VERTICAL_SEPARATOR_COLOR_KEY = "verticalSeparatorColor";
    public static final String PROPERTY_FOCUSCELL = "focusCell";
    public static final String PROPERTY_SELECTION = "selection";
    public static final String PROPERTY_SELECTION_MANAGER = "gridSelectionManager";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_COLUMN_GEOMETRY_MANAGER = "columnGeometryManager";
    public static final String PROPERTY_ROW_GEOMETRY_MANAGER = "rowGeometryManager";
    public static final Object DISPLAY_HORIZONTAL_SEPARATOR = "grid.dispHSep";
    public static final Object DISPLAY_VERTICAL_SEPARATOR = "grid.dispVSep";
    public static final Object DISPLAY_FOCUS_CELL = "grid.dispFocus";
    public static final Object DISPLAY_SELECTION_BORDER = "grid.dispSelBorder";
    private int _firstColumn = -1;
    private int _firstRow = -1;
    private transient Component _editControl;
    Cell _focusCell;
    static final String _PAGE_UP = "_PAGE_UP";
    static final String _PAGE_DOWN = "_PAGE_DOWN";
    private static final String _IMAGE = "GRID_IMAGE";
    private static final String _UNKNOWN = "UNKNOWN";
    private static final String _RESOURCE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private static final String _SPANMM = "BIGCELL.SPAN_MULTIPLE_COLUMN_MULTIPLE_ROW";
    private static final String _SPANSM = "BIGCELL.SPAN_SINGLE_COLUMN_MULTIPLE_ROW";
    private static final String _SPANMS = "BIGCELL.SPAN_MULTIPLE_COLUMN_SINGLE_ROW";
    private static final String _SPANSS = "BIGCELL.SPAN_SINGLE_COLUMN_SINGLE_ROW";
    private static final String _FULL_CELL_NAME = "SPREADTABLE.FULL_CELL_NAME";
    private static final String _COLUMNONLY_CELL_NAME = "SPREADTABLE.COLUMNONLY_CELL_NAME";
    private static final String _ROWONLY_CELL_NAME = "SPREADTABLE.ROWONLY_CELL_NAME";
    private static final String _NULL_CELL_BOTH = "SPREADTABLE.NULL_CELL_BOTH";
    private static final String _NULL_CELL_COLUMN = "SPREADTABLE.NULL_CELL_COLUMN";
    private static final String _NULL_CELL_ROW = "SPREADTABLE.NULL_CELL_ROW";
    private ListenerManager _editListeners;
    private GridKeyHandler _keyHandler;
    private AppearanceManager _appearanceManager;
    private GridSelectionManager _gridSelectionManager;
    private GeometryManager _columnGM;
    private GeometryManager _rowGM;
    private TwoDModel _model;
    private DSListen _dsListener;
    private RowGeometryChangeListener _rowGeometryChangeListener;
    private ColumnGeometryChangeListener _columnGeometryChangeListener;
    private Painter _defaultPainter;
    private CellInputHandler _defaultInputHandler;
    private boolean _horizontalSeparatorsVisible;
    private boolean _verticalSeparatorsVisible;
    private Painter _horizontalPainter;
    private Painter _verticalPainter;
    private int _vpWidth;
    private boolean _drawFocusCellHighlite;
    private boolean _alwaysDrawFocusCellHighlite;
    private boolean _overlayVisible;
    private int _preferredRows;
    private int _preferredColumns;
    private ArrayOneDModel _painters;
    private ArrayOneDModel _cellInputHandlers;
    private GridKeyListener _keyListener;
    private FocusAdapter _focusListener;
    private ChangeListener _changeListener;
    private SelectionListener _selectionListener;
    private transient Cell _mouseGrabCell;
    private boolean _mouseGrabCellArmed;
    private Cell _moveCell;
    private Cell _anchorCell;
    private boolean _scrollByColumn;
    private boolean _scrollByRow;
    private transient boolean _removing;
    private transient boolean _handlingMousePressed;
    private boolean _isUpperLeft;
    private boolean _isUpperRight;
    private boolean _isLowerLeft;
    private boolean _isLowerRight;
    private boolean _defaultRowHeightSet;
    private boolean _defaultColumnWidthSet;
    private transient int _lastColumn;
    private transient int _lastRow;
    private transient Object _scrollLock = new Object();
    private boolean _ignoreSelectionRepaints = false;
    private boolean _cancelEdit = false;
    private GridToolTipManager _toolTipManager = null;
    private transient Object _paintLock = new Object();
    private boolean _drawSelectionBorder;
    private boolean _selectionTransparent;
    private static final int _ALPHA = 60;
    private boolean _borderVisible = true;
    private Color _horizontalSeparatorColor;
    private Color _verticalSeparatorColor;
    private boolean _canRequestFocus = true;
    private Component[] _editControlChildren;
    private Color _extraBackground;

    public Grid() {
        this(null);
    }

    public Grid(TwoDModel twoDModel) {
        this(twoDModel, null, NullInputHandler.getCellInputHandler());
    }

    public Grid(TwoDModel twoDModel, Painter painter, CellInputHandler cellInputHandler) {
        if (twoDModel == null) {
            twoDModel = NullTwoDModel.getTwoDModel();
        }
        super.setLayout(null);
        this._model = twoDModel;
        this._defaultPainter = painter;
        this._defaultInputHandler = cellInputHandler;
        this._dsListener = new DSListen();
        this._model.addModelListener(this._dsListener);
        this._scrollByColumn = true;
        this._scrollByRow = true;
        this._drawFocusCellHighlite = true;
        this.setHorizontalSeparatorsVisible(true);
        this.setVerticalSeparatorsVisible(true);
        this._changeListener = new Change();
        long l = 62L;
        this.enableEvents(l);
        this._registerKeyboardActions();
        this.updateUI();
    }

    public void dispose() {
        this.cancelCellEdit();
        this.setToolTipManager(null);
        this._unregisterKeyboardActions();
        this._focusCell = null;
        this._mouseGrabCell = null;
        this._moveCell = null;
        this._anchorCell = null;
        this._editListeners = null;
        this._keyHandler = null;
        if (this._appearanceManager != null) {
            this._appearanceManager.setGrid(null);
        }
        this._appearanceManager = null;
        if (this._gridSelectionManager != null) {
            this._gridSelectionManager.removeVetoableChangeListener(this._selectionListener);
            this._gridSelectionManager.removePropertyChangeListener(this._selectionListener);
        }
        this._selectionListener = null;
        this._gridSelectionManager = null;
        if (this._columnGM != null) {
            this._columnGM.removeGeometryListener(this._columnGeometryChangeListener);
        }
        this._columnGM = null;
        this._columnGeometryChangeListener = null;
        if (this._rowGM != null) {
            this._rowGM.removeGeometryListener(this._rowGeometryChangeListener);
        }
        this._rowGM = null;
        this._rowGeometryChangeListener = null;
        this._model.removeModelListener(this._dsListener);
        this._model = null;
        this._dsListener = null;
        this._defaultPainter = null;
        this._defaultInputHandler = null;
        this._horizontalPainter = null;
        this._verticalPainter = null;
        this._editControl = null;
        this._keyListener = null;
        this._focusListener = null;
        if (this._painters != null && this._painters.getItemCount() != 0) {
            this._painters.removeItems(0, this._painters.getItemCount());
        }
        this._painters = null;
        if (this._cellInputHandlers != null && this._cellInputHandlers.getItemCount() != 0) {
            this._cellInputHandlers.removeItems(0, this._cellInputHandlers.getItemCount());
        }
        this._cellInputHandlers = null;
        Container container = this.getParent();
        if (container instanceof JViewport) {
            ((JViewport)container).removeChangeListener(this._changeListener);
        }
        this._changeListener = null;
        this.setUI(null);
    }

    public String getUIClassID() {
        return "EWTGridUI";
    }

    public EWTGridUI getEWTGridUI() {
        return (EWTGridUI)this.ui;
    }

    public void setColumnGeometryManager(GeometryManager geometryManager) {
        if (geometryManager == null) {
            throw new NullPointerException();
        }
        GeometryListener geometryListener = this._getColumnGeometryChangeListener();
        if (this._columnGM != null) {
            this._columnGM.removeGeometryListener(geometryListener);
        }
        if (this.getActualReadingDirection() == 2) {
            geometryManager = new ReversedGeometryManager(geometryManager);
        }
        GeometryManager geometryManager2 = this._columnGM;
        this._columnGM = geometryManager;
        this._columnGM.addGeometryListener(geometryListener);
        this._columnGM.resetAll(this.getColumnCount());
        this.firePropertyChange(PROPERTY_COLUMN_GEOMETRY_MANAGER, geometryManager2, this._columnGM);
    }

    public GeometryManager getColumnGeometryManager() {
        GeometryManager geometryManager = this._getColumnGeometryManager();
        if (geometryManager instanceof ReversedGeometryManager) {
            return ((ReversedGeometryManager)geometryManager).getWrappedGeometryManager();
        }
        return geometryManager;
    }

    public void setRowGeometryManager(GeometryManager geometryManager) {
        if (geometryManager == null) {
            throw new NullPointerException();
        }
        GeometryListener geometryListener = this._getRowGeometryChangeListener();
        if (this._rowGM != null) {
            this._rowGM.removeGeometryListener(geometryListener);
        }
        GeometryManager geometryManager2 = this._rowGM;
        this._rowGM = geometryManager;
        this._rowGM.addGeometryListener(geometryListener);
        this._rowGM.resetAll(this.getRowCount());
        this.firePropertyChange(PROPERTY_ROW_GEOMETRY_MANAGER, geometryManager2, this._rowGM);
    }

    public GeometryManager getRowGeometryManager() {
        if (this._rowGM == null) {
            int n = this.getEWTGridUI().getDefaultRowHeight(this);
            GeneralGeometryManager generalGeometryManager = new GeneralGeometryManager();
            generalGeometryManager.setDefaultItemSize(n);
            this.setRowGeometryManager(generalGeometryManager);
        }
        return this._rowGM;
    }

    public void setToolTipManager(GridToolTipManager gridToolTipManager) {
        GridToolTipManager gridToolTipManager2 = this._toolTipManager;
        this._toolTipManager = gridToolTipManager;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (this._toolTipManager == null) {
            if (gridToolTipManager2 != null) {
                toolTipManager.unregisterComponent(this);
            }
        } else if (gridToolTipManager2 == null) {
            toolTipManager.registerComponent(this);
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        }
    }

    public GridToolTipManager getToolTipManager() {
        return this._toolTipManager;
    }

    public JToolTip createToolTip() {
        return new MultiLineToolTip();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this._toolTipManager == null) {
            return super.getToolTipText(mouseEvent);
        }
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n = this.getColumnAt(point.x);
        int n2 = this.getRowAt(point.y);
        if (n < 0 || n2 < 0) {
            return null;
        }
        return this._toolTipManager.getCellToolTipValue(this, n, n2);
    }

    public int getColumnCount() {
        return this._model.getColumnCount();
    }

    public final int getVisibleColumnCount() {
        return this._getColumnGeometryManager().getVisibleItemCount();
    }

    public int getRowCount() {
        return this._model.getRowCount();
    }

    public final int getVisibleRowCount() {
        return this.getRowGeometryManager().getVisibleItemCount();
    }

    public void setSelection(TwoDSelection twoDSelection) throws PropertyVetoException {
        this.getGridSelectionManager().setSelection(twoDSelection, null);
    }

    public TwoDSelection getSelection() {
        return this.getGridSelectionManager().getSelection();
    }

    public void selectAll() throws PropertyVetoException {
        int n = this.getNextVisibleColumn(-1);
        int n2 = this.getPreviousVisibleColumn(this.getColumnCount());
        int n3 = this.getNextVisibleRow(-1);
        int n4 = this.getPreviousVisibleRow(this.getRowCount());
        TwoDSelection twoDSelection = this.getModelRangeSelection(n, n3, n2, n4);
        this.setSelection(twoDSelection);
    }

    public void deselectAll() throws PropertyVetoException {
        this.setSelection(TwoDSelection.getEmptySelection());
    }

    public TwoDModel getModel() {
        return this._model;
    }

    public void setModel(TwoDModel twoDModel) {
        TwoDModel twoDModel2 = this.getModel();
        if (twoDModel == null) {
            twoDModel = NullTwoDModel.getTwoDModel();
        }
        if (twoDModel != twoDModel2) {
            this.freezeRepaints();
            try {
                twoDModel2.removeModelListener(this._dsListener);
                twoDModel.addModelListener(this._dsListener);
                this._model = twoDModel;
                this._cellInputHandlers = null;
                this._painters = null;
                if (this._appearanceManager != null) {
                    this._appearanceManager.setGrid(null);
                    this._appearanceManager.setGrid(this);
                }
                try {
                    this.deselectAll();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.getColumnGeometryManager().resetAll(this.getColumnCount());
                this.getRowGeometryManager().resetAll(this.getRowCount());
                this._mouseGrabCell = null;
                this._moveCell = null;
                this.setAnchorCell(null);
                this._focusCell = null;
                this._firstColumn = Math.min(this._firstColumn, this.getColumnCount() - 1);
                this._firstRow = Math.min(this._firstRow, this.getRowCount() - 1);
                Object var6_4 = null;
                this.unfreezeRepaints();
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                this.unfreezeRepaints();
                throw throwable;
            }
            this.invalidateCanvas();
            this.firePropertyChange(PROPERTY_MODEL, twoDModel2, twoDModel);
        }
    }

    public void setDefaultPainter(Painter painter) {
        this._defaultPainter = painter;
    }

    public Painter getDefaultPainter() {
        if (this._defaultPainter == null) {
            this._defaultPainter = (Painter)UIManager.get("Grid.DefaultCellPainter");
        }
        return this._defaultPainter;
    }

    public CellInputHandler getDefaultInputHandler() {
        return this._defaultInputHandler;
    }

    public void setDefaultInputHandler(CellInputHandler cellInputHandler) {
        this._defaultInputHandler = cellInputHandler == null ? NullInputHandler.getCellInputHandler() : cellInputHandler;
    }

    public void setAppearanceManager(AppearanceManager appearanceManager) {
        if (this._appearanceManager != null) {
            this._appearanceManager.setGrid(null);
        }
        this._appearanceManager = appearanceManager;
        if (this._appearanceManager != null) {
            this._appearanceManager.setGrid(this);
            this._appearanceManager.updateUI();
        }
        this.repaintInterior();
    }

    public AppearanceManager getAppearanceManager() {
        if (this._appearanceManager == null) {
            this._appearanceManager = new SingleAppearanceManager();
            this._appearanceManager.setGrid(this);
        }
        return this._appearanceManager;
    }

    public synchronized void addEditListener(GridEditListener gridEditListener) {
        if (this._editListeners == null) {
            this._editListeners = new ListenerManager();
        }
        this._editListeners.addListener((EventListener)gridEditListener);
    }

    public synchronized void removeEditListener(GridEditListener gridEditListener) {
        if (this._editListeners != null) {
            this._editListeners.removeListener((EventListener)gridEditListener);
        }
    }

    public boolean isEditing() {
        return this._editControl != null;
    }

    public void cancelCellEdit() {
        this._doneEditing(false);
    }

    public void commitCellEdit() {
        this._doneEditing(true);
    }

    public void setGridSelectionManager(GridSelectionManager gridSelectionManager) {
        SelectionListener selectionListener = this._getSelectionListener();
        if (gridSelectionManager == null) {
            gridSelectionManager = GeneralGridSelectionManager.getNullGridSelectionManager();
        }
        if (gridSelectionManager != this._gridSelectionManager) {
            if (this._gridSelectionManager != null) {
                this._gridSelectionManager.removeVetoableChangeListener(selectionListener);
                this._gridSelectionManager.removePropertyChangeListener(selectionListener);
            }
            GridSelectionManager gridSelectionManager2 = this._gridSelectionManager;
            this._gridSelectionManager = gridSelectionManager;
            this._gridSelectionManager.addVetoableChangeListener(selectionListener);
            this._gridSelectionManager.addPropertyChangeListener(selectionListener);
            this.repaintInterior();
            this.firePropertyChange(PROPERTY_SELECTION_MANAGER, gridSelectionManager2, this._gridSelectionManager);
        }
    }

    public GridSelectionManager getGridSelectionManager() {
        if (this._gridSelectionManager == null) {
            this.setGridSelectionManager(new GeneralGridSelectionManager());
        }
        return this._gridSelectionManager;
    }

    /*
     * Unable to fully structure code
     */
    public int getPreviousVisibleColumn(int var1_1) {
        var2_2 = this._getColumnGeometryManager();
        var3_3 = var1_1 < this.getColumnCount() ? var2_2.getItemVisibleIndex(var1_1) : var1_1;
        var4_4 = var3_3 - 1;
        if (var4_4 >= 0) ** GOTO lbl10
        return -1;
lbl-1000:
        // 1 sources

        {
            var5_5 = var2_2.visibleIndexToIndex(var4_4);
            if (var2_2.isItemVisible(var5_5)) {
                return var5_5;
            }
            --var4_4;
lbl10:
            // 2 sources

            ** while (var4_4 >= 0)
        }
lbl11:
        // 1 sources

        return -1;
    }

    public int getPreviousVisibleRow(int n) {
        GeometryManager geometryManager = this.getRowGeometryManager();
        int n2 = n < this.getRowCount() ? geometryManager.getItemVisibleIndex(n) : n;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            int n4 = geometryManager.visibleIndexToIndex(n3);
            if (geometryManager.isItemVisible(n4)) {
                return n4;
            }
            --n3;
        }
        return -1;
    }

    public int getNextVisibleColumn(int n) {
        GeometryManager geometryManager = this._getColumnGeometryManager();
        int n2 = n >= 0 ? geometryManager.getItemVisibleIndex(n) : n;
        int n3 = n2 + 1;
        int n4 = this.getColumnCount();
        while (n3 < n4) {
            int n5 = geometryManager.visibleIndexToIndex(n3);
            if (geometryManager.isItemVisible(n5)) {
                return n5;
            }
            ++n3;
        }
        return -1;
    }

    public int getNextVisibleRow(int n) {
        GeometryManager geometryManager = this.getRowGeometryManager();
        int n2 = n >= 0 ? geometryManager.getItemVisibleIndex(n) : n;
        int n3 = n2 + 1;
        int n4 = this.getRowCount();
        while (n3 < n4) {
            int n5 = geometryManager.visibleIndexToIndex(n3);
            if (geometryManager.isItemVisible(n5)) {
                return n5;
            }
            ++n3;
        }
        return -1;
    }

    public void setHorizontalSeparatorsVisible(boolean bl) {
        if (this._horizontalSeparatorsVisible != bl) {
            this._horizontalSeparatorsVisible = bl;
            this.invalidateCanvas();
        }
    }

    public boolean getHorizontalSeparatorsVisible() {
        return this._horizontalSeparatorsVisible;
    }

    public void setHorizontalSeparatorPainter(Painter painter) {
        if (this._horizontalPainter != painter) {
            this._horizontalPainter = painter;
            this.invalidateCanvas();
        }
    }

    public Painter getHorizontalSeparatorPainter() {
        if (this._horizontalPainter == null) {
            return NullPainter.getPainter();
        }
        return this._horizontalPainter;
    }

    public void setVerticalSeparatorsVisible(boolean bl) {
        if (this._verticalSeparatorsVisible != bl) {
            this._verticalSeparatorsVisible = bl;
            this.invalidateCanvas();
        }
    }

    public boolean getVerticalSeparatorsVisible() {
        return this._verticalSeparatorsVisible;
    }

    public void setVerticalSeparatorPainter(Painter painter) {
        if (this._verticalPainter != painter) {
            this._verticalPainter = painter;
            int n = this._vpWidth;
            this._vpWidth = painter == null ? 0 : painter.getPreferredSize((PaintContext)this.getPaintContext()).width;
            if (this.getVerticalSeparatorsVisible()) {
                this.invalidateCanvas();
            }
        }
    }

    public Painter getVerticalSeparatorPainter() {
        if (this._verticalPainter == null) {
            return NullPainter.getPainter();
        }
        return this._verticalPainter;
    }

    public void setHorizontalSeparatorColor(Color color) {
        if (color != this._horizontalSeparatorColor) {
            this._horizontalSeparatorColor = color;
            this.repaintInterior();
        }
    }

    public Color getHorizontalSeparatorColor() {
        return this._horizontalSeparatorColor;
    }

    public void setVerticalSeparatorColor(Color color) {
        if (color != this._verticalSeparatorColor) {
            this._verticalSeparatorColor = color;
            this.repaintInterior();
        }
    }

    public Color getVerticalSeparatorColor() {
        return this._verticalSeparatorColor;
    }

    public void setExtraCanvasBackground(Color color) {
        Color color2 = this.getExtraCanvasBackground();
        this._extraBackground = color;
        boolean bl = color2 != null ? !color2.equals(color) : color != null;
        if (bl) {
            this.repaint();
        }
    }

    public Color getExtraCanvasBackground() {
        return this._extraBackground;
    }

    public Cell getFocusCell() {
        if (this._focusCell == null) {
            return null;
        }
        return new Cell(this._focusCell.column, this._focusCell.row);
    }

    public void setFocusCell(Cell cell) {
        this.requestFocus(cell.column, cell.row, null);
    }

    public boolean requestFocus(int n, int n2, AWTEvent aWTEvent) {
        if (this._focusCell != null && this._focusCell.column == n && this._focusCell.row == n2) {
            return true;
        }
        Cell cell = this._focusCell == null ? null : new Cell(this._focusCell.column, this._focusCell.row);
        Cell cell2 = new Cell(n, n2);
        try {
            this.fireVetoableChange(PROPERTY_FOCUSCELL, cell, cell2);
        }
        catch (PropertyVetoException propertyVetoException) {
            return false;
        }
        this.freezeRepaints();
        try {
            Grid grid = this;
            synchronized (grid) {
                CellInputHandler cellInputHandler;
                TwoDSelection twoDSelection = this.getSelection();
                boolean bl = false;
                if (this._focusCell != null) {
                    int n3 = this._focusCell.column;
                    int n4 = this._focusCell.row;
                    cellInputHandler = this.getColumnCellInputHandler(n3);
                    if (!cellInputHandler.validateFocus(this, n3, n4)) {
                        // empty if block
                    }
                    this.commitCellEdit();
                    cellInputHandler.focusLost(aWTEvent, this, n3, n4);
                    this._focusCell = null;
                    if (this.getDrawFocusCellHighlite()) {
                        this.paintCell(n3, n4);
                    }
                    if (this.getDrawSelectionBorder() && twoDSelection.containsCell(n3, n4)) {
                        bl = true;
                    }
                }
                this._focusCell = new Cell(n, n2);
                if (this.isCellEnabled(n, n2)) {
                    cellInputHandler = this.getColumnCellInputHandler(this._focusCell.column);
                    cellInputHandler.focusGained(aWTEvent, this, n, n2);
                }
                this.firePropertyChange(PROPERTY_FOCUSCELL, cell, cell2);
                if (this.getDrawFocusCellHighlite()) {
                    this.paintCell(n, n2);
                }
                if (this.getDrawSelectionBorder() && twoDSelection.containsCell(this._focusCell)) {
                    bl = true;
                }
                if (bl) {
                    this._paintSelections(twoDSelection);
                }
            }
            Object var14_14 = null;
            this.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
        return true;
    }

    public void setDrawFocusCellHighlite(boolean bl) {
        if (this.getDrawFocusCellHighlite() != bl) {
            this._drawFocusCellHighlite = bl;
            if (this._focusCell != null) {
                this.paintCell(this._focusCell.column, this._focusCell.row);
            }
        }
    }

    public boolean getDrawFocusCellHighlite() {
        return this._drawFocusCellHighlite;
    }

    public void setAlwaysDrawFocusCellHighlite(boolean bl) {
        if (this.isAlwaysDrawFocusCellHighlite() != bl) {
            this._alwaysDrawFocusCellHighlite = bl;
            if (this._focusCell != null) {
                this.paintCell(this._focusCell.column, this._focusCell.row);
            }
        }
    }

    public boolean isAlwaysDrawFocusCellHighlite() {
        return this._alwaysDrawFocusCellHighlite;
    }

    public void setDrawSelectionBorder(boolean bl) {
        this._setDrawSelectionBorder(bl, true);
    }

    public boolean getDrawSelectionBorder() {
        return this._drawSelectionBorder;
    }

    public void setSelectionTransparent(boolean bl) {
        if (bl != this._selectionTransparent) {
            this._selectionTransparent = bl;
            this._paintSelections(this.getSelection());
        }
    }

    public boolean isSelectionTransparent() {
        return this._selectionTransparent;
    }

    public final void setDefaultColumnWidth(int n) {
        this._defaultColumnWidthSet = true;
        if (n == 0) {
            n = this.getEWTGridUI().getDefaultColumnWidth(this);
            this._defaultColumnWidthSet = false;
        }
        this._getColumnGeometryManager().setDefaultItemSize(n);
        this.invalidateCanvas();
    }

    public final int getDefaultColumnWidth() {
        GeometryManager geometryManager = this._getColumnGeometryManager();
        int n = geometryManager.getDefaultItemSize();
        if (n == 0) {
            n = this.getEWTGridUI().getDefaultColumnWidth(this);
            geometryManager.setDefaultItemSize(n);
            this.invalidateCanvas();
        }
        return n;
    }

    public final void setDefaultRowHeight(int n) {
        this._defaultRowHeightSet = true;
        if (n == 0) {
            n = this.getEWTGridUI().getDefaultRowHeight(this);
            this._defaultRowHeightSet = false;
        }
        this.getRowGeometryManager().setDefaultItemSize(n);
        this.invalidateCanvas();
    }

    public final int getDefaultRowHeight() {
        GeometryManager geometryManager = this.getRowGeometryManager();
        int n = geometryManager.getDefaultItemSize();
        if (n == 0) {
            n = this.getEWTGridUI().getDefaultRowHeight(this);
            geometryManager.setDefaultItemSize(n);
            this.invalidateCanvas();
        }
        return n;
    }

    public int getOnScreenRowCount() {
        GeometryManager geometryManager = this.getRowGeometryManager();
        int n = this.getFirstRowOnScreen();
        int n2 = this.getRowCount();
        if (n2 == 0 || n == -1) {
            return 0;
        }
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getCanvasSize();
        Dimension dimension2 = this.getInnerSize();
        int n3 = 0;
        int n4 = -point.y + dimension2.height;
        if (n4 > dimension.height) {
            n4 = dimension.height;
        }
        int n5 = geometryManager.getItemVisibleIndex(n);
        while (n5 < n2) {
            int n6 = geometryManager.visibleIndexToIndex(n5);
            ++n5;
            if (!geometryManager.isItemVisible(n6)) continue;
            int n7 = geometryManager.getItemPosition(n6);
            if (n7 > n4) break;
            ++n3;
        }
        return n3;
    }

    public int getOnScreenColumnCount() {
        GeometryManager geometryManager = this._getColumnGeometryManager();
        int n = this.getFirstColumnOnScreen();
        int n2 = this.getColumnCount();
        if (n2 == 0 || n == -1) {
            return 0;
        }
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getCanvasSize();
        Dimension dimension2 = this.getInnerSize();
        int n3 = 0;
        int n4 = -point.x + dimension2.width;
        if (n4 > dimension.width) {
            n4 = dimension.width;
        }
        int n5 = geometryManager.getItemVisibleIndex(n);
        while (n5 < n2) {
            int n6 = geometryManager.visibleIndexToIndex(n5);
            ++n5;
            if (!geometryManager.isItemVisible(n6)) continue;
            int n7 = geometryManager.getItemPosition(n6);
            if (n7 > n4) break;
            ++n3;
        }
        return n3;
    }

    public int getFirstRowOnScreen() {
        if (this._firstRow != -1) {
            return this._firstRow;
        }
        Point point = this.getCanvasOrigin();
        return this.getRowGeometryManager().getItemAt(-point.y);
    }

    public void setFirstRowOnScreen(int n) {
        GeometryManager geometryManager = this.getRowGeometryManager();
        if (n < 0 || n >= this.getRowCount() || !geometryManager.isItemVisible(n)) {
            throw new IllegalArgumentException("Illegal row " + n);
        }
        if (this.getCanvasHeight() == 0) {
            this._firstRow = n;
        } else {
            int n2;
            this._firstRow = -1;
            int n3 = geometryManager.getItemPosition(n);
            int n4 = geometryManager.getTotalSize();
            if (n4 - n3 < (n2 = this.getInnerSize().height)) {
                n3 = n4 - n2;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            n3 = -n3;
            if (this.getCanvasOriginY() != n3) {
                this.commitCellEdit();
                this.setCanvasOrigin(this.getCanvasOriginX(), n3);
            }
        }
    }

    public int getFirstColumnOnScreen() {
        if (this._firstColumn != -1) {
            return this._firstColumn;
        }
        Point point = this.getCanvasOrigin();
        return this._getColumnGeometryManager().getItemAt(-point.x);
    }

    public void setFirstColumnOnScreen(int n) {
        GeometryManager geometryManager = this._getColumnGeometryManager();
        if (n < 0 || n >= this.getColumnCount() || !geometryManager.isItemVisible(n)) {
            throw new IllegalArgumentException();
        }
        if (this.getCanvasWidth() == 0) {
            this._firstColumn = n;
        } else {
            int n2;
            this._firstColumn = -1;
            int n3 = geometryManager.getItemPosition(n);
            int n4 = geometryManager.getTotalSize();
            if (n4 - n3 < (n2 = this.getInnerSize().width)) {
                n3 = n4 - n2;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            n3 = -n3;
            if (this.getCanvasOriginX() != n3) {
                this.commitCellEdit();
                this.setCanvasOrigin(n3, this.getCanvasOriginY());
            }
        }
    }

    public void setPreferredRowsOnScreen(int n) {
        this._preferredRows = n;
    }

    public int getPreferredRowsOnScreen() {
        return this._preferredRows;
    }

    public void setPreferredColumnsOnScreen(int n) {
        this._preferredColumns = n;
    }

    public int getPreferredColumnsOnScreen() {
        return this._preferredColumns;
    }

    public final void setAnchorCell(Cell cell) {
        if (cell == null) {
            this.setAnchorCell(-1, -1);
        } else {
            this.setAnchorCell(cell.column, cell.row);
        }
    }

    public void setAnchorCell(int n, int n2) {
        this._anchorCell = n == -1 || n2 == -1 ? null : new Cell(n, n2);
    }

    public Cell getAnchorCell() {
        return this._anchorCell;
    }

    public void setGridKeyHandler(GridKeyHandler gridKeyHandler) {
        this._keyHandler = gridKeyHandler;
    }

    public GridKeyHandler getGridKeyHandler() {
        if (this._keyHandler == null) {
            this._keyHandler = StandardGridKeyHandler.getGridKeyHandler();
        }
        return this._keyHandler;
    }

    public boolean isHScrollable() {
        return true;
    }

    public boolean isVScrollable() {
        return true;
    }

    public void setScrollByColumn(boolean bl) {
        if (bl != this.getScrollByColumn()) {
            this._scrollByColumn = bl;
            Dimension dimension = this.getCanvasSize();
            this.setCanvasSize(dimension.width, dimension.height);
            this.revalidate();
        }
    }

    public boolean getScrollByColumn() {
        return this._scrollByColumn;
    }

    public void setScrollByRow(boolean bl) {
        if (bl != this.getScrollByRow()) {
            this._scrollByRow = bl;
            Dimension dimension = this.getCanvasSize();
            this.setCanvasSize(dimension.width, dimension.height);
            this.revalidate();
        }
    }

    public boolean getScrollByRow() {
        return this._scrollByRow;
    }

    public void setLayout(LayoutManager layoutManager) {
        super.setLayout(null);
    }

    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            this.commitCellEdit();
        }
    }

    public final synchronized void setColumnVisibleIndex(int n, int n2) {
        GeometryManager geometryManager = this._getColumnGeometryManager();
        if (this.getColumnVisibleIndex(n) != n2) {
            int n3 = geometryManager.getItemPosition(n);
            boolean bl = this.isColumnOnScreen(n);
            geometryManager.setItemVisibleIndex(n, n2);
            Dimension dimension = this.layoutCanvas();
            this.setCanvasSize(dimension.width, dimension.height);
            boolean bl2 = this.isColumnOnScreen(n);
            if (bl2 || bl) {
                if (!bl2 || !bl) {
                    this.repaintInterior();
                } else {
                    dimension = this.getInnerSize();
                    int n4 = geometryManager.getItemPosition(n);
                    if (n3 < n4) {
                        n4 = n3;
                    }
                    Point point = this.getCanvasOrigin();
                    this.repaintCanvas(n4 - 1, -point.y, dimension.width, dimension.height);
                }
            }
        }
    }

    public final int getColumnVisibleIndex(int n) {
        return this._getColumnGeometryManager().getItemVisibleIndex(n);
    }

    public final synchronized void setRowVisibleIndex(int n, int n2) {
        GeometryManager geometryManager = this.getRowGeometryManager();
        if (this.getRowVisibleIndex(n) != n2) {
            int n3 = geometryManager.getItemPosition(n);
            boolean bl = this.isRowOnScreen(n);
            geometryManager.setItemVisibleIndex(n, n2);
            Dimension dimension = this.layoutCanvas();
            this.setCanvasSize(dimension.width, dimension.height);
            boolean bl2 = this.isRowOnScreen(n);
            if (bl2 || bl) {
                if (!bl2 || !bl) {
                    this.repaintInterior();
                } else {
                    dimension = this.getInnerSize();
                    int n4 = geometryManager.getItemPosition(n);
                    if (n3 < n4) {
                        n4 = n3;
                    }
                    Point point = this.getCanvasOrigin();
                    this.repaintCanvas(-point.x, n4 - 1, dimension.width, dimension.height);
                }
            }
        }
    }

    public final int getRowVisibleIndex(int n) {
        return this.getRowGeometryManager().getItemVisibleIndex(n);
    }

    public final void setColumnVisible(int n, boolean bl) {
        this._getColumnGeometryManager().setItemVisible(n, bl);
    }

    public final boolean isColumnVisible(int n) {
        return this._getColumnGeometryManager().isItemVisible(n);
    }

    public final void setRowVisible(int n, boolean bl) {
        this.getRowGeometryManager().setItemVisible(n, bl);
    }

    public final boolean isRowVisible(int n) {
        return this.getRowGeometryManager().isItemVisible(n);
    }

    public final void setColumnWidth(int n, int n2) {
        if (this.getColumnWidth(n) != n2) {
            int n3;
            GeometryManager geometryManager = this._getColumnGeometryManager();
            geometryManager.setItemSize(n, n2);
            Dimension dimension = this.layoutCanvas();
            this.setCanvasSize(dimension.width, dimension.height);
            if (this.isColumnOnScreen(n)) {
                dimension = this.getInnerSize();
                Point point = this.getCanvasOrigin();
                int n4 = geometryManager.getItemPosition(n);
                if (n4 < -point.x) {
                    n4 = -point.x;
                }
                this.repaintCanvas(n4, -point.y, dimension.width, dimension.height);
            }
            int n5 = n3 = this._focusCell == null ? -1 : this._focusCell.column;
            if (this.isEditing() && (this.getActualReadingDirection() == 2 || geometryManager.getItemVisibleIndex(n) <= geometryManager.getItemVisibleIndex(n3))) {
                this._moveEditControl();
            }
            this.revalidate();
        }
    }

    public final int getColumnWidth(int n) {
        return this._getColumnGeometryManager().getItemSize(n);
    }

    public final void setRowHeight(int n, int n2) {
        if (this.getRowHeight(n) != n2) {
            int n3;
            GeometryManager geometryManager = this.getRowGeometryManager();
            geometryManager.setItemSize(n, n2);
            Dimension dimension = this.layoutCanvas();
            this.setCanvasSize(dimension.width, dimension.height);
            if (this.isRowOnScreen(n)) {
                dimension = this.getInnerSize();
                Point point = this.getCanvasOrigin();
                int n4 = geometryManager.getItemPosition(n);
                if (n4 < -point.y) {
                    n4 = -point.y;
                }
                this.repaintCanvas(-point.x, n4, dimension.width, dimension.height);
            }
            int n5 = n3 = this._focusCell == null ? -1 : this._focusCell.row;
            if (this.isEditing() && geometryManager.getItemVisibleIndex(n) <= geometryManager.getItemVisibleIndex(n3)) {
                this._moveEditControl();
            }
            this.revalidate();
        }
    }

    public final int getRowHeight(int n) {
        return this.getRowGeometryManager().getItemSize(n);
    }

    public void setColumnPainter(int n, Painter painter) {
        if (this._painters == null) {
            this._painters = new ArrayOneDModel(this.getColumnCount());
        }
        this._painters.setData(n, painter);
        this.paintColumn(n);
    }

    public Painter getColumnPainter(int n) {
        Object object;
        if (this._painters != null && (object = this._painters.getData(n)) != null) {
            return (Painter)object;
        }
        return this.getDefaultPainter();
    }

    public void setColumnCellInputHandler(int n, CellInputHandler cellInputHandler) {
        cellInputHandler.updateUI();
        if (this._cellInputHandlers == null) {
            this._cellInputHandlers = new ArrayOneDModel(this.getColumnCount());
        }
        this._cellInputHandlers.setData(n, cellInputHandler);
    }

    public CellInputHandler getColumnCellInputHandler(int n) {
        Object object;
        if (this._cellInputHandlers != null && (object = this._cellInputHandlers.getData(n)) != null) {
            return (CellInputHandler)object;
        }
        return this.getDefaultInputHandler();
    }

    public void addNotify() {
        GeometryManager geometryManager;
        int n;
        Object object;
        super.addNotify();
        Container container = this.getParent();
        if (container instanceof JViewport) {
            this.setBorder(null);
            ((JViewport)container).addChangeListener(this._changeListener);
            object = container.getParent();
            if (object instanceof JScrollPane) {
                JScrollPane jScrollPane = (JScrollPane)object;
                LookAndFeel.installBorder(jScrollPane, "EWTGrid.scrollPaneBorder");
            }
        }
        if ((n = (object = this.getRowGeometryManager()).getDefaultItemSize()) == 0) {
            n = this.getEWTGridUI().getDefaultRowHeight(this);
            object.setDefaultItemSize(n);
            this.invalidateCanvas();
        }
        if ((n = (geometryManager = this.getColumnGeometryManager()).getDefaultItemSize()) == 0) {
            n = this.getEWTGridUI().getDefaultColumnWidth(this);
            geometryManager.setDefaultItemSize(n);
            this.invalidateCanvas();
        }
    }

    public void startCellEdit(final int n, final int n2) {
        Grid grid = this;
        synchronized (grid) {
            if (this.isEditing() && this._focusCell != null && this._focusCell.column == n && this._focusCell.row == n2) {
                return;
            }
        }
        this.commitCellEdit();
        this.freezeRepaints();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Grid.this._startCellEdit(n, n2);
                    Object var2_1 = null;
                    Grid.this.unfreezeRepaints();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    Grid.this.unfreezeRepaints();
                    throw throwable;
                }
            }
        });
    }

    public boolean isRowOnScreen(int n) {
        if (!this.isRowVisible(n)) {
            return false;
        }
        GeometryManager geometryManager = this.getRowGeometryManager();
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        int n2 = geometryManager.getItemPosition(n);
        int n3 = geometryManager.getItemSize(n);
        point.y = -point.y;
        return n2 + n3 >= point.y && n2 <= point.y + dimension.height;
    }

    public boolean isColumnOnScreen(int n) {
        GeometryManager geometryManager = this._getColumnGeometryManager();
        if (!this.isColumnVisible(n)) {
            return false;
        }
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        int n2 = geometryManager.getItemPosition(n);
        int n3 = geometryManager.getItemSize(n);
        point.x = -point.x;
        return n2 + n3 >= point.x && n2 <= point.x + dimension.width;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isManagingFocus() {
        return !FocusUtils.areNewFocusAPIsAvailable();
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this._calculateCanvasSize();
        int n = this.getPreferredColumnsOnScreen();
        int n2 = this.getPreferredRowsOnScreen();
        int n3 = this.getVisibleRowCount();
        int n4 = this.getVisibleColumnCount();
        int n5 = this._getColumnGeometryManager().getTotalSize();
        int n6 = this.getRowGeometryManager().getTotalSize();
        int n7 = n5 == 0 ? n * this.getDefaultColumnWidth() : (n != 0 && n4 != 0 ? n * n5 / n4 : n5);
        int n8 = n6 == 0 ? n2 * this.getDefaultRowHeight() : (n2 != 0 && n3 != 0 ? n2 * n6 / n3 : n6);
        return this.convertInnerToOuterSize(n7, n8);
    }

    public Dimension getMinimumSize() {
        int n = this.getDefaultColumnWidth();
        int n2 = this.getDefaultRowHeight();
        return this.convertInnerToOuterSize(n, n2);
    }

    public final int getColumnPosition(int n) {
        return this._getColumnGeometryManager().getItemPosition(n);
    }

    public final int getRowPosition(int n) {
        return this.getRowGeometryManager().getItemPosition(n);
    }

    public final int getColumnAt(int n) {
        return this._getColumnGeometryManager().getItemAt(n);
    }

    public final int getRowAt(int n) {
        return this.getRowGeometryManager().getItemAt(n);
    }

    public void setUpperLeft(boolean bl) {
        if (this._isUpperLeft != bl) {
            this._isUpperLeft = bl;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isUpperLeft() {
        return this._isUpperLeft;
    }

    public void setUpperRight(boolean bl) {
        if (this._isUpperRight != bl) {
            this._isUpperRight = bl;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isUpperRight() {
        return this._isUpperRight;
    }

    public void setLowerLeft(boolean bl) {
        if (this._isLowerLeft != bl) {
            this._isLowerLeft = bl;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isLowerLeft() {
        return this._isLowerLeft;
    }

    public void setLowerRight(boolean bl) {
        if (this._isLowerRight != bl) {
            this._isLowerRight = bl;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isLowerRight() {
        return this._isLowerRight;
    }

    public boolean isOverlayBorderVisible() {
        return this._overlayVisible;
    }

    public void setOverlayBorderVisible(boolean bl) {
        if (this._overlayVisible != bl) {
            this._overlayVisible = bl;
            this.repaint();
        }
    }

    public PaintContext getCellPaintContext(int n, int n2) {
        return new CellPaintContext(this.getPaintContext(), n, n2);
    }

    public PaintContext getCellPrintPaintContext(Graphics graphics, int n, int n2) {
        return new CellPrintPaintContext(this.getPrintPaintContext(graphics), n, n2);
    }

    public final void fireCellEvent(int n, int n2, int n3) {
        GridEvent gridEvent = new GridEvent(this, n3, n, n2);
        this.processEvent(gridEvent);
    }

    public final boolean fireCancelableCellEvent(int n, int n2, int n3) {
        if (n3 == 2001 && this._cancelEdit) {
            return true;
        }
        GridValidateEvent gridValidateEvent = new GridValidateEvent(this, n3, n, n2);
        this.processEvent(gridValidateEvent);
        return gridValidateEvent.isCancelled();
    }

    public void repaintColumn(int n) {
        this._paintColumn(n, false);
    }

    public void paintColumn(int n) {
        this._paintColumn(n, true);
    }

    public void repaintRow(int n) {
        this._paintRow(n, false);
    }

    public void paintRow(int n) {
        this._paintRow(n, true);
    }

    public void paintVisibleCellRange(CellRange cellRange) {
        GeometryManager geometryManager = this._getColumnGeometryManager();
        GeometryManager geometryManager2 = this.getRowGeometryManager();
        Cell cell = cellRange.getLowerLimit();
        Cell cell2 = cellRange.getUpperLimit();
        this.validate();
        int n = geometryManager.visibleIndexToIndex(cell.column);
        int n2 = geometryManager.visibleIndexToIndex(cell2.column);
        int n3 = geometryManager2.visibleIndexToIndex(cell.row);
        int n4 = geometryManager2.visibleIndexToIndex(cell2.row);
        int n5 = this._getColumnX(n) - 1;
        int n6 = geometryManager2.getItemPosition(n3) - 1;
        int n7 = this._getColumnX(n2) - 1;
        int n8 = geometryManager2.getItemPosition(n4) - 1;
        int n9 = n7 - n5 + geometryManager.getItemSize(n2) + 2;
        int n10 = n8 - n6 + geometryManager2.getItemSize(n4) + 2;
        this.paintImmediateInterior(n5, n6, n9, n10);
    }

    public void repaintCell(int n, int n2) {
        this._paintCell(n, n2, false);
    }

    public void paintCell(int n, int n2) {
        this._paintCell(n, n2, true);
    }

    public void setCanvasSize(int n, int n2) {
        int n3;
        int n4 = this.getCanvasSize().width;
        super.setCanvasSize(n, n2);
        if (this.getActualReadingDirection() == 2 && (n3 = this.getInnerSize().width) != 0) {
            int n5;
            int n6 = this.getCanvasSize().width;
            Point point = this.getCanvasOrigin();
            if (n4 <= 0) {
                n5 = n3 - n6;
            } else {
                n5 = point.x + n4 - n6;
                if (n5 > 0) {
                    if (n6 > n3) {
                        n5 = 0;
                    } else if (n5 + n6 > n3) {
                        n5 = n3 - n6;
                    }
                }
            }
            this.setCanvasOrigin(n5, point.y);
        }
    }

    public void setCanvasOrigin(int n, int n2) {
        int n3;
        int n4;
        if (this.getActualReadingDirection() == 2 && n + (n4 = this.getCanvasSize().width) < (n3 = this.getInnerSize().width)) {
            n = n3 - n4;
        }
        super.setCanvasOrigin(n, n2);
    }

    public void removeNotify() {
        GridAutoScroller.getAutoScroller().cancel(this);
        Container container = this.getParent();
        if (container instanceof JViewport) {
            ((JViewport)container).removeChangeListener(this._changeListener);
            Container container2 = container.getParent();
            if (container2 instanceof JScrollPane) {
                JScrollPane jScrollPane = (JScrollPane)container2;
                LookAndFeel.uninstallBorder(jScrollPane);
            }
        }
        super.removeNotify();
    }

    public void updateUI() {
        this.setUI((EWTGridUI)UIManager.getUI(this));
        this.updateGeometry(false);
        this._updateCellInputHandlerUI();
        if (this._appearanceManager != null) {
            this._appearanceManager.updateUI();
        }
    }

    public void updateGeometry(boolean bl) {
        if (bl) {
            this.setUI((EWTGridUI)UIManager.getUI(this));
        }
        if (!this._defaultRowHeightSet || this.getRowGeometryManager().getDefaultItemSize() == 0) {
            this.setDefaultRowHeight(0);
        }
        if (!this._defaultColumnWidthSet || this.getColumnGeometryManager().getDefaultItemSize() == 0) {
            this.setDefaultColumnWidth(0);
        }
    }

    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        int n;
        int n2;
        int n3;
        Painter painter;
        GraphicsProxy graphicsProxy = graphics instanceof PrintGraphics ? new PrintGraphicsProxy(graphics, (PrintGraphics)((Object)graphics)) : (graphics instanceof PrinterGraphics ? new PrinterGraphicsProxy(graphics, (PrinterGraphics)((Object)graphics)) : new GraphicsProxy(graphics));
        Rectangle rectangle = graphics.getClipBounds();
        graphicsProxy.put(CLIP_RECT_KEY, rectangle);
        if (paintContext == null) {
            paintContext = this.getPrintPaintContext(graphics);
        }
        boolean bl = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_FOCUS_CELL, true);
        boolean bl2 = this.getDrawSelectionBorder();
        this._setDrawSelectionBorder(PrinterUtils.getPrinterProperty(dictionary, DISPLAY_SELECTION_BORDER, false), false);
        this._paintGrid(paintContext, graphicsProxy, bl);
        this._setDrawSelectionBorder(bl2, false);
        boolean bl3 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_HORIZONTAL_SEPARATOR, true);
        boolean bl4 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_VERTICAL_SEPARATOR, true);
        SeparatorContext separatorContext = null;
        if (bl3 || bl4) {
            separatorContext = new SeparatorContext(paintContext);
        }
        if (bl3 && (painter = this.getHorizontalSeparatorPainter()) != null) {
            n3 = rectangle.width;
            n2 = this.getColumnGeometryManager().getTotalSize();
            if (rectangle.x + n3 > n2) {
                n3 = n2 - rectangle.x;
            }
            n = painter.getPreferredSize((PaintContext)separatorContext).height;
            painter.paint(separatorContext, graphics, rectangle.x, rectangle.y, n3, n);
        }
        if (bl4 && (painter = this.getVerticalSeparatorPainter()) != null) {
            n3 = rectangle.height;
            n2 = this.getRowGeometryManager().getTotalSize();
            if (rectangle.y + n3 > n2) {
                n3 = n2 - rectangle.y;
            }
            n = painter.getPreferredSize((PaintContext)separatorContext).width;
            painter.paint(separatorContext, graphics, rectangle.x, rectangle.y, n, n3);
        }
    }

    public Dimension getDocumentSize(PaintContext paintContext, Dictionary dictionary) {
        GeometryManager geometryManager = this.getColumnGeometryManager();
        GeometryManager geometryManager2 = this.getRowGeometryManager();
        int n = geometryManager.getTotalSize();
        int n2 = geometryManager2.getTotalSize();
        return new Dimension(n, n2);
    }

    public Rectangle getPageBounds(PaintContext paintContext, Dictionary dictionary, int n, int n2, int n3, int n4) {
        GeometryManager geometryManager = this.getColumnGeometryManager();
        GeometryManager geometryManager2 = this.getRowGeometryManager();
        int n5 = n + n3;
        int n6 = n2 + n4;
        int n7 = geometryManager.getItemAt(n);
        int n8 = geometryManager2.getItemAt(n2);
        int n9 = geometryManager.getItemAt(n5);
        int n10 = geometryManager2.getItemAt(n6);
        int n11 = 0;
        int n12 = 0;
        if (n9 != -1 && n7 != n9) {
            n3 = geometryManager.getItemPosition(n9) - n;
            n11 = geometryManager.getSeparatorSize();
        }
        if (n10 != -1 && n8 != n10) {
            n4 = geometryManager2.getItemPosition(n10) - n2;
            n12 = geometryManager2.getSeparatorSize();
        }
        Rectangle rectangle = new Rectangle(n3, n4, n3, n4);
        return rectangle;
    }

    public Cell getCellAt(int n, int n2) {
        int n3 = this._getColumnGeometryManager().getItemAt(n);
        int n4 = this.getRowGeometryManager().getItemAt(n2);
        if (n3 < 0 || n4 < 0) {
            return null;
        }
        return new Cell(n3, n4);
    }

    public Rectangle getCellBounds(int n, int n2, int n3, int n4) {
        EWTGridUI eWTGridUI;
        BorderPainter borderPainter;
        int n5;
        int n6 = n;
        int n7 = n2;
        GeometryManager geometryManager = this._getColumnGeometryManager();
        GeometryManager geometryManager2 = this.getRowGeometryManager();
        int n8 = this._getColumnX(n);
        int n9 = geometryManager2.getItemPosition(n2);
        int n10 = this._getColumnX(n3);
        int n11 = geometryManager2.getItemPosition(n4);
        if (n8 > n10) {
            n6 = n3;
            n5 = n10;
            n10 = n8;
            n8 = n5;
        }
        if (n9 > n11) {
            n7 = n4;
            n5 = n11;
            n11 = n9;
            n9 = n5;
        }
        n5 = n10 - n8 + geometryManager.getItemSize(n3);
        int n12 = n11 - n9 + geometryManager2.getItemSize(n4);
        ImmInsets immInsets = null;
        if (this.isOverlayBorderVisible() && (borderPainter = (eWTGridUI = this.getEWTGridUI()).getOverlayBorderPainter(this)) != null) {
            immInsets = borderPainter.getInsets(this.getPaintContext());
        }
        if (immInsets == null) {
            immInsets = ImmInsets.getEmptyInsets();
        }
        int n13 = this.getFirstColumnOnScreen();
        int n14 = this.getFirstRowOnScreen();
        if (n6 == n13) {
            n8 += immInsets.left;
            n5 -= immInsets.left;
        }
        if (n7 == n14) {
            n9 += immInsets.top;
            n12 -= immInsets.top;
        }
        return new Rectangle(n8, n9, n5, n12);
    }

    protected Component getScrollParent() {
        Container container = this.getParent();
        if (container instanceof SpreadTable) {
            return container;
        }
        return this;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        int n5 = this.getInnerSize().width;
        super.reshape(n, n2, n3, n4);
        Dimension dimension = this.getCanvasSize();
        this._checkForFirstColumnRow(dimension);
        if (this.getActualReadingDirection() == 2) {
            int n6 = dimension.width;
            int n7 = this.getInnerSize().width;
            if (n5 <= 0) {
                this.setCanvasOrigin(n7 - n6, this.getCanvasOrigin().y);
            } else if (n5 != n7) {
                this.commitCellEdit();
                Point point = this.getCanvasOrigin();
                int n8 = point.x + n7 - n5;
                if (n8 > 0) {
                    if (n6 > n7) {
                        n8 = 0;
                    } else if (n8 + n6 > n7) {
                        n8 = n7 - n6;
                    }
                }
                this.setCanvasOrigin(n8, point.y);
            }
        }
        Dimension dimension2 = this.getInnerSize();
        this._getColumnGeometryManager().setTotalSize(dimension2.width);
        this.getRowGeometryManager().setTotalSize(dimension2.height);
    }

    public void setCellBorderVisible(boolean bl) {
        if (this.isCellBorderVisible() != bl) {
            this._borderVisible = bl;
            this.repaint();
        }
    }

    public boolean isCellBorderVisible() {
        return this._borderVisible;
    }

    protected void processContainerEvent(ContainerEvent containerEvent) {
        super.processContainerEvent(containerEvent);
        if (containerEvent.getID() == 301 && containerEvent.getChild() == this._editControl && !this._removing) {
            this.commitCellEdit();
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof GridEvent) {
            switch (aWTEvent.getID()) {
                case 2001: 
                case 2002: {
                    this.processEditEvent((GridEvent)aWTEvent);
                }
            }
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processEditEvent(GridEvent gridEvent) {
        if (this._editListeners == null) {
            return;
        }
        Enumeration enumeration = this._editListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (gridEvent.getID()) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((GridEditListener)enumeration.nextElement()).cellEditing(gridEvent);
                }
                break;
            }
            case 2002: {
                while (enumeration.hasMoreElements()) {
                    ((GridEditListener)enumeration.nextElement()).cellEdited(gridEvent);
                }
                break;
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            if (mouseEvent.isConsumed() && mouseEvent.getID() == 502) {
                GridAutoScroller.getAutoScroller().cancel(this);
                this._cancelEdit = false;
            }
            return;
        }
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        Cell cell = this.getCellAt(point.x, point.y);
        CellInputHandler cellInputHandler = null;
        if (cell != null) {
            cellInputHandler = this.getColumnCellInputHandler(cell.column);
        }
        switch (mouseEvent.getID()) {
            case 500: {
                this._handleMouseClicked(mouseEvent, cell, cellInputHandler);
                break;
            }
            case 504: {
                this._handleMouseEntered(mouseEvent, cell, cellInputHandler);
                break;
            }
            case 505: {
                this._handleMouseExited(mouseEvent, cell, cellInputHandler);
                break;
            }
            case 501: {
                this._handleMousePressed(mouseEvent, cell, cellInputHandler);
                break;
            }
            case 502: {
                this._handleMouseReleased(mouseEvent, cell, cellInputHandler);
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        Cell cell = this.getCellAt(point.x, point.y);
        CellInputHandler cellInputHandler = null;
        if (cell != null) {
            cellInputHandler = this.getColumnCellInputHandler(cell.column);
        }
        switch (mouseEvent.getID()) {
            case 503: {
                this._handleMouseMoved(mouseEvent, cell, cellInputHandler);
                break;
            }
            case 506: {
                this._handleMouseDragged(mouseEvent, cell, cellInputHandler);
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004) {
            if (this._focusCell != null) {
                this._fireActiveEvent(null, this._focusCell);
            } else {
                Cell cell;
                int n = this.getNextVisibleColumn(-1);
                int n2 = this.getNextVisibleRow(-1);
                TwoDSelection twoDSelection = this.getSelection();
                if (twoDSelection.isEmpty() && !this._handlingMousePressed && n != -1 && n2 != -1) {
                    try {
                        this.setSelection(new TwoDSelection(n, n2));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                if (!twoDSelection.isEmpty() && (cell = twoDSelection.getSingleCell()) != null) {
                    n2 = cell.row;
                    n = cell.column;
                }
                if (n != -1 && n2 != -1) {
                    this.requestFocus(n, n2, null);
                }
            }
        }
        this.repaintInterior();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isMetaDown() || keyEvent.getID() != 401 || keyEvent.getKeyCode() != 9)) {
            FocusManager focusManager = FocusManager.getCurrentManager();
            if (keyEvent.isShiftDown()) {
                focusManager.focusPreviousComponent(this);
            } else {
                focusManager.focusNextComponent(this);
            }
            keyEvent.consume();
        }
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
        super.processComponentKeyEvent(keyEvent);
        if (keyEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        if (this._editControl != null) {
            this._editControl.requestFocus();
            return;
        }
        int n = keyEvent.getID();
        if (n == 401) {
            this._handleKeyPressed(keyEvent);
        } else if (n == 400) {
            this._handleKeyTyped(keyEvent);
        } else if (n == 402) {
            this._handleKeyReleased(keyEvent);
        }
    }

    public int getHMaximum() {
        if (!this.getScrollByColumn()) {
            return super.getHMaximum();
        }
        return this.getVisibleColumnCount();
    }

    public int getHValueOfOffset(int n) {
        if (!this.getScrollByColumn()) {
            return super.getHValueOfOffset(n);
        }
        GeometryManager geometryManager = this._getColumnGeometryManager();
        int n2 = geometryManager.getItemAt(-n);
        int n3 = geometryManager.getItemVisibleIndex(n2);
        if (n2 >= 0 && geometryManager.getItemPosition(n2) < -n) {
            ++n3;
        }
        return n3;
    }

    public int getHOffsetOfValue(int n) {
        GeometryManager geometryManager = this._getColumnGeometryManager();
        if (!this.getScrollByColumn()) {
            return super.getHOffsetOfValue(n);
        }
        if (n >= this.getHMaximum()) {
            n = this.getHMaximum() - 1;
        }
        int n2 = this._convertVisibleColumnIndexToColumnIndex(n);
        n2 = geometryManager.visibleIndexToIndex(n2);
        int n3 = geometryManager.getItemPosition(n2);
        int n4 = this.getCanvasSize().width;
        int n5 = this.getInnerSize().width;
        int n6 = 0;
        if (n4 > n5 && n4 != 0 && n5 != 0) {
            n6 = n5 - n4;
        }
        if (-n3 < n6) {
            n3 = -n6;
        }
        return -n3;
    }

    public int getVMaximum() {
        if (!this.getScrollByRow()) {
            return super.getVMaximum();
        }
        return this.getVisibleRowCount();
    }

    public int getVValueOfOffset(int n) {
        if (!this.getScrollByRow()) {
            return super.getVValueOfOffset(n);
        }
        GeometryManager geometryManager = this.getRowGeometryManager();
        int n2 = geometryManager.getItemAt(-n);
        return geometryManager.getItemVisibleIndex(n2);
    }

    public int getVOffsetOfValue(int n) {
        if (!this.getScrollByRow()) {
            return super.getVOffsetOfValue(n);
        }
        if (n >= this.getVMaximum()) {
            n = this.getVMaximum() - 1;
        }
        GeometryManager geometryManager = this.getRowGeometryManager();
        int n2 = this._convertVisibleRowIndexToRowIndex(n);
        n2 = geometryManager.visibleIndexToIndex(n2);
        int n3 = geometryManager.getItemPosition(n2);
        return -n3;
    }

    public Dimension layoutCanvas() {
        Dimension dimension = this._calculateCanvasSize();
        this._checkForFirstColumnRow(dimension);
        return dimension;
    }

    public void paintCanvasInterior(Graphics graphics) {
        this._paintGrid(this.getPaintContext(), graphics, true);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        super.fireVetoableChange(string, object, object2);
    }

    protected void paintFocusCell(Graphics graphics) {
        if (this._focusCell != null) {
            Rectangle rectangle = this._getCellRect(this._focusCell.column, this._focusCell.row);
            if (rectangle == null) {
                return;
            }
            this._paintBorderAroundCells(rectangle, graphics);
        }
    }

    protected boolean paintSelectionBorder(Graphics graphics) {
        Rectangle rectangle = this._getSelectionBounds();
        if (rectangle == null) {
            return false;
        }
        this._paintBorderAroundCells(rectangle, graphics);
        return true;
    }

    public void scrollCellIntoView(int n, int n2) {
        Rectangle rectangle = this._getCellRect(n, n2, false);
        this.scrollRectToVisible(rectangle);
    }

    public void scrollColumnIntoView(int n) {
        Rectangle rectangle = this._getColumnRect(n);
        this.scrollRectToVisible(rectangle);
    }

    public void scrollRowIntoView(int n) {
        Rectangle rectangle = this._getRowRect(n);
        this.scrollRectToVisible(rectangle);
    }

    protected int getCellPaintState(int n, int n2, int n3) {
        return n;
    }

    protected Object getPaintData(Object object) {
        Object object2 = null;
        if (MODEL_KEY.equals(object)) {
            object2 = this.getModel();
        } else if (GRID_KEY.equals(object)) {
            object2 = this;
        } else if (HORIZONTAL_SEPARATOR_COLOR_KEY.equals(object)) {
            object2 = this.getHorizontalSeparatorColor();
        } else if (VERTICAL_SEPARATOR_COLOR_KEY.equals(object)) {
            object2 = this.getVerticalSeparatorColor();
        }
        if (object2 == null) {
            object2 = super.getPaintData(object);
        }
        return object2;
    }

    protected final boolean isCellEnabled(int n, int n2) {
        PaintContext paintContext = this.getCellPaintContext(n, n2);
        return (paintContext.getPaintState() & 1) == 0;
    }

    protected TwoDSelection getModelRangeSelection(int n, int n2, int n3, int n4) {
        GeometryManager geometryManager = this._getColumnGeometryManager();
        GeometryManager geometryManager2 = this.getRowGeometryManager();
        int n5 = geometryManager.getItemVisibleIndex(n);
        int n6 = geometryManager.getItemVisibleIndex(n3);
        int n7 = geometryManager2.getItemVisibleIndex(n2);
        int n8 = geometryManager2.getItemVisibleIndex(n4);
        CellRange[] cellRangeArray = new CellRange[]{new CellRange(n5, n7, n6, n8)};
        CellRange[] cellRangeArray2 = this._modelCellRangesFromVisibleCellRanges(cellRangeArray);
        TwoDSelection twoDSelection = new TwoDSelection(null, null, cellRangeArray2);
        return twoDSelection;
    }

    void focusLost(FocusEvent focusEvent) {
        if (!this._removing) {
            Component component;
            if (this._editControlChildren != null && (component = FocusUtils.getOppositeComponent(focusEvent)) != null) {
                int n = this._editControlChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    if (component == this._editControlChildren[n2]) {
                        return;
                    }
                    ++n2;
                }
            }
            this._canRequestFocus = false;
            this.commitCellEdit();
        }
    }

    void internalRowsAdded(TwoDModelEvent twoDModelEvent) {
        int n = this.getFirstRowOnScreen();
        int n2 = twoDModelEvent.getRowStartIndex();
        int n3 = twoDModelEvent.getRowCount();
        this.freezeRepaints();
        try {
            Object object;
            Object object2;
            AppearanceManager appearanceManager = this.getAppearanceManager();
            if (appearanceManager != null && (object2 = appearanceManager.getTwoDModelListener()) != null) {
                object2.rowsAdded(twoDModelEvent);
            }
            if ((object2 = this.getGridSelectionManager()) != null && (object = object2.getTwoDModelListener()) != null) {
                this._ignoreSelectionRepaints = true;
                object.rowsAdded(twoDModelEvent);
                this._ignoreSelectionRepaints = false;
            }
            if (this._rowGM != null && (object = this._rowGM.getOneDModelListener()) != null) {
                object.itemsAdded(new OneDModelEvent(this, 2001, n2, n3));
            }
            this._focusCell = this._addRowsToCell(this._focusCell, n2, n3);
            this.setAnchorCell(this._addRowsToCell(this.getAnchorCell(), n2, n3));
            this._moveCell = this._addRowsToCell(this._moveCell, n2, n3);
            this._mouseGrabCell = this._addRowsToCell(this._mouseGrabCell, n2, n3);
            object = this.getCanvasSize();
            Point point = this.getCanvasOrigin();
            Dimension dimension = this.layoutCanvas();
            this.setCanvasSize(dimension.width, dimension.height);
            if (n2 <= n) {
                this.setFirstRowOnScreen(n + n3);
            }
            this.revalidate();
            Object var11_10 = null;
            this.unfreezeRepaints();
            int n4 = n2;
            if (n4 == this.getRowCount()) {
                --n4;
            }
            if (this.isRowOnScreen(n4)) {
                this.repaint();
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.unfreezeRepaints();
            int n5 = n2;
            if (n5 == this.getRowCount()) {
                --n5;
            }
            if (this.isRowOnScreen(n5)) {
                this.repaint();
            }
            throw throwable;
        }
    }

    void internalRowsRemoved(TwoDModelEvent twoDModelEvent) {
        int n = twoDModelEvent.getRowStartIndex();
        int n2 = twoDModelEvent.getRowCount();
        boolean bl = false;
        this.freezeRepaints();
        try {
            EventListener eventListener;
            Object object;
            int n3 = this.getFirstRowOnScreen();
            int n4 = n3 + this.getOnScreenRowCount();
            if (n >= n3 && n <= n4) {
                bl = true;
            } else if (n < n3 && n + n2 > n) {
                bl = true;
            }
            AppearanceManager appearanceManager = this.getAppearanceManager();
            if (appearanceManager != null && (object = appearanceManager.getTwoDModelListener()) != null) {
                object.rowsRemoved(twoDModelEvent);
            }
            if ((object = this.getGridSelectionManager()) != null && (eventListener = object.getTwoDModelListener()) != null) {
                this._ignoreSelectionRepaints = true;
                eventListener.rowsRemoved(twoDModelEvent);
                this._ignoreSelectionRepaints = false;
            }
            if (this._rowGM != null && (eventListener = this._rowGM.getOneDModelListener()) != null) {
                eventListener.itemsRemoved(new OneDModelEvent(this, 2002, n, n2));
            }
            if (this._focusCell != null && this._focusCell.row >= n && this._focusCell.row < n + n2 && this.isEditing()) {
                this.cancelCellEdit();
            }
            this._focusCell = this._removeRowsFromCell(this._focusCell, n, n2);
            this.setAnchorCell(this._removeRowsFromCell(this.getAnchorCell(), n, n2));
            this._moveCell = this._removeRowsFromCell(this._moveCell, n, n2);
            this._mouseGrabCell = this._removeRowsFromCell(this._mouseGrabCell, n, n2);
            if (this._focusCell == null) {
                int n5 = this.getNextVisibleColumn(-1);
                int n6 = this.getNextVisibleRow(-1);
                if (n5 != -1 && n6 != -1) {
                    this._focusCell = new Cell(n5, n6);
                }
            }
            Dimension dimension = this.getCanvasSize();
            Point point = this.getCanvasOrigin();
            Dimension dimension2 = this.layoutCanvas();
            this.setCanvasSize(dimension2.width, dimension2.height);
            if (n <= n3) {
                if (n + n2 - 1 < n3) {
                    this.setFirstRowOnScreen(n3 - n2);
                } else {
                    int n7 = this.getNextVisibleRow(-1);
                    int n8 = this.getNextVisibleRow(n7);
                    while (n8 < n && n8 != -1) {
                        n7 = n8;
                        n8 = this.getNextVisibleRow(n8);
                    }
                    if (n7 != -1) {
                        this.setFirstRowOnScreen(n7);
                    } else {
                        this.setCanvasOrigin(this.getCanvasOrigin().x, 0);
                    }
                }
            }
            this.revalidate();
            Object var15_17 = null;
            this.unfreezeRepaints();
            if (bl) {
                this.repaint();
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.unfreezeRepaints();
            if (bl) {
                this.repaint();
            }
            throw throwable;
        }
    }

    void internalInvalidateRows(TwoDModelEvent twoDModelEvent) {
        GeometryManager geometryManager = this.getRowGeometryManager();
        int n = twoDModelEvent.getRowStartIndex();
        int n2 = n + twoDModelEvent.getRowCount() - 1;
        int n3 = 0;
        int n4 = geometryManager.getItemPosition(n);
        int n5 = this._getColumnGeometryManager().getTotalSize();
        int n6 = geometryManager.getItemPosition(n2) + geometryManager.getItemSize(n2);
        this.repaintCanvas(n3, n4, n5, n6);
    }

    void internalColumnsAdded(TwoDModelEvent twoDModelEvent) {
        int n = this.getFirstColumnOnScreen();
        int n2 = twoDModelEvent.getColumnStartIndex();
        int n3 = twoDModelEvent.getColumnCount();
        this.freezeRepaints();
        try {
            boolean bl;
            Object object;
            Object object2;
            this._columnsAdded(n2, n3);
            AppearanceManager appearanceManager = this.getAppearanceManager();
            if (appearanceManager != null && (object2 = appearanceManager.getTwoDModelListener()) != null) {
                object2.columnsAdded(twoDModelEvent);
            }
            if ((object2 = this.getGridSelectionManager()) != null && (object = object2.getTwoDModelListener()) != null) {
                this._ignoreSelectionRepaints = true;
                object.columnsAdded(twoDModelEvent);
                this._ignoreSelectionRepaints = false;
            }
            if (this._columnGM != null && (object = this._columnGM.getOneDModelListener()) != null) {
                object.itemsAdded(new OneDModelEvent(this, 2001, n2, n3));
            }
            this._focusCell = this._addColumnsToCell(this._focusCell, n2, n3);
            this.setAnchorCell(this._addColumnsToCell(this.getAnchorCell(), n2, n3));
            this._moveCell = this._addColumnsToCell(this._moveCell, n2, n3);
            this._mouseGrabCell = this._addColumnsToCell(this._mouseGrabCell, n2, n3);
            object = this.getCanvasSize();
            Point point = this.getCanvasOrigin();
            Dimension dimension = this.layoutCanvas();
            this.setCanvasSize(dimension.width, dimension.height);
            if (n2 <= n) {
                this.setFirstColumnOnScreen(n + n3);
            }
            this.revalidate();
            Object var11_10 = null;
            this.unfreezeRepaints();
            int n4 = n2;
            if (n4 == this.getColumnCount()) {
                --n4;
            }
            if (bl = this.isColumnOnScreen(n4)) {
                this.repaint();
            }
        }
        catch (Throwable throwable) {
            boolean bl;
            Object var11_11 = null;
            this.unfreezeRepaints();
            int n5 = n2;
            if (n5 == this.getColumnCount()) {
                --n5;
            }
            if (bl = this.isColumnOnScreen(n5)) {
                this.repaint();
            }
            throw throwable;
        }
    }

    void internalColumnsRemoved(TwoDModelEvent twoDModelEvent) {
        int n = twoDModelEvent.getColumnStartIndex();
        int n2 = twoDModelEvent.getColumnCount();
        boolean bl = false;
        this.freezeRepaints();
        try {
            EventListener eventListener;
            Object object;
            int n3 = this.getFirstColumnOnScreen();
            int n4 = n3 + this.getOnScreenColumnCount();
            if (n >= n3 && n <= n4) {
                bl = true;
            } else if (n < n3 && n + n2 > n) {
                bl = true;
            }
            AppearanceManager appearanceManager = this.getAppearanceManager();
            if (appearanceManager != null && (object = appearanceManager.getTwoDModelListener()) != null) {
                object.columnsRemoved(twoDModelEvent);
            }
            if ((object = this.getGridSelectionManager()) != null && (eventListener = object.getTwoDModelListener()) != null) {
                this._ignoreSelectionRepaints = true;
                eventListener.columnsRemoved(twoDModelEvent);
                this._ignoreSelectionRepaints = false;
            }
            this._columnsRemoved(n, n2);
            if (this._columnGM != null && (eventListener = this._columnGM.getOneDModelListener()) != null) {
                eventListener.itemsRemoved(new OneDModelEvent(this, 2002, n, n2));
            }
            if (this._focusCell != null && this._focusCell.column >= n && this._focusCell.column < n + n2 && this.isEditing()) {
                this.cancelCellEdit();
            }
            this._focusCell = this._removeColumnsFromCell(this._focusCell, n, n2);
            this.setAnchorCell(this._removeColumnsFromCell(this.getAnchorCell(), n, n2));
            this._moveCell = this._removeColumnsFromCell(this._moveCell, n, n2);
            this._mouseGrabCell = this._removeColumnsFromCell(this._mouseGrabCell, n, n2);
            if (this._focusCell == null) {
                int n5 = this.getNextVisibleColumn(-1);
                int n6 = this.getNextVisibleRow(-1);
                if (n5 != -1 && n6 != -1) {
                    this._focusCell = new Cell(n5, n6);
                }
            }
            Dimension dimension = this.getCanvasSize();
            Point point = this.getCanvasOrigin();
            Dimension dimension2 = this.layoutCanvas();
            this.setCanvasSize(dimension2.width, dimension2.height);
            if (n <= n3) {
                if (n + n2 - 1 < n3) {
                    this.setFirstColumnOnScreen(n3 - n2);
                } else {
                    int n7 = this.getNextVisibleColumn(-1);
                    int n8 = this.getNextVisibleColumn(n7);
                    while (n8 < n && n8 != -1) {
                        n7 = n8;
                        n8 = this.getNextVisibleColumn(n8);
                    }
                    if (n7 != -1) {
                        this.setFirstColumnOnScreen(n7);
                    } else {
                        this.setCanvasOrigin(0, this.getCanvasOrigin().y);
                    }
                }
            }
            this.revalidate();
            Object var15_17 = null;
            this.unfreezeRepaints();
            if (bl) {
                this.repaint();
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.unfreezeRepaints();
            if (bl) {
                this.repaint();
            }
            throw throwable;
        }
    }

    void internalInvalidateColumns(TwoDModelEvent twoDModelEvent) {
        GeometryManager geometryManager = this._getColumnGeometryManager();
        int n = twoDModelEvent.getColumnStartIndex();
        int n2 = n + twoDModelEvent.getColumnCount() - 1;
        int n3 = geometryManager.getItemPosition(n);
        int n4 = 0;
        int n5 = geometryManager.getItemPosition(n2) + geometryManager.getItemSize(n2);
        int n6 = this.getRowGeometryManager().getTotalSize();
        this.repaintCanvas(n3, n4, n5, n6);
    }

    void internalInvalidateCells(TwoDModelEvent twoDModelEvent) {
        GeometryManager geometryManager = this._getColumnGeometryManager();
        GeometryManager geometryManager2 = this.getRowGeometryManager();
        int n = twoDModelEvent.getColumnStartIndex();
        int n2 = n + twoDModelEvent.getColumnCount() - 1;
        int n3 = twoDModelEvent.getRowStartIndex();
        int n4 = n3 + twoDModelEvent.getRowCount() - 1;
        int n5 = geometryManager.getItemPosition(n);
        int n6 = geometryManager2.getItemPosition(n3);
        int n7 = geometryManager.getItemPosition(n2) + geometryManager.getItemSize(n2);
        int n8 = geometryManager2.getItemPosition(n4) + geometryManager2.getItemSize(n4);
        this.repaintCanvas(n5, n6, n7, n8);
    }

    void _doneEditing(boolean bl) {
        int n;
        int n2;
        Component component;
        Grid grid = this;
        synchronized (grid) {
            component = this._editControl;
            if (component == null || this._focusCell == null) {
                return;
            }
            n2 = this._focusCell.column;
            n = this._focusCell.row;
            this._removing = true;
            CellInputHandler cellInputHandler = this.getColumnCellInputHandler(n2);
            if (bl) {
                Object object = cellInputHandler.commitEdit(this, n2, n);
                if (cellInputHandler.isDirty(this, n2, n)) {
                    this.getModel().setData(n2, n, object);
                }
            } else {
                cellInputHandler.cancelEdit(this, n2, n);
            }
            this._removeListeners(this._editControlChildren);
            this._editControlChildren = null;
            this._editControl = null;
        }
        component.setVisible(false);
        this.remove(component);
        if (this._canRequestFocus) {
            this.requestFocus();
        } else {
            this._canRequestFocus = true;
        }
        this._removing = false;
        this.fireCellEvent(n2, n, 2002);
    }

    void setLastRowOnScreen(int n) {
        GeometryManager geometryManager = this.getRowGeometryManager();
        if (n < 0 || n >= this.getRowCount() || !geometryManager.isItemVisible(n)) {
            throw new IllegalArgumentException("Illegal row " + n);
        }
        if (this.getCanvasHeight() != 0) {
            int n2 = geometryManager.getItemPosition(n) - (this.getInnerSize().height - geometryManager.getItemSize(n) - geometryManager.getSeparatorSize());
            if (n2 < 0) {
                n2 = 0;
            }
            n2 = -n2;
            if (this.getCanvasOriginY() != n2) {
                this.commitCellEdit();
                this.setCanvasOrigin(this.getCanvasOriginX(), n2);
            }
        }
    }

    private GeometryManager _getColumnGeometryManager() {
        if (this._columnGM == null) {
            int n = this.getEWTGridUI().getDefaultColumnWidth(this);
            GeneralGeometryManager generalGeometryManager = new GeneralGeometryManager();
            generalGeometryManager.setDefaultItemSize(n);
            this.setColumnGeometryManager(generalGeometryManager);
        }
        return this._columnGM;
    }

    private void _addListeners(Component[] componentArray) {
        int n = 0;
        while (n < componentArray.length) {
            Component component = componentArray[n];
            component.addFocusListener(this._getFocusListener());
            component.addKeyListener(this._getKeyListener());
            ++n;
        }
    }

    private void _removeListeners(Component[] componentArray) {
        int n = 0;
        while (n < componentArray.length) {
            Component component = componentArray[n];
            component.removeKeyListener(this._getKeyListener());
            component.removeFocusListener(this._getFocusListener());
            ++n;
        }
    }

    private void _addNextFocus(Component[] componentArray) {
        if (componentArray == null) {
            return;
        }
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JComponent) {
                JComponent jComponent = (JComponent)componentArray[n];
                jComponent.setNextFocusableComponent(this);
            }
            ++n;
        }
    }

    private void _paintColumn(int n, boolean bl) {
        if (this.getVisibleRowCount() == 0 || !this.isColumnVisible(n) || !this.isColumnOnScreen(n)) {
            return;
        }
        this.validate();
        Rectangle rectangle = this._getColumnRect(n);
        if (bl) {
            this.paintImmediateInterior(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.repaintInterior(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void _paintRow(int n, boolean bl) {
        if (this.getVisibleColumnCount() == 0 || !this.isRowVisible(n) || !this.isRowOnScreen(n)) {
            return;
        }
        this.validate();
        Rectangle rectangle = this._getRowRect(n);
        if (bl) {
            this.paintImmediateInterior(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.repaintInterior(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void _paintCell(int n, int n2, boolean bl) {
        if (!this.isColumnVisible(n) || !this.isRowVisible(n2)) {
            return;
        }
        GeometryManager geometryManager = this.getRowGeometryManager();
        this.validate();
        int n3 = this._getColumnX(n) - 1;
        int n4 = geometryManager.getItemPosition(n2) - 1;
        int n5 = this._getColumnGeometryManager().getItemSize(n) + 1;
        int n6 = geometryManager.getItemSize(n2) + 1;
        if (bl) {
            this.paintImmediateInterior(n3, n4, n5, n6);
        } else {
            this.repaintInterior(n3, n4, n5, n6);
        }
    }

    private void _sendKeyToHandler(KeyEvent keyEvent) {
        GridKeyHandler gridKeyHandler = this.getGridKeyHandler();
        if (gridKeyHandler != null) {
            gridKeyHandler.handleKeyEvent(this, keyEvent);
        }
    }

    private CellRange[] _modelCellRangesFromVisibleCellRanges(CellRange[] cellRangeArray) {
        return this._transformCellRanges(cellRangeArray, false);
    }

    private CellRange[] _visibleCellRangesFromModelCellRanges(CellRange[] cellRangeArray) {
        return this._transformCellRanges(cellRangeArray, true);
    }

    private CellRange[] _transformCellRanges(CellRange[] cellRangeArray, boolean bl) {
        if (cellRangeArray == null) {
            return null;
        }
        GeometryManager geometryManager = this._getColumnGeometryManager();
        GeometryManager geometryManager2 = this.getRowGeometryManager();
        Vector<Range> vector = new Vector<Range>();
        Vector<Range> vector2 = new Vector<Range>();
        int n = 0;
        while (n < cellRangeArray.length) {
            int n2 = cellRangeArray[n].getLowerLimit().column;
            int n3 = cellRangeArray[n].getUpperLimit().column;
            int n4 = cellRangeArray[n].getLowerLimit().row;
            int n5 = cellRangeArray[n].getUpperLimit().row;
            vector.addElement(new Range(n2, n3));
            vector2.addElement(new Range(n4, n5));
            ++n;
        }
        Object[] objectArray = new Range[vector.size()];
        vector.copyInto(objectArray);
        Object[] objectArray2 = new Range[vector2.size()];
        vector2.copyInto(objectArray2);
        if (bl) {
            objectArray = geometryManager.rangesToVisibleRanges((Range[])objectArray);
            objectArray2 = geometryManager2.rangesToVisibleRanges((Range[])objectArray2);
        } else {
            objectArray = geometryManager.visibleRangesToRanges((Range[])objectArray);
            objectArray2 = geometryManager2.visibleRangesToRanges((Range[])objectArray2);
        }
        Vector<CellRange> vector3 = new Vector<CellRange>();
        n = 0;
        while (n < objectArray.length) {
            int n6 = 0;
            while (n6 < objectArray2.length) {
                CellRange cellRange = new CellRange(objectArray[n].getLowerLimit(), objectArray2[n6].getLowerLimit(), objectArray[n].getUpperLimit(), objectArray2[n6].getUpperLimit());
                vector3.addElement(cellRange);
                ++n6;
            }
            ++n;
        }
        Object[] objectArray3 = new CellRange[vector3.size()];
        vector3.copyInto(objectArray3);
        return objectArray3;
    }

    private CellRange[] _convertModelToVisibleRanges(CellRange[] cellRangeArray) {
        if (cellRangeArray == null || cellRangeArray.length == 0) {
            return null;
        }
        GeometryManager geometryManager = this._getColumnGeometryManager();
        GeometryManager geometryManager2 = this.getRowGeometryManager();
        CellRange[] cellRangeArray2 = null;
        int n = 0;
        while (n < cellRangeArray.length) {
            Cell cell = cellRangeArray[n].getLowerLimit();
            Cell cell2 = cellRangeArray[n].getUpperLimit();
            Range[] rangeArray = new Range[]{new Range(cell.column, cell2.column)};
            Range[] rangeArray2 = new Range[]{new Range(cell.row, cell2.row)};
            rangeArray = geometryManager.rangesToVisibleRanges(rangeArray);
            rangeArray2 = geometryManager2.rangesToVisibleRanges(rangeArray2);
            int n2 = 0;
            while (n2 < rangeArray.length) {
                int n3 = 0;
                while (n3 < rangeArray2.length) {
                    CellRange[] cellRangeArray3 = new CellRange[]{new CellRange(rangeArray[n2].getLowerLimit(), rangeArray2[n3].getLowerLimit(), rangeArray[n2].getUpperLimit(), rangeArray2[n3].getUpperLimit())};
                    cellRangeArray2 = CellRange.addCellRanges(cellRangeArray2, cellRangeArray3);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return cellRangeArray2;
    }

    private Cell _addColumnsToCell(Cell cell, int n, int n2) {
        if (cell != null && cell.column >= n) {
            cell.column += n2;
        }
        return cell;
    }

    private Cell _removeColumnsFromCell(Cell cell, int n, int n2) {
        if (cell != null) {
            if (cell.column >= n && cell.column < n + n2) {
                cell.column = n;
                if (cell.column >= this.getColumnCount()) {
                    cell.column = this.getColumnCount() - 1;
                }
                if (cell.column < 0) {
                    cell = null;
                }
            } else if (cell.column >= n + n2) {
                cell.column -= n2;
            }
        }
        return cell;
    }

    private Cell _addRowsToCell(Cell cell, int n, int n2) {
        if (cell != null && cell.row >= n) {
            cell.row += n2;
        }
        return cell;
    }

    private Cell _removeRowsFromCell(Cell cell, int n, int n2) {
        if (cell != null) {
            if (cell.row >= n && cell.row < n + n2) {
                cell.row = n;
                if (cell.row >= this.getRowCount()) {
                    cell.row = this.getRowCount() - 1;
                }
                if (cell.row < 0) {
                    cell = null;
                }
            } else if (cell.row >= n + n2) {
                cell.row -= n2;
            }
        }
        return cell;
    }

    private void _paintGrid(PaintContext paintContext, Graphics graphics, boolean bl) {
        Object object = this._paintLock;
        synchronized (object) {
            EWTGridUI eWTGridUI;
            BorderPainter borderPainter;
            this._paintExtraCanvas(graphics);
            if (this.getVisibleColumnCount() != 0 && this.getVisibleRowCount() != 0) {
                this._paintCells(paintContext, graphics, bl);
            }
            boolean bl2 = graphics instanceof PrintGraphics || graphics instanceof PrinterGraphics;
            if (this.isOverlayBorderVisible() & !bl2 && (this.getExtraCanvasBackground() == null || this.getFill() != null) && (borderPainter = (eWTGridUI = this.getEWTGridUI()).getOverlayBorderPainter(this)) != null) {
                borderPainter.paint(paintContext, graphics, 0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private void _paintExtraCanvas(Graphics graphics) {
        Color color = this.getExtraCanvasBackground();
        if (color != null && this.getFill() == null) {
            Color color2 = graphics.getColor();
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(color2);
        }
    }

    private Dimension _calculateCanvasSize() {
        Painter painter;
        GeometryManager geometryManager = this.getRowGeometryManager();
        GeometryManager geometryManager2 = this._getColumnGeometryManager();
        int n = !this.getHorizontalSeparatorsVisible() ? 0 : ((painter = this.getHorizontalSeparatorPainter()) == null ? 0 : painter.getPreferredSize((PaintContext)this.getPaintContext()).height);
        geometryManager.setSeparatorSize(n);
        n = !this.getVerticalSeparatorsVisible() ? 0 : this._vpWidth;
        geometryManager2.setSeparatorSize(n);
        int n2 = geometryManager2.getTotalSize();
        int n3 = geometryManager.getTotalSize();
        return new Dimension(n2, n3);
    }

    private void _paintCells(PaintContext paintContext, Graphics graphics, boolean bl) {
        GeometryManager geometryManager = this._getColumnGeometryManager();
        GeometryManager geometryManager2 = this.getRowGeometryManager();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.x < 0) {
            rectangle.width += rectangle.x;
            rectangle.x = 0;
        }
        if (rectangle.y < 0) {
            rectangle.height += rectangle.y;
            rectangle.y = 0;
        }
        int n = geometryManager.getItemAt(rectangle.x);
        int n2 = geometryManager2.getItemAt(rectangle.y);
        if (n != -1 && n2 != -1) {
            n = geometryManager.getItemVisibleIndex(n);
            n2 = geometryManager2.getItemVisibleIndex(n2);
            int n3 = geometryManager.getItemAt(rectangle.x + rectangle.width - 1);
            if (n3 == -1) {
                n3 = this.getPreviousVisibleColumn(this.getColumnCount());
            }
            n3 = geometryManager.getItemVisibleIndex(n3);
            int n4 = geometryManager2.getItemAt(rectangle.y + rectangle.height - 1);
            if (n4 == -1) {
                n4 = this.getPreviousVisibleRow(this.getRowCount());
            }
            n4 = geometryManager2.getItemVisibleIndex(n4);
            if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
                return;
            }
            if (n > n3) {
                int n5 = n3;
                n3 = n;
                n = n5;
            }
            SeparatorContext separatorContext = new SeparatorContext(paintContext);
            int n6 = n;
            while (n6 <= n3) {
                int n7 = geometryManager.visibleIndexToIndex(n6);
                if (geometryManager.isItemVisible(n7)) {
                    this._paintColumn(separatorContext, graphics, rectangle, n7, n2, n4);
                }
                ++n6;
            }
            if (n2 != 0) {
                --n2;
            }
            if (n != 0) {
                --n;
            }
            this._paintVerticalGridLines(separatorContext, graphics, rectangle, n2, n4, n, n3);
            this._paintHorizontalGridLines(separatorContext, graphics, rectangle, n, n3, n2, n4);
            this._paintFocusCellOrSelectionBorder(graphics, bl);
        }
    }

    private void _paintColumn(PaintContext paintContext, Graphics graphics, Rectangle rectangle, int n, int n2, int n3) {
        GeometryManager geometryManager = this.getRowGeometryManager();
        Shape shape = graphics.getClip();
        Painter painter = this.getColumnPainter(n);
        boolean bl = graphics instanceof PrintGraphics || graphics instanceof PrinterGraphics;
        CellPaintContext cellPaintContext = null;
        int n4 = this._getColumnX(n);
        int n5 = this._getColumnGeometryManager().getItemSize(n);
        boolean bl2 = this.getFill() == null && this.getExtraCanvasBackground() != null;
        int n6 = n2;
        while (n6 <= n3) {
            int n7 = geometryManager.visibleIndexToIndex(n6);
            if (geometryManager.isItemVisible(n7)) {
                int n8 = geometryManager.getItemPosition(n7);
                int n9 = this.getRowGeometryManager().getItemSize(n7);
                graphics.setClip(shape);
                graphics.clipRect(n4, n8, n5, n9);
                if (cellPaintContext == null) {
                    cellPaintContext = !bl ? new CellPaintContext(paintContext, n, n7) : new CellPrintPaintContext(paintContext, n, n7);
                } else {
                    cellPaintContext.setCell(n, n7);
                }
                ImmInsets immInsets = cellPaintContext.getAppearance().getInsets();
                BorderPainter borderPainter = cellPaintContext.getAppearance().getBorderPainter();
                ImmInsets immInsets2 = borderPainter != null && this.isCellBorderVisible() ? borderPainter.getFillInsets(cellPaintContext) : ImmInsets.getEmptyInsets();
                Color color = null;
                color = bl2 ? cellPaintContext.getPaintBackground() : cellPaintContext.getUsefulPaintBackground();
                if (color != null) {
                    graphics.setColor(color);
                    graphics.fillRect(n4 + immInsets2.left, n8 + immInsets2.top, n5 - (immInsets2.left + immInsets2.right), n9 - (immInsets2.top + immInsets2.bottom));
                }
                graphics.setColor(cellPaintContext.getPaintForeground());
                graphics.setFont(cellPaintContext.getPaintFont());
                if (borderPainter != null && this.isCellBorderVisible()) {
                    ImmInsets immInsets3 = borderPainter.getInsets(cellPaintContext);
                    immInsets = new ImmInsets(immInsets.top + immInsets3.top, immInsets.left + immInsets3.left, immInsets.bottom + immInsets3.bottom, immInsets.right + immInsets3.right);
                    borderPainter.paint(cellPaintContext, graphics, n4, n8, n5, n9);
                }
                painter.paint(cellPaintContext, graphics, n4 + immInsets.left, n8 + immInsets.top, n5 - (immInsets.left + immInsets.right), n9 - (immInsets.top + immInsets.bottom));
            }
            ++n6;
        }
        graphics.setClip(shape);
    }

    private void _paintHorizontalGridLines(PaintContext paintContext, Graphics graphics, Rectangle rectangle, int n, int n2, int n3, int n4) {
        GeometryManager geometryManager = this._getColumnGeometryManager();
        GeometryManager geometryManager2 = this.getRowGeometryManager();
        if (this.getHorizontalSeparatorsVisible() || this.getVerticalSeparatorsVisible()) {
            Painter painter;
            Painter painter2 = this.getHorizontalSeparatorPainter();
            if (painter2 == null) {
                return;
            }
            int n5 = painter2.getPreferredSize((PaintContext)paintContext).height;
            if (!this.getHorizontalSeparatorsVisible()) {
                n3 = n4 = this.getRowCount() - 1;
            }
            int n6 = geometryManager.visibleIndexToIndex(n);
            int n7 = this._getColumnX(n6);
            n6 = geometryManager.visibleIndexToIndex(n2);
            int n8 = this._getColumnX(n6) + geometryManager.getItemSize(n6) - n7 + 1;
            if (this.getVerticalSeparatorsVisible() && (painter = this.getVerticalSeparatorPainter()) != null) {
                int n9 = painter.getPreferredSize((PaintContext)paintContext).width;
                n7 -= n9;
                n8 += n9;
            }
            int n10 = n3;
            while (n10 <= n4) {
                n6 = geometryManager2.visibleIndexToIndex(n10);
                if (geometryManager2.isItemVisible(n6)) {
                    int n11 = geometryManager2.getItemSize(n6) + geometryManager2.getItemPosition(n6);
                    painter2.paint(paintContext, graphics, n7, n11, n8, n5);
                }
                ++n10;
            }
        }
    }

    private void _paintVerticalGridLines(PaintContext paintContext, Graphics graphics, Rectangle rectangle, int n, int n2, int n3, int n4) {
        if (this.getVerticalSeparatorsVisible() || this.getHorizontalSeparatorsVisible()) {
            Painter painter;
            boolean bl = this.getActualReadingDirection() == 1;
            Painter painter2 = this.getVerticalSeparatorPainter();
            if (painter2 == null) {
                return;
            }
            GeometryManager geometryManager = this.getRowGeometryManager();
            GeometryManager geometryManager2 = this._getColumnGeometryManager();
            int n5 = painter2.getPreferredSize((PaintContext)paintContext).width;
            if (!this.getVerticalSeparatorsVisible()) {
                n3 = n4 = this.getColumnCount() - 1;
            }
            int n6 = geometryManager.visibleIndexToIndex(n);
            int n7 = geometryManager.getItemPosition(n6);
            n6 = geometryManager.visibleIndexToIndex(n2);
            int n8 = geometryManager.getItemPosition(n6) + geometryManager.getItemSize(n6) - n7 + 1;
            if (this.getHorizontalSeparatorsVisible() && (painter = this.getHorizontalSeparatorPainter()) != null) {
                int n9 = painter.getPreferredSize((PaintContext)paintContext).height;
                n7 -= n9;
                n8 += n9;
            }
            int n10 = n3;
            while (n10 <= n4) {
                n6 = geometryManager2.visibleIndexToIndex(n10);
                if (geometryManager2.isItemVisible(n6)) {
                    int n11 = geometryManager2.getItemPosition(n6);
                    if (bl) {
                        n11 += geometryManager2.getItemSize(n6);
                    }
                    painter2.paint(paintContext, graphics, n11, n7, n5, n8);
                }
                ++n10;
            }
        }
    }

    private int _convertVisibleColumnIndexToColumnIndex(int n) {
        GeometryManager geometryManager = this._getColumnGeometryManager();
        if (this.getVisibleColumnCount() == this.getColumnCount()) {
            return n;
        }
        int n2 = 0;
        int n3 = -1;
        while (n3 < n) {
            int n4 = geometryManager.visibleIndexToIndex(n2);
            if (geometryManager.isItemVisible(n4)) {
                ++n3;
            }
            ++n2;
        }
        return n2 - 1;
    }

    private int _convertVisibleRowIndexToRowIndex(int n) {
        if (this.getVisibleRowCount() == this.getRowCount()) {
            return n;
        }
        int n2 = 0;
        int n3 = -1;
        GeometryManager geometryManager = this.getRowGeometryManager();
        while (n3 < n) {
            int n4 = geometryManager.visibleIndexToIndex(n2);
            if (geometryManager.isItemVisible(n4)) {
                ++n3;
            }
            ++n2;
        }
        return n2 - 1;
    }

    private void _handleKeyTyped(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this.getVisibleColumnCount() == 0 || this.getVisibleRowCount() == 0) {
            return;
        }
        if (this._focusCell != null && this.isCellEnabled(this._focusCell.column, this._focusCell.row)) {
            CellInputHandler cellInputHandler = this.getColumnCellInputHandler(this._focusCell.column);
            char c = keyEvent.getKeyChar();
            if (c == '\u001b' || c == '\r' || c == '\t' || c == '\n') {
                keyEvent.consume();
            }
            if (!keyEvent.isConsumed()) {
                cellInputHandler.keyTyped(keyEvent, this, this._focusCell.column, this._focusCell.row);
            }
        }
        if (!keyEvent.isConsumed()) {
            this._sendKeyToHandler(keyEvent);
        }
    }

    private void _handleKeyReleased(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this.getVisibleColumnCount() == 0 || this.getVisibleRowCount() == 0) {
            return;
        }
        if (this._focusCell != null && this.isCellEnabled(this._focusCell.column, this._focusCell.row)) {
            CellInputHandler cellInputHandler = this.getColumnCellInputHandler(this._focusCell.column);
            cellInputHandler.keyReleased(keyEvent, this, this._focusCell.column, this._focusCell.row);
        }
    }

    private void _handleKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this.getVisibleColumnCount() == 0 || this.getVisibleRowCount() == 0) {
            return;
        }
        if (this._focusCell != null && this.isCellEnabled(this._focusCell.column, this._focusCell.row)) {
            CellInputHandler cellInputHandler = this.getColumnCellInputHandler(this._focusCell.column);
            cellInputHandler.keyPressed(keyEvent, this, this._focusCell.column, this._focusCell.row);
        }
        if (!keyEvent.isConsumed()) {
            this._sendKeyToHandler(keyEvent);
        }
    }

    private Rectangle _getColumnRect(int n) {
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        Rectangle rectangle = new Rectangle();
        rectangle.x = this._getColumnX(n);
        rectangle.y = -point.y;
        rectangle.width = this._getColumnGeometryManager().getItemSize(n);
        rectangle.height = dimension.height;
        return rectangle;
    }

    private Rectangle _getRowRect(int n) {
        GeometryManager geometryManager = this.getRowGeometryManager();
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        Rectangle rectangle = new Rectangle();
        rectangle.x = -point.x;
        rectangle.y = geometryManager.getItemPosition(n);
        rectangle.width = dimension.width;
        rectangle.height = geometryManager.getItemSize(n);
        return rectangle;
    }

    private Rectangle _getCellRect(int n, int n2) {
        return this._getCellRect(n, n2, true);
    }

    private Rectangle _getCellRect(int n, int n2, boolean bl) {
        if (!(!bl || this.isColumnOnScreen(n) && this.isRowOnScreen(n2))) {
            return null;
        }
        GeometryManager geometryManager = this.getRowGeometryManager();
        Rectangle rectangle = new Rectangle();
        rectangle.x = this._getColumnX(n);
        rectangle.y = geometryManager.getItemPosition(n2);
        rectangle.width = this._getColumnGeometryManager().getItemSize(n);
        rectangle.height = geometryManager.getItemSize(n2);
        if (this.isOverlayBorderVisible()) {
            ImmInsets immInsets;
            EWTGridUI eWTGridUI = this.getEWTGridUI();
            BorderPainter borderPainter = eWTGridUI.getOverlayBorderPainter(this);
            ImmInsets immInsets2 = immInsets = borderPainter == null ? null : borderPainter.getInsets(this.getPaintContext());
            if (n == this.getFirstColumnOnScreen() && immInsets != null) {
                rectangle.x += immInsets.left;
                rectangle.width -= immInsets.left;
            }
            if (n2 == this.getFirstRowOnScreen() && immInsets != null) {
                rectangle.y += immInsets.top;
                rectangle.height -= immInsets.top;
            }
        }
        return rectangle;
    }

    private int _getColumnX(int n) {
        int n2 = this._getColumnGeometryManager().getItemPosition(n);
        if (this.getActualReadingDirection() == 2 && this.getVerticalSeparatorsVisible()) {
            n2 += this._vpWidth;
        }
        return n2;
    }

    private void _moveEditControl() {
        if (this._editControl == null || this._focusCell == null) {
            return;
        }
        CellInputHandler cellInputHandler = this.getColumnCellInputHandler(this._focusCell.column);
        Rectangle rectangle = cellInputHandler.getEditControlBounds(this, this._focusCell.column, this._focusCell.row);
        if (rectangle != null) {
            rectangle.x += this._getColumnX(this._focusCell.column);
            rectangle.y += this.getRowGeometryManager().getItemPosition(this._focusCell.row);
        } else {
            rectangle = this._getCellRect(this._focusCell.column, this._focusCell.row);
        }
        Point point = this.getCanvasOrigin();
        if (rectangle == null) {
            this._editControl.setVisible(false);
        } else {
            ImmInsets immInsets = this.getBorderInsets();
            rectangle.x += immInsets.left;
            rectangle.y += immInsets.top;
            this._editControl.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this._editControl.setVisible(true);
            this._editControl.validate();
            this._editControl.repaint();
        }
    }

    private boolean _isRowCompletelyOnScreen(int n) {
        GeometryManager geometryManager = this.getRowGeometryManager();
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        int n2 = geometryManager.getItemPosition(n);
        int n3 = geometryManager.getItemSize(n);
        point.y = -point.y;
        if (n2 < point.y || n2 > point.y + dimension.height) {
            return false;
        }
        return n2 + n3 <= point.y + dimension.height || n3 >= dimension.height;
    }

    private GridKeyListener _getKeyListener() {
        if (this._keyListener == null) {
            this._keyListener = new GridKeyListener();
        }
        return this._keyListener;
    }

    private FocusAdapter _getFocusListener() {
        if (this._focusListener == null) {
            this._focusListener = new EditFocus();
        }
        return this._focusListener;
    }

    private GeometryListener _getRowGeometryChangeListener() {
        if (this._rowGeometryChangeListener == null) {
            this._rowGeometryChangeListener = new RowGeometryChangeListener();
        }
        return this._rowGeometryChangeListener;
    }

    private GeometryListener _getColumnGeometryChangeListener() {
        if (this._columnGeometryChangeListener == null) {
            this._columnGeometryChangeListener = new ColumnGeometryChangeListener();
        }
        return this._columnGeometryChangeListener;
    }

    private void _handleMouseClicked(MouseEvent mouseEvent, Cell cell, CellInputHandler cellInputHandler) {
        if (cell != null && this.isCellEnabled(cell.column, cell.row)) {
            int n = -this.getColumnPosition(cell.column);
            int n2 = -this.getRowPosition(cell.row);
            mouseEvent.translatePoint(n, n2);
            cellInputHandler.mouseClicked(mouseEvent, this, cell.column, cell.row);
            mouseEvent.translatePoint(-n, -n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _handleMousePressed(MouseEvent mouseEvent, Cell cell, CellInputHandler cellInputHandler) {
        block20: {
            this._handlingMousePressed = true;
            boolean bl = SwingUtilities.isLeftMouseButton(mouseEvent);
            boolean bl2 = mouseEvent.isShiftDown();
            boolean bl3 = mouseEvent.isControlDown();
            this._cancelEdit = bl2 || bl3;
            this.freezeRepaints();
            try {
                try {
                    block24: {
                        block23: {
                            if (bl) {
                                this.requestFocus();
                            }
                            this._mouseGrabCell = cell;
                            this._mouseGrabCellArmed = true;
                            if (cell == null) break block20;
                            if (this.isCellEnabled(cell.column, cell.row)) {
                                int n = -this.getColumnPosition(cell.column);
                                int n2 = -this.getRowPosition(cell.row);
                                mouseEvent.translatePoint(n, n2);
                                cellInputHandler.mousePressed(mouseEvent, this, cell.column, cell.row);
                                mouseEvent.translatePoint(-n, -n2);
                            }
                            if (mouseEvent.isConsumed()) break block23;
                            if (bl) break block24;
                        }
                        Object var10_13 = null;
                        this.unfreezeRepaints();
                        this._handlingMousePressed = false;
                        return;
                    }
                    GridSelectionManager gridSelectionManager = this.getGridSelectionManager();
                    if (bl2) {
                        if (this.getAnchorCell() == null) {
                            this.setAnchorCell(cell);
                        }
                        TwoDSelection twoDSelection = this.getModelRangeSelection(cell.column, cell.row, this.getAnchorCell().column, this.getAnchorCell().row);
                        if (bl3) {
                            gridSelectionManager.addSelection(twoDSelection);
                        } else {
                            gridSelectionManager.setSelection(twoDSelection, null);
                        }
                    } else {
                        TwoDSelection twoDSelection = new TwoDSelection(null, null, cell);
                        if (bl3) {
                            if (gridSelectionManager.getSelection().containsCell(cell)) {
                                gridSelectionManager.removeSelection(twoDSelection);
                            } else {
                                gridSelectionManager.addSelection(twoDSelection);
                            }
                        } else {
                            gridSelectionManager.setSelection(twoDSelection, null);
                        }
                        this.setAnchorCell(cell);
                    }
                    mouseEvent.consume();
                }
                catch (PropertyVetoException propertyVetoException) {
                    Object var10_15 = null;
                    this.unfreezeRepaints();
                    this._handlingMousePressed = false;
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                this.unfreezeRepaints();
                this._handlingMousePressed = false;
                throw throwable;
            }
        }
        Object var10_14 = null;
        this.unfreezeRepaints();
        this._handlingMousePressed = false;
    }

    private void _handleMouseEntered(MouseEvent mouseEvent, Cell cell, CellInputHandler cellInputHandler) {
        this._moveCell = cell;
        if (this._moveCell != null && this.isCellEnabled(cell.column, cell.row)) {
            int n = -this.getColumnPosition(this._moveCell.column);
            int n2 = -this.getRowPosition(this._moveCell.row);
            mouseEvent.translatePoint(n, n2);
            cellInputHandler.mouseEntered(mouseEvent, this, this._moveCell.column, this._moveCell.row);
            mouseEvent.translatePoint(-n, -n2);
        }
    }

    private void _handleMouseExited(MouseEvent mouseEvent, Cell cell, CellInputHandler cellInputHandler) {
        if (this._moveCell != null && this.isCellEnabled(this._moveCell.column, this._moveCell.row)) {
            CellInputHandler cellInputHandler2 = this.getColumnCellInputHandler(this._moveCell.column);
            int n = -this.getColumnPosition(this._moveCell.column);
            int n2 = -this.getRowPosition(this._moveCell.row);
            mouseEvent.translatePoint(n, n2);
            cellInputHandler2.mouseExited(mouseEvent, this, this._moveCell.column, this._moveCell.row);
            mouseEvent.translatePoint(-n, -n2);
        }
    }

    private void _handleMouseReleased(MouseEvent mouseEvent, Cell cell, CellInputHandler cellInputHandler) {
        if (cell != null) {
            this.scrollCellIntoView(cell.column, cell.row);
        }
        GridAutoScroller.getAutoScroller().cancel();
        if (this._mouseGrabCell != null) {
            if (this.isCellEnabled(this._mouseGrabCell.column, this._mouseGrabCell.row)) {
                int n = this._mouseGrabCell.column;
                int n2 = this._mouseGrabCell.row;
                CellInputHandler cellInputHandler2 = this.getColumnCellInputHandler(n);
                int n3 = -this.getColumnPosition(n);
                int n4 = -this.getRowPosition(n2);
                mouseEvent.translatePoint(n3, n4);
                cellInputHandler2.mouseReleased(mouseEvent, this, n, n2);
                mouseEvent.translatePoint(-n3, -n4);
            }
            this._mouseGrabCell = null;
            this._mouseGrabCellArmed = false;
        }
        this._cancelEdit = false;
    }

    private void _handleMouseMoved(MouseEvent mouseEvent, Cell cell, CellInputHandler cellInputHandler) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        if (cell != null) {
            n3 = cell.column;
            n4 = cell.row;
        }
        if (this._moveCell != null) {
            n5 = this._moveCell.column;
            n6 = this._moveCell.row;
        }
        if (n3 != n5 || n4 != n6) {
            CellInputHandler cellInputHandler2;
            MouseEvent mouseEvent2;
            if (this._moveCell != null && this.isCellEnabled(this._moveCell.column, this._moveCell.row)) {
                mouseEvent2 = new MouseEvent(this, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), n - this.getColumnPosition(n5), n2 - this.getRowPosition(n6), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                cellInputHandler2 = this.getColumnCellInputHandler(n5);
                cellInputHandler2.mouseExited(mouseEvent2, this, n5, n6);
            }
            if (cell != null && this.isCellEnabled(cell.column, cell.row)) {
                mouseEvent2 = new MouseEvent(this, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), n - this.getColumnPosition(n3), n2 - this.getRowPosition(n4), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                cellInputHandler2 = this.getColumnCellInputHandler(n3);
                cellInputHandler2.mouseEntered(mouseEvent2, this, n3, n4);
            }
            this._moveCell = cell;
        }
        if (this._moveCell != null && this.isCellEnabled(this._moveCell.column, this._moveCell.row)) {
            int n7 = -this.getColumnPosition(this._moveCell.column);
            int n8 = -this.getRowPosition(this._moveCell.row);
            mouseEvent.translatePoint(n7, n8);
            cellInputHandler.mouseMoved(mouseEvent, this, this._moveCell.column, this._moveCell.row);
            mouseEvent.translatePoint(-n7, -n8);
        }
    }

    private void _handleMouseDragged(MouseEvent mouseEvent, Cell cell, CellInputHandler cellInputHandler) {
        if (this._mouseGrabCell != null) {
            Object object;
            int n = this._mouseGrabCell.column;
            int n2 = this._mouseGrabCell.row;
            if (this.isCellEnabled(n, n2)) {
                object = this.getColumnCellInputHandler(n);
                int n3 = -this.getColumnPosition(n);
                int n4 = -this.getRowPosition(n2);
                mouseEvent.translatePoint(n3, n4);
                this._mouseGrabCellArmed = mouseEvent.getX() >= 0 && mouseEvent.getX() <= this.getColumnWidth(n) && mouseEvent.getY() >= 0 && mouseEvent.getY() <= this.getRowHeight(n2);
                ((CellInputHandler)object).mouseDragged(mouseEvent, this, n, n2);
                mouseEvent.translatePoint(-n3, -n4);
            }
            if (!mouseEvent.isConsumed() && (InputEventUtils.getMods(mouseEvent) & 7) == 0 && cell != null) {
                this.freezeRepaints();
                try {
                    object = this.getGridSelectionManager();
                    Object object2 = this._scrollLock;
                    synchronized (object2) {
                        try {
                            object.setSelection(this.getModelRangeSelection(n, n2, cell.column, cell.row), this._mouseGrabCell);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        this._moveFocus(cell);
                        this._lastColumn = cell.column;
                        this._lastRow = cell.row;
                    }
                    Object var11_12 = null;
                    this.unfreezeRepaints();
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    this.unfreezeRepaints();
                    throw throwable;
                }
            }
        }
        this._checkScroller(mouseEvent);
    }

    private void _moveFocus(Cell cell) {
        GridSelectionManager gridSelectionManager = this.getGridSelectionManager();
        TwoDSelection twoDSelection = gridSelectionManager.getSelection();
        Cell cell2 = this.getFocusCell();
        if (cell2 != null && !twoDSelection.containsCell(cell2)) {
            OneDSelection oneDSelection = twoDSelection.getColumnSelection();
            OneDSelection oneDSelection2 = twoDSelection.getRowSelection();
            int n = -1;
            int n2 = -1;
            if (!oneDSelection.isEmpty()) {
                n = oneDSelection.getSingleItem();
            }
            if (!oneDSelection2.isEmpty()) {
                n2 = oneDSelection2.getSingleItem();
            }
            if (n == -1) {
                n = cell.column;
            }
            if (n2 == -1) {
                n2 = cell.row;
            }
            Cell cell3 = new Cell(n, n2);
            this.setFocusCell(cell3);
        }
    }

    void growSelection(boolean bl, int n) {
        if (this._mouseGrabCell != null) {
            GridSelectionManager gridSelectionManager = this.getGridSelectionManager();
            Object object = this._scrollLock;
            synchronized (object) {
                if (bl) {
                    this._lastColumn = n;
                } else {
                    this._lastRow = n;
                }
                TwoDSelection twoDSelection = this.getModelRangeSelection(this._mouseGrabCell.column, this._mouseGrabCell.row, this._lastColumn, this._lastRow);
                Cell cell = new Cell(this._lastColumn, this._lastRow);
                try {
                    gridSelectionManager.setSelection(twoDSelection, this._mouseGrabCell);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this._moveFocus(cell);
            }
        }
    }

    private void _checkScroller(MouseEvent mouseEvent) {
        int n;
        GridAutoScroller gridAutoScroller = GridAutoScroller.getAutoScroller();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = mouseEvent.getX() + this.getCanvasOriginX();
        int n3 = this.getInnerSize().width;
        int n4 = this.getColumnCount();
        int n5 = n = n4 == 0 ? 0 : this._getColumnGeometryManager().getTotalSize() / n4;
        if (n2 < (n /= 2)) {
            bl = true;
            bl3 = true;
        } else if (n2 > n3 - n) {
            bl = true;
            bl3 = false;
        }
        n2 = mouseEvent.getY() + this.getCanvasOriginY();
        n3 = this.getInnerSize().height;
        n4 = this.getRowCount();
        int n6 = n = n4 == 0 ? 0 : this.getRowGeometryManager().getTotalSize() / n4;
        if (n2 < (n /= 2)) {
            bl2 = true;
            bl4 = true;
        } else if (n2 > n3 - n) {
            bl2 = true;
            bl4 = false;
        }
        if (!bl2 & !bl) {
            gridAutoScroller.cancel();
        } else {
            gridAutoScroller.schedule(this, bl, bl3, bl2, bl4);
        }
    }

    private void _columnsAdded(int n, int n2) {
        if (this._painters != null) {
            this._painters.addItems(n, n2);
        }
        if (this._cellInputHandlers != null) {
            this._cellInputHandlers.addItems(n, n2);
        }
    }

    private void _columnsRemoved(int n, int n2) {
        if (this._painters != null) {
            this._painters.removeItems(n, n2);
        }
        if (this._cellInputHandlers != null) {
            this._cellInputHandlers.removeItems(n, n2);
        }
    }

    private void _checkForFirstColumnRow(Dimension dimension) {
        int n;
        Dimension dimension2 = this.getInnerSize();
        if (this._firstColumn != -1) {
            if (dimension.width != 0) {
                this.setFirstColumnOnScreen(this._firstColumn);
            }
        } else if (dimension2.width >= dimension.width && dimension.width != 0 && (n = this.getNextVisibleColumn(-1)) != -1) {
            this.setFirstColumnOnScreen(n);
        }
        if (this._firstRow != -1) {
            if (dimension.height != 0) {
                this.setFirstRowOnScreen(this._firstRow);
            }
        } else if (dimension2.height >= dimension.height && dimension.height != 0 && (n = this.getNextVisibleRow(-1)) != -1) {
            this.setFirstRowOnScreen(n);
        }
    }

    private void _unregisterKeyboardActions() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(33, 0);
        this.unregisterKeyboardAction(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(34, 0);
        this.unregisterKeyboardAction(keyStroke);
    }

    private void _registerKeyboardActions() {
        Key key = new Key();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(33, 0);
        this.registerKeyboardAction(key, _PAGE_UP, keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(34, 0);
        this.registerKeyboardAction(key, _PAGE_DOWN, keyStroke, 0);
    }

    private void _updateCellInputHandlerUI() {
        if (this._cellInputHandlers != null) {
            int n = this._cellInputHandlers.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                Object object = this._cellInputHandlers.getData(n2);
                if (object != null) {
                    ((CellInputHandler)object).updateUI();
                }
                ++n2;
            }
        }
        CellInputHandler cellInputHandler = this.getDefaultInputHandler();
        cellInputHandler.updateUI();
    }

    private SelectionListener _getSelectionListener() {
        if (this._selectionListener == null) {
            this._selectionListener = new SelectionListener();
        }
        return this._selectionListener;
    }

    private void _paintSelections(TwoDSelection twoDSelection) {
        this.freezeRepaints();
        try {
            this._paintColumnRanges(twoDSelection.getColumnSelection().getRanges());
            this._paintRowRanges(twoDSelection.getRowSelection().getRanges());
            this._paintCellRanges(twoDSelection.getCellRanges());
            Object var3_2 = null;
            this.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
    }

    private void _paintColumnRanges(Range[] rangeArray) {
        int n = rangeArray == null ? 0 : rangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = rangeArray[n2].getLowerLimit();
            while (n3 <= rangeArray[n2].getUpperLimit()) {
                this.paintColumn(n3);
                ++n3;
            }
            ++n2;
        }
    }

    private void _paintRowRanges(Range[] rangeArray) {
        int n = rangeArray == null ? 0 : rangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = rangeArray[n2].getLowerLimit();
            while (n3 <= rangeArray[n2].getUpperLimit()) {
                this.paintRow(n3);
                ++n3;
            }
            ++n2;
        }
    }

    private void _paintCellRanges(CellRange[] cellRangeArray) {
        int n = (cellRangeArray = this._visibleCellRangesFromModelCellRanges(cellRangeArray)) == null ? 0 : cellRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.paintVisibleCellRange(cellRangeArray[n2]);
            ++n2;
        }
    }

    private void _startCellEdit(int n, int n2) {
        Grid grid = this;
        synchronized (grid) {
            if (this.isEditing() && this._focusCell != null && this._focusCell.column == n && this._focusCell.row == n2) {
                return;
            }
        }
        CellInputHandler cellInputHandler = this.getColumnCellInputHandler(n);
        Component component = cellInputHandler.getEditControl(this, n, n2);
        if (component == null) {
            return;
        }
        if (this.fireCancelableCellEvent(n, n2, 2001)) {
            return;
        }
        this._editControl = component;
        this._editControlChildren = cellInputHandler.getFocusableComponents(this, n, n2);
        this._addListeners(this._editControlChildren);
        component.setVisible(false);
        this.add(component);
        AppearanceManager appearanceManager = this.getAppearanceManager();
        Appearance appearance = appearanceManager.getCellPaintingAppearance(n, n2);
        Font font = appearance.getFont();
        if (font == null) {
            font = this.getFont();
        }
        component.setFont(font);
        this._addNextFocus(this._editControlChildren);
        this.freezeRepaints();
        try {
            this.requestFocus(n, n2, null);
            this.scrollCellIntoView(n, n2);
            Object object = this.getModel().getData(n, n2);
            try {
                cellInputHandler.startEdit(this, n, n2, object);
            }
            catch (Exception exception) {
                this._doneEditing(false);
                Object var12_12 = null;
                this.unfreezeRepaints();
                return;
            }
            this._moveEditControl();
            if (component.isVisible()) {
                component.requestFocus();
            }
            Object var12_13 = null;
            this.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
    }

    private void _setDrawSelectionBorder(boolean bl, boolean bl2) {
        if (bl != this._drawSelectionBorder) {
            this._drawSelectionBorder = bl;
            if (bl2) {
                this._paintSelections(this.getSelection());
            }
        }
    }

    private void _paintFocusCellOrSelectionBorder(Graphics graphics, boolean bl) {
        if (this.hasFocus() || this.isAlwaysDrawFocusCellHighlite()) {
            boolean bl2 = false;
            if (this.getDrawSelectionBorder()) {
                Cell cell = this.getFocusCell();
                TwoDSelection twoDSelection = this.getSelection();
                if (cell == null || twoDSelection.containsCell(cell)) {
                    bl2 = this.paintSelectionBorder(graphics);
                }
            }
            if (!bl2 && bl && this.getDrawFocusCellHighlite()) {
                this.paintFocusCell(graphics);
            }
        }
    }

    private void _paintBorderAroundCells(Rectangle rectangle, Graphics graphics) {
        BorderPainter borderPainter = (BorderPainter)UIManager.get("Grid.focusPainter");
        if (borderPainter != null) {
            borderPainter.paint(this.getPaintContext(), graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private Rectangle _getSelectionBounds() {
        CellRange[] cellRangeArray;
        Object object;
        Object object2;
        Range[] rangeArray;
        TwoDSelection twoDSelection = this.getSelection();
        if (twoDSelection.isEmpty()) {
            return null;
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        GeometryManager geometryManager = this._getColumnGeometryManager();
        GeometryManager geometryManager2 = this.getRowGeometryManager();
        Range[] rangeArray2 = twoDSelection.getColumnSelection().getRanges();
        if (rangeArray2 != null && rangeArray2.length != 0) {
            rangeArray = geometryManager.rangesToVisibleRanges(rangeArray2);
            int n5 = 0;
            while (n5 < rangeArray.length) {
                n2 = n2 == -1 ? rangeArray[n5].getLowerLimit() : Math.min(n2, rangeArray[n5].getLowerLimit());
                n4 = n4 == -1 ? rangeArray[n5].getUpperLimit() : Math.max(n4, rangeArray[n5].getUpperLimit());
                ++n5;
            }
            object2 = new Range[]{new Range(n2, n4)};
            if (Range.rangesContain((Range[])rangeArray, (Range[])object2)) {
                n = 0;
                n3 = this.getVisibleRowCount() - 1;
            } else {
                n4 = -1;
                n2 = -1;
            }
        }
        if ((rangeArray = twoDSelection.getRowSelection().getRanges()) != null && rangeArray.length != 0) {
            Range[] rangeArray3 = geometryManager2.rangesToVisibleRanges(rangeArray);
            int n6 = 0;
            while (n6 < rangeArray3.length) {
                n = n == -1 ? rangeArray3[n6].getLowerLimit() : Math.min(n, rangeArray3[n6].getLowerLimit());
                n3 = n3 == -1 ? rangeArray3[n6].getUpperLimit() : Math.max(n3, rangeArray3[n6].getUpperLimit());
                ++n6;
            }
            object = new Range[]{new Range(n, n3)};
            if (Range.rangesContain((Range[])rangeArray3, (Range[])object)) {
                n2 = 0;
                n4 = this.getVisibleColumnCount() - 1;
            } else {
                n3 = -1;
                n = -1;
            }
        }
        if ((cellRangeArray = this._convertModelToVisibleRanges(twoDSelection.getCellRanges())) != null && cellRangeArray.length != 0) {
            int n7 = 0;
            while (n7 < cellRangeArray.length) {
                object2 = cellRangeArray[n7].getLowerLimit();
                object = cellRangeArray[n7].getUpperLimit();
                n2 = n2 == -1 ? object2.column : Math.min(n2, object2.column);
                n4 = n4 == -1 ? object.column : Math.max(n4, object.column);
                n = n == -1 ? object2.row : Math.min(n, object2.row);
                n3 = n3 == -1 ? object.row : Math.max(n3, object.row);
                ++n7;
            }
            CellRange[] cellRangeArray2 = new CellRange[]{new CellRange(n2, n, n4, n3)};
            if (!CellRange.cellRangesContain(cellRangeArray, cellRangeArray2)) {
                n4 = -1;
                n3 = -1;
                n2 = -1;
                n = -1;
            }
        }
        if (n == -1 || n2 == -1 || n4 == -1 || n3 == -1) {
            return null;
        }
        n2 = geometryManager.visibleIndexToIndex(n2);
        n = geometryManager2.visibleIndexToIndex(n);
        n4 = geometryManager.visibleIndexToIndex(n4);
        n3 = geometryManager2.visibleIndexToIndex(n3);
        return this.getCellBounds(n2, n, n4, n3);
    }

    public final AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = this.createAccessibleGrid();
        }
        return this.accessibleContext;
    }

    public AccessibleGrid getAccessibleGrid() {
        return (AccessibleGrid)this.accessibleContext;
    }

    protected AccessibleGrid createAccessibleGrid() {
        return new AccessibleGrid();
    }

    void _fireActiveEvent(Cell cell, Cell cell2) {
        AccessibleGrid accessibleGrid = this.getAccessibleGrid();
        if (accessibleGrid != null) {
            int n;
            Accessible accessible = null;
            Accessible accessible2 = null;
            if (cell != null) {
                n = accessibleGrid.getAccessibleIndexAt(cell.column, cell.row);
                accessible = accessibleGrid.getAccessibleChild(n);
            }
            if (cell2 != null) {
                n = accessibleGrid.getAccessibleIndexAt(cell2.column, cell2.row);
                accessible2 = accessibleGrid.getAccessibleChild(n);
            }
            accessibleGrid.firePropertyChange("AccessibleActiveDescendant", accessible, accessible2);
        }
    }

    private class SeparatorContext
    extends PaintContextProxy {
        private PaintContext _context;

        public SeparatorContext(PaintContext paintContext) {
            this._context = paintContext;
        }

        protected PaintContext getPaintContext() {
            return this._context;
        }

        public Object getPaintData(Object object) {
            Object object2 = super.getPaintData(object);
            if (object2 == null) {
                object2 = Grid.this.getPaintData(object);
            }
            return object2;
        }
    }

    private class CellPaintContext
    extends PaintContextProxy {
        private int _column;
        private int _row;
        private int _paintState;
        private PaintContext _context;

        public CellPaintContext(PaintContext paintContext, int n, int n2) {
            this._context = paintContext;
            this.setCell(n, n2);
        }

        public void setCell(int n, int n2) {
            this._column = n;
            this._row = n2;
            this._paintState = this._getPaintState();
        }

        protected PaintContext getPaintContext() {
            return this._context;
        }

        public int getPaintState() {
            return this._paintState;
        }

        private int _getPaintState() {
            Cell cell;
            int n = super.getPaintState();
            GridSelectionManager gridSelectionManager = Grid.this.getGridSelectionManager();
            if (Grid.this.isEnabled()) {
                cell = Grid.this.getFocusCell();
                TwoDSelection twoDSelection = gridSelectionManager.getSelection();
                if ((twoDSelection.containsCell(this._column, this._row) || twoDSelection.containsColumn(this._column) || twoDSelection.containsRow(this._row)) && (!Grid.this.isEditing() || cell == null || this._column != cell.column || this._row != cell.row)) {
                    n |= 0x20;
                }
                if (cell != null && cell.column == this._column && cell.row == this._row) {
                    if (((n |= 0x40) & 0x20) != 0 && Grid.this.getDrawSelectionBorder() && ((n & 4) == 0 && Grid.this.hasFocus() || Grid.this.isAlwaysDrawFocusCellHighlite())) {
                        n &= 0xFFFFFFDF;
                    }
                } else {
                    n &= 0xFFFFFFBF;
                }
            }
            if ((cell = Grid.this._mouseGrabCell) != null && cell.column == this._column && cell.row == this._row && Grid.this._mouseGrabCellArmed) {
                n |= 2;
            }
            return Grid.this.getCellPaintState(n, this._column, this._row);
        }

        public Color getPaintForeground() {
            int n = this.getPaintState();
            if ((n & 1) != 0) {
                return this.getPaintContext().getPaintUIDefaults().getColor("textInactiveText");
            }
            if ((n & 0x20) == 0 || Grid.this.isSelectionTransparent()) {
                Color color = this.getAppearance().getForeground();
                if (color == null) {
                    color = super.getPaintForeground();
                }
                return color;
            }
            return this.getAppearance().getSelectForeground();
        }

        public Font getPaintFont() {
            int n = this.getPaintState();
            Font font = null;
            if ((n & 0x20) != 0 && !Grid.this.isSelectionTransparent()) {
                font = this.getAppearance().getSelectFont();
            }
            if (font == null) {
                font = this.getAppearance().getFont();
            }
            if (font == null) {
                font = super.getPaintFont();
            }
            return font;
        }

        public Color getPaintBackground() {
            Color color = this.getUsefulPaintBackground();
            if (color == null) {
                color = super.getPaintBackground();
            }
            return color;
        }

        Color getUsefulPaintBackground() {
            boolean bl;
            int n = this.getPaintState();
            Color color = null;
            boolean bl2 = (n & 0x20) != 0;
            boolean bl3 = (n & 4) == 0;
            boolean bl4 = bl = (n & 1) != 0;
            if (bl) {
                return UIManager.getColor("Grid.disabledBackground");
            }
            if (bl2) {
                if (bl3) {
                    color = this.getAppearance().getSelectBackground();
                    if (Grid.this.isSelectionTransparent() && color != null) {
                        Color color2 = this.getAppearance().getBackground();
                        if (color2 == null) {
                            color2 = super.getPaintBackground();
                        }
                        if (color2 != null) {
                            color = ColorUtils.getTransparentColor(color2, color, 60);
                        }
                    }
                } else {
                    color = UIManager.getColor("Grid.inactiveSelectedBackground");
                }
            }
            if (color == null) {
                color = this.getAppearance().getBackground();
            }
            return color;
        }

        public float getInteriorAlignmentX() {
            float f;
            Appearance appearance = this.getAppearance();
            int n = appearance.getHorizontalJustify();
            if (n == 0) {
                int n2 = appearance.getReadingDirection();
                switch (n2) {
                    case 0: {
                        return super.getInteriorAlignmentX();
                    }
                }
                n = LocaleUtils.getAlignmentForReadingDirection(n2);
            }
            switch (n) {
                case 3: {
                    f = 0.5f;
                    break;
                }
                case 2: {
                    f = 1.0f;
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            return f;
        }

        public float getInteriorAlignmentY() {
            int n = this.getAppearance().getVerticalJustify();
            float f = 0.0f;
            switch (n) {
                case 1: {
                    f = 0.5f;
                    break;
                }
                case 0: {
                    f = 0.0f;
                    break;
                }
                case 2: {
                    f = 1.0f;
                }
            }
            return f;
        }

        public int getReadingDirection() {
            int n = this.getAppearance().getReadingDirection();
            if (n == 0) {
                n = super.getReadingDirection();
            }
            return n;
        }

        public Object getPaintData(Object object) {
            int n = this._column;
            if (object == PaintContext.MNEMONIC_INDEX_KEY) {
                return null;
            }
            if (Grid.APPEARANCE_KEY.equals(object)) {
                return this.getAppearance();
            }
            if (Grid.CELL_KEY.equals(object)) {
                return new Cell(n, this._row);
            }
            Object object2 = super.getPaintData(object);
            if (object2 == null) {
                object2 = Grid.this.getPaintData(object);
            }
            if (object2 == null) {
                try {
                    object2 = Grid.this.getModel().getData(n, this._row);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object2;
        }

        public Appearance getAppearance() {
            AppearanceManager appearanceManager = Grid.this.getAppearanceManager();
            return appearanceManager.getCellPaintingAppearance(this._column, this._row);
        }
    }

    private class CellPrintPaintContext
    extends CellPaintContext {
        public CellPrintPaintContext(PaintContext paintContext, int n, int n2) {
            super(paintContext, n, n2);
        }

        public int getPaintState() {
            return this.getPaintContext().getPaintState();
        }
    }

    private class RowGeometryChangeListener
    implements GeometryListener {
        private RowGeometryChangeListener() {
        }

        public void geometryChanged(GeometryEvent geometryEvent) {
            int n = geometryEvent.getItem();
            switch (geometryEvent.getID()) {
                case 2005: {
                    GeometryManager geometryManager = Grid.this.getRowGeometryManager();
                    Grid.this.freezeRepaints();
                    try {
                        Grid.this.commitCellEdit();
                        Dimension dimension = Grid.this.layoutCanvas();
                        Grid.this.setCanvasSize(dimension.width, dimension.height);
                        if (Grid.this.isRowOnScreen(n)) {
                            dimension = Grid.this.getInnerSize();
                            Point point = Grid.this.getCanvasOrigin();
                            int n2 = geometryManager.getItemPosition(n);
                            if (n2 < -point.y) {
                                n2 = -point.y;
                            }
                            Grid.this.repaintCanvas(-point.x, n2, dimension.width, dimension.height);
                        }
                        Object var8_9 = null;
                        Grid.this.unfreezeRepaints();
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        Grid.this.unfreezeRepaints();
                        throw throwable;
                    }
                }
                case 2003: {
                    if (geometryEvent.getSize() == 0) {
                        if (Grid.this._firstRow == n) {
                            Grid.this._firstRow = Grid.this.getNextVisibleRow(Grid.this._firstRow);
                        }
                        if (Grid.this._focusCell != null && n == Grid.this._focusCell.row) {
                            int n3 = Grid.this._focusCell.column;
                            int n4 = Grid.this.getNextVisibleRow(n);
                            if (n4 == -1) {
                                n3 = -1;
                            }
                            Grid.this._focusCell = new Cell(n3, n4);
                        }
                    }
                    Grid.this.invalidateCanvas();
                    break;
                }
                default: {
                    Grid.this.invalidateCanvas();
                }
            }
        }
    }

    private class ColumnGeometryChangeListener
    implements GeometryListener {
        private ColumnGeometryChangeListener() {
        }

        public void geometryChanged(GeometryEvent geometryEvent) {
            int n = geometryEvent.getItem();
            switch (geometryEvent.getID()) {
                case 2005: {
                    GeometryManager geometryManager = Grid.this._getColumnGeometryManager();
                    Grid.this.freezeRepaints();
                    try {
                        Grid.this.commitCellEdit();
                        Dimension dimension = Grid.this.layoutCanvas();
                        Grid.this.setCanvasSize(dimension.width, dimension.height);
                        if (Grid.this.isColumnOnScreen(n)) {
                            dimension = Grid.this.getInnerSize();
                            Point point = Grid.this.getCanvasOrigin();
                            int n2 = geometryManager.getItemPosition(n);
                            if (n2 < -point.x) {
                                n2 = -point.x;
                            }
                            Grid.this.repaintCanvas(n2, -point.y, dimension.width, dimension.height);
                        }
                        Object var8_9 = null;
                        Grid.this.unfreezeRepaints();
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        Grid.this.unfreezeRepaints();
                        throw throwable;
                    }
                }
                case 2003: {
                    if (geometryEvent.getSize() == 0) {
                        if (Grid.this._firstColumn == n) {
                            Grid.this._firstColumn = Grid.this.getNextVisibleColumn(Grid.this._firstColumn);
                        }
                        if (Grid.this._focusCell != null && n == Grid.this._focusCell.column) {
                            int n3 = Grid.this.getNextVisibleColumn(n);
                            int n4 = Grid.this._focusCell.row;
                            if (n3 == -1) {
                                n4 = -1;
                            }
                            Grid.this._focusCell = new Cell(n3, n4);
                        }
                    }
                    Grid.this.invalidateCanvas();
                    break;
                }
                default: {
                    Grid.this.invalidateCanvas();
                }
            }
        }
    }

    private class SelectionListener
    implements VetoableChangeListener,
    PropertyChangeListener {
        private SelectionListener() {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Grid.this.fireVetoableChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!Grid.this._ignoreSelectionRepaints) {
                GridSelectionManager gridSelectionManager = Grid.this.getGridSelectionManager();
                TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getOldValue();
                TwoDSelection twoDSelection2 = (TwoDSelection)propertyChangeEvent.getNewValue();
                TwoDSelection twoDSelection3 = gridSelectionManager.getRepaintSelection(twoDSelection, twoDSelection2);
                Grid.this._paintSelections(twoDSelection3);
            }
            Grid.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    private class DSListen
    implements TwoDModelListener {
        private DSListen() {
        }

        public void rowsAdded(TwoDModelEvent twoDModelEvent) {
            Grid.this.internalRowsAdded(twoDModelEvent);
        }

        public void rowsRemoved(TwoDModelEvent twoDModelEvent) {
            Grid.this.internalRowsRemoved(twoDModelEvent);
        }

        public void invalidateRows(TwoDModelEvent twoDModelEvent) {
            Grid.this.internalInvalidateRows(twoDModelEvent);
        }

        public void columnsAdded(TwoDModelEvent twoDModelEvent) {
            Grid.this.internalColumnsAdded(twoDModelEvent);
        }

        public void columnsRemoved(TwoDModelEvent twoDModelEvent) {
            Grid.this.internalColumnsRemoved(twoDModelEvent);
        }

        public void invalidateColumns(TwoDModelEvent twoDModelEvent) {
            Grid.this.internalInvalidateColumns(twoDModelEvent);
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            Grid.this.internalInvalidateCells(twoDModelEvent);
        }
    }

    private class EditFocus
    extends FocusAdapter {
        private EditFocus() {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                Grid.this.focusLost(focusEvent);
            }
        }
    }

    private class Change
    implements ChangeListener {
        private Change() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Grid.this._doneEditing(true);
        }
    }

    private class GridKeyListener
    extends KeyAdapter {
        private GridKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                Grid.this.cancelCellEdit();
                keyEvent.consume();
            } else if (keyEvent.getKeyCode() == 10) {
                Grid.this._sendKeyToHandler(keyEvent);
                keyEvent.consume();
            }
        }
    }

    private class Key
    implements ActionListener {
        private Key() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = Grid._PAGE_UP.equals(string) ? 33 : 34;
            KeyEvent keyEvent = new KeyEvent(Grid.this, 401, 0L, actionEvent.getModifiers(), n);
            Grid.this._sendKeyToHandler(keyEvent);
        }
    }

    public class AccessibleGrid
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    PropertyChangeListener,
    TwoDModelListener,
    GridEditListener,
    GeometryListener {
        public AccessibleGrid() {
            super(Grid.this);
            Grid.this.addPropertyChangeListener(this);
            Grid.this.getModel().addModelListener(this);
            Grid.this.getColumnGeometryManager().addGeometryListener(this);
            Grid.this.getRowGeometryManager().addGeometryListener(this);
            Grid.this.addEditListener(this);
        }

        public String getAccessibleName() {
            AccessibleContext accessibleContext;
            Accessible accessible;
            String string = super.getAccessibleName();
            if (string == null && (accessible = ((Component.AccessibleAWTComponent)this).getAccessibleParent()) != null && (accessibleContext = accessible.getAccessibleContext()) != null && accessibleContext.getAccessibleRole() == AccessibleRole.TABLE) {
                return accessibleContext.getAccessibleName();
            }
            return string;
        }

        public int getAccessibleRowAtIndex(int n) {
            int n2 = Grid.this.getColumnCount();
            if (n2 == 0) {
                return -1;
            }
            return n / n2;
        }

        public int getAccessibleColumnAtIndex(int n) {
            int n2 = Grid.this.getColumnCount();
            if (n2 == 0) {
                return -1;
            }
            return n % n2;
        }

        public int getAccessibleIndexAt(int n, int n2) {
            return n2 * Grid.this.getColumnCount() + n;
        }

        public String getAccessibleName(int n, int n2) {
            Object object = Grid.this.getModel().getData(n, n2);
            return this.getAccessibleName(n, n2, object);
        }

        public String getAccessibleDescription(int n, int n2) {
            GridToolTipManager gridToolTipManager = Grid.this.getToolTipManager();
            if (gridToolTipManager == null) {
                return null;
            }
            return gridToolTipManager.getCellToolTipValue(Grid.this, n, n2);
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        public Accessible getAccessibleAt(Point point) {
            Point point2 = Grid.this.convertOuterToCanvas(point.x, point.y);
            Cell cell = Grid.this.getCellAt(point2.x, point2.y);
            if (cell != null) {
                return this.getAccessibleChild(this.getAccessibleIndexAt(cell.column, cell.row));
            }
            return null;
        }

        public int getAccessibleChildrenCount() {
            return Grid.this.getModel() == null ? 0 : Grid.this.getColumnCount() * Grid.this.getRowCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return null;
            }
            return new AccessibleGridCell(n);
        }

        public int getAccessibleSelectionCount() {
            int n = Grid.this.getSelection().getSelectedCellCount();
            return n;
        }

        public Accessible getAccessibleSelection(int n) {
            TwoDSelection twoDSelection = Grid.this.getSelection();
            Cell cell = twoDSelection.getSelectedCellAtIndex(n);
            if (cell != null) {
                int n2 = this.getAccessibleIndexAt(cell.column, cell.row);
                return this.getAccessibleChild(n2);
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            TwoDSelection twoDSelection = Grid.this.getSelection();
            int n2 = this.getAccessibleColumnAtIndex(n);
            int n3 = this.getAccessibleRowAtIndex(n);
            if (n2 != -1 && n3 != -1) {
                Cell cell = new Cell(n2, n3);
                return twoDSelection.containsCell(cell);
            }
            return false;
        }

        public void addAccessibleSelection(int n) {
            TwoDSelection twoDSelection = Grid.this.getSelection();
            int n2 = this.getAccessibleColumnAtIndex(n);
            int n3 = this.getAccessibleRowAtIndex(n);
            if (n2 != -1 && n3 != -1) {
                Cell cell = new Cell(n2, n3);
                try {
                    Grid.this.getGridSelectionManager().addSelection(new TwoDSelection(cell));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public void removeAccessibleSelection(int n) {
            TwoDSelection twoDSelection = Grid.this.getSelection();
            int n2 = this.getAccessibleColumnAtIndex(n);
            int n3 = this.getAccessibleRowAtIndex(n);
            if (n2 != -1 && n3 != -1) {
                Cell cell = new Cell(n2, n3);
                try {
                    Grid.this.getGridSelectionManager().removeSelection(new TwoDSelection(cell));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public void clearAccessibleSelection() {
            try {
                Grid.this.deselectAll();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void selectAllAccessibleSelection() {
            try {
                Grid.this.selectAll();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (Grid.PROPERTY_MODEL.equals(string)) {
                if (object != null) {
                    ((TwoDModel)object).removeModelListener(this);
                }
                if (object2 != null) {
                    ((TwoDModel)object2).addModelListener(this);
                }
            } else if (Grid.PROPERTY_COLUMN_GEOMETRY_MANAGER.equals(string) || Grid.PROPERTY_ROW_GEOMETRY_MANAGER.equals(string)) {
                if (object != null) {
                    ((GeometryManager)object).removeGeometryListener(this);
                }
                if (object2 != null) {
                    ((GeometryManager)object2).addGeometryListener(this);
                }
            } else if (Grid.PROPERTY_SELECTION.equals(string)) {
                this.firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
            } else if (Grid.PROPERTY_FOCUSCELL.equals(string)) {
                Cell cell = (Cell)object;
                Cell cell2 = (Cell)object2;
                Grid.this._fireActiveEvent(cell, cell2);
            }
        }

        public void rowsAdded(TwoDModelEvent twoDModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void rowsRemoved(TwoDModelEvent twoDModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void invalidateRows(TwoDModelEvent twoDModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void columnsAdded(TwoDModelEvent twoDModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void columnsRemoved(TwoDModelEvent twoDModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void invalidateColumns(TwoDModelEvent twoDModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void cellEditing(GridEvent gridEvent) {
        }

        public void cellEdited(GridEvent gridEvent) {
            Grid.this._fireActiveEvent(null, gridEvent.getCell());
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void geometryChanged(GeometryEvent geometryEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        protected String getAccessibleName(int n, int n2, Object object) {
            Painter painter;
            AbstractBigCell abstractBigCell = null;
            if (object instanceof AbstractBigCell) {
                abstractBigCell = (AbstractBigCell)object;
                object = abstractBigCell.getData();
            } else if (object instanceof HDataObject) {
                object = ((HDataObject)object).getData();
            }
            String string = null;
            string = object == null ? null : (object instanceof String ? (String)object : (object instanceof Boolean ? object.toString() : (object instanceof Number || object instanceof Date ? ((painter = Grid.this.getColumnPainter(n)) instanceof FormatPainter ? ((FormatPainter)painter).getFormat().format(object) : object.toString()) : (object instanceof ImageIcon ? ((ImageIcon)object).getDescription() : (object instanceof Image || object instanceof ImageSet || object instanceof Icon ? this.getTranslatedString(Grid._IMAGE) : this.getTranslatedString(Grid._UNKNOWN))))));
            if (abstractBigCell != null) {
                int n3 = abstractBigCell.getColumnCount();
                int n4 = abstractBigCell.getRowCount();
                if (string == null) {
                    string = "";
                }
                String string2 = this._getBigCellKey(n3, n4);
                String string3 = this.getTranslatedString(string2);
                MessageFormat messageFormat = new MessageFormat(string3);
                Object[] objectArray = new Object[]{string, IntegerUtils.getString((int)n3), IntegerUtils.getString((int)n4)};
                string = messageFormat.format(objectArray);
            }
            return this.getAccessibleNameForTable(n, n2, object, string);
        }

        protected String getAccessibleNameForTable(int n, int n2, Object object, String string) {
            Accessible accessible = ((Component.AccessibleAWTComponent)this).getAccessibleParent();
            if (accessible == null) {
                return string;
            }
            AccessibleContext accessibleContext = accessible.getAccessibleContext();
            if (accessibleContext.getAccessibleRole() != AccessibleRole.TABLE) {
                return string;
            }
            String string2 = this._getHeaderName(accessibleContext, AccessibleRole.COLUMN_HEADER, n);
            String string3 = this._getHeaderName(accessibleContext, AccessibleRole.ROW_HEADER, n2);
            String string4 = null;
            if (string == null) {
                if (string2 != null && string3 != null) {
                    String string5 = this.getTranslatedString(Grid._NULL_CELL_BOTH);
                    MessageFormat messageFormat = new MessageFormat(string5);
                    Object[] objectArray = new Object[]{string2, string3};
                    string4 = messageFormat.format(objectArray);
                } else if (string2 != null) {
                    String string6 = this.getTranslatedString(Grid._NULL_CELL_COLUMN);
                    MessageFormat messageFormat = new MessageFormat(string6);
                    Object[] objectArray = new Object[]{string2};
                    string4 = messageFormat.format(objectArray);
                } else if (string3 != null) {
                    String string7 = this.getTranslatedString(Grid._NULL_CELL_ROW);
                    MessageFormat messageFormat = new MessageFormat(string7);
                    Object[] objectArray = new Object[]{string3};
                    string4 = messageFormat.format(objectArray);
                }
            } else if (string2 != null && string3 != null) {
                String string8 = this.getTranslatedString(Grid._FULL_CELL_NAME);
                MessageFormat messageFormat = new MessageFormat(string8);
                Object[] objectArray = new Object[]{string2, string3, string};
                string4 = messageFormat.format(objectArray);
            } else if (string2 != null) {
                String string9 = this.getTranslatedString(Grid._COLUMNONLY_CELL_NAME);
                MessageFormat messageFormat = new MessageFormat(string9);
                Object[] objectArray = new Object[]{string2, string};
                string4 = messageFormat.format(objectArray);
            } else if (string3 != null) {
                String string10 = this.getTranslatedString(Grid._ROWONLY_CELL_NAME);
                MessageFormat messageFormat = new MessageFormat(string10);
                Object[] objectArray = new Object[]{string3, string};
                string4 = messageFormat.format(objectArray);
            } else {
                string4 = string;
            }
            return string4;
        }

        protected String getTranslatedString(String string) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(Grid._RESOURCE, ((Component.AccessibleAWTComponent)this).getLocale());
            return resourceBundle.getString(string);
        }

        private String _getHeaderName(AccessibleContext accessibleContext, AccessibleRole accessibleRole, int n) {
            int n2 = accessibleContext.getAccessibleChildrenCount();
            int n3 = 0;
            while (n3 < n2) {
                AccessibleContext accessibleContext2;
                Accessible accessible = accessibleContext.getAccessibleChild(n3);
                if (accessible != null && (accessibleContext2 = accessible.getAccessibleContext()).getAccessibleRole() == accessibleRole) {
                    accessible = accessibleContext2.getAccessibleChild(n);
                    return accessible.getAccessibleContext().getAccessibleName();
                }
                ++n3;
            }
            return null;
        }

        private String _getBigCellKey(int n, int n2) {
            if (n > 1) {
                if (n2 > 1) {
                    return Grid._SPANMM;
                }
                return Grid._SPANMS;
            }
            if (n2 > 1) {
                return Grid._SPANSM;
            }
            return Grid._SPANSS;
        }

        public class AccessibleGridCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private int _position;

            public AccessibleGridCell(int n) {
                this._position = n;
                this.setAccessibleParent(Grid.this);
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public String getAccessibleName() {
                String string;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && (string = accessibleContext.getAccessibleName()) != null && string != "") {
                    return accessibleContext.getAccessibleName();
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                if (n != -1 && n2 != -1) {
                    return AccessibleGrid.this.getAccessibleName(n2, n);
                }
                return null;
            }

            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                } else {
                    super.setAccessibleName(string);
                }
            }

            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                if (this.accessibleDescription != null && this.accessibleDescription != "") {
                    return this.accessibleDescription;
                }
                int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                if (n != -1 && n2 != -1) {
                    return AccessibleGrid.this.getAccessibleDescription(n2, n);
                }
                return null;
            }

            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                } else {
                    super.setAccessibleDescription(string);
                }
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return AccessibleRole.LABEL;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                AccessibleStateSet accessibleStateSet = null;
                if (accessibleContext != null) {
                    accessibleStateSet = accessibleContext.getAccessibleStateSet();
                }
                if (accessibleStateSet == null) {
                    accessibleStateSet = new AccessibleStateSet();
                }
                int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                Rectangle rectangle = null;
                Cell cell = null;
                if (n != -1 && n2 != -1) {
                    Object object;
                    rectangle = Grid.this._getCellRect(n2, n);
                    cell = new Cell(n2, n);
                    Object object2 = Grid.this.getModel().getData(n2, n);
                    if (object2 instanceof HDataObject && (object = (HDataObject)object2).hasChildren()) {
                        accessibleStateSet.add(AccessibleState.EXPANDABLE);
                        if (object.isExpanded()) {
                            accessibleStateSet.add(AccessibleState.EXPANDED);
                        } else {
                            accessibleStateSet.add(AccessibleState.COLLAPSED);
                        }
                    }
                    if ((object = Grid.this.getFocusCell()) != null && n == ((Cell)object).row && n2 == ((Cell)object).column) {
                        accessibleStateSet.add(AccessibleState.FOCUSED);
                    }
                }
                if (rectangle != null) {
                    accessibleStateSet.add(AccessibleState.VISIBLE);
                    if (this.isShowing()) {
                        accessibleStateSet.add(AccessibleState.SHOWING);
                    } else {
                        accessibleStateSet.remove(AccessibleState.SHOWING);
                    }
                } else {
                    accessibleStateSet.remove(AccessibleState.VISIBLE);
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
                accessibleStateSet.add(AccessibleState.SELECTABLE);
                accessibleStateSet.add(AccessibleState.EDITABLE);
                if (Grid.this.isEnabled()) {
                    accessibleStateSet.add(AccessibleState.ENABLED);
                }
                if (cell != null && Grid.this.getSelection().containsCell(cell)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                } else if (accessibleStateSet.contains(AccessibleState.SELECTED)) {
                    accessibleStateSet.remove(AccessibleState.SELECTED);
                }
                accessibleStateSet.add(AccessibleState.FOCUSABLE);
                accessibleStateSet.add(AccessibleState.TRANSIENT);
                return accessibleStateSet;
            }

            public Accessible getAccessibleParent() {
                return Grid.this;
            }

            public int getAccessibleIndexInParent() {
                return this._position;
            }

            public int getAccessibleChildrenCount() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleChildrenCount();
                }
                return 0;
            }

            public Accessible getAccessibleChild(int n) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    Accessible accessible = accessibleContext.getAccessibleChild(n);
                    accessibleContext.setAccessibleParent(this);
                    return accessible;
                }
                return null;
            }

            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return Grid.this.getLocale();
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                } else {
                    super.addPropertyChangeListener(propertyChangeListener);
                }
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                } else {
                    super.removePropertyChangeListener(propertyChangeListener);
                }
            }

            public AccessibleAction getAccessibleAction() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleAction();
                }
                return null;
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleSelection getAccessibleSelection() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleSelection();
                }
                return null;
            }

            public AccessibleText getAccessibleText() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleText();
                }
                return null;
            }

            public AccessibleValue getAccessibleValue() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleValue();
                }
                return null;
            }

            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                AppearanceManager appearanceManager = Grid.this.getAppearanceManager();
                if (appearanceManager != null) {
                    Color color;
                    int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                    int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                    Appearance appearance = null;
                    if (n != -1 && n2 != -1) {
                        appearance = appearanceManager.getCellPaintingAppearance(n2, n);
                    }
                    if (appearance != null && (color = appearance.getBackground()) != null) {
                        return color;
                    }
                }
                return Grid.this.getBackground();
            }

            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBackground(color);
                    }
                }
            }

            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                AppearanceManager appearanceManager = Grid.this.getAppearanceManager();
                if (appearanceManager != null) {
                    Color color;
                    int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                    int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                    Appearance appearance = null;
                    if (n != -1 && n2 != -1) {
                        appearance = appearanceManager.getCellPaintingAppearance(n2, n);
                    }
                    if (appearance != null && (color = appearance.getForeground()) != null) {
                        return color;
                    }
                }
                return Grid.this.getForeground();
            }

            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setForeground(color);
                    }
                }
            }

            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return Grid.this.getCursor();
            }

            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setCursor(cursor);
                    }
                }
            }

            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                AppearanceManager appearanceManager = Grid.this.getAppearanceManager();
                if (appearanceManager != null) {
                    Font font;
                    int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                    int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                    Appearance appearance = null;
                    if (n != -1 && n2 != -1) {
                        appearance = appearanceManager.getCellPaintingAppearance(n2, n);
                    }
                    if (appearance != null && (font = appearance.getFont()) != null) {
                        return font;
                    }
                }
                return Grid.this.getFont();
            }

            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setFont(font);
                    }
                }
            }

            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return ((Component)Grid.this).getFontMetrics(font);
            }

            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return Grid.this.isEnabled();
            }

            public void setEnabled(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setEnabled(bl);
                    }
                }
            }

            public boolean isVisible() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isVisible();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isVisible();
                }
                int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                Rectangle rectangle = null;
                if (n != -1 && n2 != -1) {
                    rectangle = Grid.this._getCellRect(n2, n);
                }
                return rectangle != null;
            }

            public void setVisible(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setVisible(bl);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setVisible(bl);
                    }
                }
            }

            public boolean isShowing() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isShowing();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isShowing();
                }
                return Grid.this.isShowing();
            }

            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            public Point getLocationOnScreen() {
                if (Grid.this != null) {
                    Point point = Grid.this.getLocationOnScreen();
                    Point point2 = this.getLocation();
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }

            public Point getLocation() {
                if (Grid.this != null) {
                    int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                    int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                    Rectangle rectangle = null;
                    if (n != -1 && n2 != -1) {
                        rectangle = Grid.this._getCellRect(n2, n);
                    }
                    if (rectangle != null) {
                        return rectangle.getLocation();
                    }
                }
                return null;
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                if (Grid.this != null && n != -1 && n2 != -1) {
                    return new Rectangle(Grid.this.getColumnPosition(n2), Grid.this.getRowPosition(n), Grid.this.getColumnWidth(n2), Grid.this.getRowHeight(n));
                }
                return null;
            }

            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBounds(rectangle);
                    }
                }
            }

            public Dimension getSize() {
                int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                if (Grid.this != null && n != -1 && n2 != -1) {
                    return new Dimension(Grid.this.getColumnWidth(n2), Grid.this.getRowHeight(n));
                }
                return null;
            }

            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setSize(dimension);
                    }
                }
            }

            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.addFocusListener(focusListener);
                    }
                }
            }

            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.removeFocusListener(focusListener);
                    }
                }
            }

            protected int getPosition() {
                return this._position;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Component component = this.getCurrentComponent();
                if (component != null && component instanceof Accessible) {
                    return ((Accessible)((Object)component)).getAccessibleContext();
                }
                return null;
            }

            private Component getCurrentComponent() {
                int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                Cell cell = Grid.this.getFocusCell();
                if (n != -1 && n2 != -1 && Grid.this.isEditing() && n == cell.row && n2 == cell.column) {
                    return Grid.this._editControl;
                }
                return null;
            }
        }
    }
}

