/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.selection.Cell;

public class DateInputHandler
extends CellInputHandler {
    private DateEditor _DateEditor;
    static boolean _dirty;
    private DateFormat _format;

    public DateInputHandler(DateFormat dateFormat) {
        this._format = dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this._format = dateFormat;
    }

    public DateFormat getDateFormat() {
        return this._format;
    }

    public void updateUI() {
        if (this._DateEditor != null) {
            SwingUtilities.updateComponentTreeUI(this._DateEditor);
            this._DateEditor.setBorder(null);
        }
    }

    public void focusGained(AWTEvent aWTEvent, Grid grid, int n, int n2) {
        if (aWTEvent instanceof MouseEvent) {
            grid.startCellEdit(n, n2);
        }
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        super.mousePressed(mouseEvent, grid, n, n2);
        Cell cell = grid.getFocusCell();
        if (cell != null && cell.column == n && cell.row == n2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            grid.startCellEdit(n, n2);
        }
    }

    public synchronized Component getEditControl(Grid grid, int n, int n2) {
        if (this._DateEditor == null) {
            this._DateEditor = new DateEditor();
            this._DateEditor.addPropertyChangeListener(new Dirty());
            this._DateEditor.setBorder(null);
        }
        return this._DateEditor;
    }

    public boolean isDirty(Grid grid, int n, int n2) {
        return _dirty;
    }

    public void startEdit(Grid grid, int n, int n2, Object object) {
        DateEditor dateEditor = (DateEditor)this.getEditControl(grid, n, n2);
        dateEditor.setCalendar(this.getDateFormat().getCalendar());
        if (object == null || object instanceof Date) {
            dateEditor.setDate((Date)object);
        } else {
            String string = object.toString();
            try {
                dateEditor.setDateString(string);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException("data " + object + " must be a Date");
            }
        }
        dateEditor.setDateFormat(this.getDateFormat());
        _dirty = false;
    }

    public synchronized Object commitEdit(Grid grid, int n, int n2) {
        DateEditor dateEditor = (DateEditor)this.getEditControl(grid, n, n2);
        Date date = dateEditor.getDate();
        return date;
    }

    private static class Dirty
    implements PropertyChangeListener {
        private Dirty() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("date".equals(propertyChangeEvent.getPropertyName())) {
                _dirty = true;
            }
        }
    }
}

