/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.geometry;

import java.util.Random;
import oracle.bali.ewt.geometry.AbstractWrappingGeometryManager;
import oracle.bali.ewt.geometry.GeometryEvent;
import oracle.bali.ewt.geometry.GeometryListener;
import oracle.bali.ewt.geometry.GeometryManager;

public class FixedSizeGeometryManager
extends AbstractWrappingGeometryManager {
    public static final int RESIZE_REMAINING = 0;
    public static final int RESIZE_NEXT = 1;
    private int _method;
    private float[] _cachedMinProportions;
    private float[] _cachedMaxProportions;

    public FixedSizeGeometryManager(GeometryManager geometryManager) {
        this(geometryManager, 0);
    }

    public FixedSizeGeometryManager(GeometryManager geometryManager, int n) {
        super(geometryManager);
        this._method = n;
    }

    protected GeometryListener createGeometryListener() {
        return new ListenerAdapter();
    }

    public void setTotalSize(int n) {
        int n2 = this.getTotalSize();
        this._cachedMinProportions = this._cacheMinProportions(0);
        this._cachedMaxProportions = this._cacheMaxProportions(0);
        int n3 = this._resize(-1, n);
        this._cachedMinProportions = null;
        this._cachedMaxProportions = null;
        this.fireGeometryEvent(2002, -1, this.getTotalSize());
    }

    public void setItemSize(int n, int n2) {
        int n3;
        int n4 = this.getMinimumItemSize(n);
        if (n2 < n4) {
            n2 = n4;
        }
        if (n2 > (n3 = this.getMaximumItemSize(n))) {
            n2 = n3;
        }
        int n5 = this.getItemVisibleIndex(n);
        if (this._method == 1 && n5 + 1 < this.getVisibleItemCount()) {
            int n6 = this.getItemSize(n);
            int n7 = this.visibleIndexToIndex(n5 + 1);
            int n8 = this.getItemSize(n7);
            int n9 = n6 + n8;
            super.setItemSize(n7, n9 - n2);
            n8 = this.getItemSize(n7);
            super.setItemSize(n, n9 - n8);
        } else {
            if (this._cachedMinProportions == null) {
                this._cachedMinProportions = this._cacheMinProportions(n5 + 1);
            }
            if (this._cachedMaxProportions == null) {
                this._cachedMaxProportions = this._cacheMaxProportions(n5 + 1);
            }
            int n10 = this.getTotalSize() - this.getItemPosition(n) - n2 - this.getSeparatorSize();
            super.setItemSize(n, n2 -= this._resize(n5, n10));
            if (!this.isResizing()) {
                this._cachedMinProportions = null;
                this._cachedMaxProportions = null;
            }
        }
        this.fireGeometryEvent(2005, n, this.getItemSize(n));
    }

    private float[] _cacheMinProportions(int n) {
        int n2;
        int n3 = this.getVisibleItemCount();
        float[] fArray = new float[n3];
        int n4 = 0;
        int n5 = n;
        while (n5 < n3) {
            n2 = this.visibleIndexToIndex(n5);
            if (this.isItemResizable(n2)) {
                n4 += this.getItemSize(n2) - this.getMinimumItemSize(n2);
            }
            ++n5;
        }
        if (n4 != 0) {
            n5 = n;
            while (n5 < n3) {
                n2 = this.visibleIndexToIndex(n5);
                if (this.isItemResizable(n2)) {
                    fArray[n5] = (float)(this.getItemSize(n2) - this.getMinimumItemSize(n2)) / (float)n4;
                }
                ++n5;
            }
        }
        return fArray;
    }

    private float[] _cacheMaxProportions(int n) {
        int n2;
        int n3 = this.getVisibleItemCount();
        float[] fArray = new float[n3];
        long l = 0L;
        int n4 = n;
        while (n4 < n3) {
            n2 = this.visibleIndexToIndex(n4);
            if (this.isItemResizable(n2)) {
                l += (long)(this.getMaximumItemSize(n2) - this.getItemSize(n2));
            }
            ++n4;
        }
        if (l != 0L) {
            n4 = n;
            while (n4 < n3) {
                n2 = this.visibleIndexToIndex(n4);
                if (this.isItemResizable(n2)) {
                    fArray[n4] = (float)(this.getMaximumItemSize(n2) - this.getItemSize(n2)) / (float)l;
                }
                ++n4;
            }
        }
        return fArray;
    }

    private int _resize(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = this.getVisibleItemCount();
        int n7 = n + 1;
        while (n7 < n6) {
            n4 = this.visibleIndexToIndex(n7);
            int n8 = this.getItemSize(n4);
            n5 += n8;
            ++n7;
        }
        if ((n5 += this.getSeparatorSize() * (n6 - (n + 1))) > n2) {
            int n9;
            int n10;
            n3 = n10 = n5 - n2;
            do {
                n10 = n3;
                n9 = 0;
                n7 = n + 1;
                while (n7 < n6) {
                    n4 = this.visibleIndexToIndex(n7);
                    if (this.isItemResizable(n4)) {
                        int n11 = this.getItemSize(n4);
                        float f = (float)n10 * this._cachedMinProportions[n7];
                        int n12 = n11 - (int)f;
                        super.setItemSize(n4, n12);
                    }
                    n9 += this.getItemSize(n4) + this.getSeparatorSize();
                    ++n7;
                }
            } while ((n3 = n9 - n2) != n10);
            n3 = this.distributePixels(n3, n + 1, -1);
        } else if (n5 < n2) {
            int n13;
            int n14 = n2 - n5;
            n3 = -n14;
            do {
                n13 = 0;
                n14 = -n3;
                n7 = n + 1;
                while (n7 < n6) {
                    n4 = this.visibleIndexToIndex(n7);
                    if (this.isItemResizable(n4)) {
                        int n15 = this.getItemSize(n4);
                        int n16 = n15 + (int)((float)n14 * this._cachedMaxProportions[n7]);
                        super.setItemSize(n4, n16);
                    }
                    n13 += this.getItemSize(n4) + this.getSeparatorSize();
                    ++n7;
                }
            } while (-(n3 = n13 - n2) != n14);
            n3 = this.distributePixels(n3, n + 1, 1);
        } else {
            n3 = 0;
        }
        return n3;
    }

    private int distributePixels(int n, int n2, int n3) {
        if (n == 0) {
            return 0;
        }
        int n4 = this.getVisibleItemCount();
        int n5 = n4 - n2;
        Random random = new Random();
        boolean bl = true;
        while (bl && n != 0) {
            int n6;
            int n7;
            bl = false;
            int n8 = random.nextInt(n5);
            int n9 = n2 + n8;
            while (n9 < n4 && n != 0) {
                n7 = this.visibleIndexToIndex(n9);
                if (this.isItemResizable(n7)) {
                    n6 = this.getItemSize(n7);
                    super.setItemSize(n7, n6 + 1 * n3);
                    if (this.getItemSize(n7) != n6) {
                        n += 1 * n3;
                        bl = true;
                    }
                }
                ++n9;
            }
            n6 = n2;
            while (n6 < n2 + n8 && n != 0) {
                n7 = this.visibleIndexToIndex(n6);
                if (this.isItemResizable(n7)) {
                    int n10 = this.getItemSize(n7);
                    super.setItemSize(n7, n10 + 1 * n3);
                    if (this.getItemSize(n7) != n10) {
                        n += 1 * n3;
                        bl = true;
                    }
                }
                ++n6;
            }
        }
        return n;
    }

    private class ListenerAdapter
    implements GeometryListener {
        private ListenerAdapter() {
        }

        public void geometryChanged(GeometryEvent geometryEvent) {
            int n = geometryEvent.getID();
            if (n == 2002 || n == 2005 || n == 2006 || n == 2007) {
                return;
            }
            FixedSizeGeometryManager.this.fireGeometryEvent(n, geometryEvent.getItem(), geometryEvent.getSize());
        }
    }
}

