/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.geometry;

import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.bali.ewt.geometry.GeometryEvent;
import oracle.bali.ewt.geometry.GeometryListener;
import oracle.bali.ewt.geometry.GeometryManager;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.bali.share.collection.Range;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.sort.Sort;

public abstract class AbstractGeometryManager
implements GeometryManager {
    private GeometryChangeListener _listener;
    private ListenerManager _manager;
    private boolean _resizing;

    protected AbstractGeometryManager() {
    }

    public void setResizing(boolean bl) {
        this._resizing = bl;
    }

    public boolean isResizing() {
        return this._resizing;
    }

    public OneDModelListener getOneDModelListener() {
        if (this._listener == null) {
            this._listener = new GeometryChangeListener();
        }
        return this._listener;
    }

    protected void itemsAdded(int n, int n2) {
    }

    protected void itemsRemoved(int n, int n2) {
    }

    public abstract void resetAll(int var1);

    public abstract int getItemPosition(int var1);

    public abstract int getItemAt(int var1);

    public abstract void setTotalSize(int var1);

    public abstract int getTotalSize();

    public abstract void setItemVisible(int var1, boolean var2);

    public abstract boolean isItemVisible(int var1);

    public abstract void setItemVisibleIndex(int var1, int var2);

    public abstract void setItemSize(int var1, int var2);

    public abstract int getItemSize(int var1);

    public abstract int getSeparatorSize();

    public abstract void setSeparatorSize(int var1);

    public abstract int getItemCount();

    public abstract int getVisibleItemCount();

    public abstract int getItemVisibleIndex(int var1);

    public abstract int visibleIndexToIndex(int var1);

    public Range[] visibleRangesToRanges(Range[] rangeArray) {
        return this._transform(rangeArray, true);
    }

    public Range[] rangesToVisibleRanges(Range[] rangeArray) {
        return this._transform(rangeArray, false);
    }

    public abstract void setDefaultItemSize(int var1);

    public abstract int getDefaultItemSize();

    public abstract boolean isItemResizable(int var1);

    public abstract int getMinimumItemSize(int var1);

    public abstract int getMaximumItemSize(int var1);

    private int _transformIndex(int n, boolean bl) {
        if (bl) {
            return this.visibleIndexToIndex(n);
        }
        return this.getItemVisibleIndex(n);
    }

    private Range[] _transform(Range[] rangeArray, boolean bl) {
        int[] nArray;
        if (rangeArray.length == 1 && rangeArray[0].getLowerLimit() == rangeArray[0].getUpperLimit()) {
            int n = this._transformIndex(rangeArray[0].getLowerLimit(), bl);
            return new Range[]{new Range(n, n)};
        }
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        int n2 = 0;
        while (n2 < rangeArray.length) {
            nArray = this._transformRange(rangeArray[n2], bl);
            vector.addElement(nArray);
            n += nArray.length;
            ++n2;
        }
        nArray = new int[n];
        n = 0;
        n2 = 0;
        while (n2 < vector.size()) {
            int[] nArray2 = (int[])vector.elementAt(n2);
            System.arraycopy(nArray2, 0, nArray, n, nArray2.length);
            n += nArray2.length;
            ++n2;
        }
        Sort.qSort((int[])nArray, (int)nArray.length, (boolean)true);
        vector = new Vector();
        int n3 = -1;
        int n4 = -1;
        n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] >= 0) {
                if (n3 == -1 && n4 == -1) {
                    n3 = nArray[n2];
                    n4 = nArray[n2];
                } else if (nArray[n2] == n4 + 1) {
                    n4 = nArray[n2];
                } else {
                    vector.addElement(new Range(n3, n4));
                    n3 = nArray[n2];
                    n4 = nArray[n2];
                }
            }
            ++n2;
        }
        if (n3 != -1 && n4 != -1) {
            vector.addElement(new Range(n3, n4));
        }
        Object[] objectArray = new Range[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private int[] _transformRange(Range range, boolean bl) {
        int n = range.getLowerLimit();
        int n2 = range.getUpperLimit();
        int n3 = n2 - n + 1;
        int[] nArray = new int[n3];
        int n4 = n;
        while (n4 <= n2) {
            nArray[n4 - n] = this._transformIndex(n4, bl);
            ++n4;
        }
        return nArray;
    }

    public void addGeometryListener(GeometryListener geometryListener) {
        if (this._manager == null) {
            this._manager = new ListenerManager();
        }
        this._manager.addListener((EventListener)geometryListener);
    }

    public void removeGeometryListener(GeometryListener geometryListener) {
        if (this._manager != null) {
            this._manager.removeListener((EventListener)geometryListener);
        }
    }

    protected void fireGeometryEvent(int n, int n2, int n3) {
        if (this._manager == null) {
            return;
        }
        Enumeration enumeration = this._manager.getListeners();
        if (enumeration == null) {
            return;
        }
        GeometryEvent geometryEvent = new GeometryEvent(this, n, n2, n3);
        while (enumeration.hasMoreElements()) {
            GeometryListener geometryListener = (GeometryListener)enumeration.nextElement();
            geometryListener.geometryChanged(geometryEvent);
        }
    }

    private class GeometryChangeListener
    implements OneDModelListener {
        private GeometryChangeListener() {
        }

        public void invalidateItems(OneDModelEvent oneDModelEvent) {
        }

        public void itemsAdded(OneDModelEvent oneDModelEvent) {
            AbstractGeometryManager.this.itemsAdded(oneDModelEvent.getStartIndex(), oneDModelEvent.getItemCount());
        }

        public void itemsRemoved(OneDModelEvent oneDModelEvent) {
            AbstractGeometryManager.this.itemsRemoved(oneDModelEvent.getStartIndex(), oneDModelEvent.getItemCount());
        }
    }
}

