/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.util.ImmInsets;

class WindowsPivotCornerPainter
extends AbstractBorderPainter
implements UIResource {
    public static final int UPPER_LEFT = 3;
    public static final int UPPER_RIGHT = 1;
    public static final int LOWER_RIGHT = 2;
    public static final int LOWER_LEFT = 0;
    private static final ImmInsets _INSETS = new ImmInsets(1, 1, 1, 1);
    private static Painter[] _sCornerPainters = new Painter[4];
    private int _corner;

    public WindowsPivotCornerPainter() {
        this(3);
    }

    public WindowsPivotCornerPainter(int n) {
        this._corner = n;
    }

    public static Painter getPainter(int n) {
        Painter painter = null;
        if (n >= 0 && n <= 3) {
            painter = _sCornerPainters[n];
            if (painter == null) {
                painter = new WindowsPivotCornerPainter(n);
            }
            WindowsPivotCornerPainter._sCornerPainters[n] = painter;
        }
        if (painter == null) {
            painter = NullPainter.getPainter();
        }
        return painter;
    }

    protected ImmInsets getOwnInsets(PaintContext paintContext) {
        return _INSETS;
    }

    protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = paintContext.getPaintState();
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        Color color = graphics.getColor();
        Object object = paintContext.getPaintData(PivotTable.KEY_DRAW_RAISED);
        boolean bl = object instanceof Boolean ? (Boolean)object : true;
        Color color2 = paintContext.getPaintBackground();
        graphics.setColor(color2);
        graphics.fillRect(n, n2, n3, n4);
        int n6 = n2 + n4 - 1;
        int n7 = n + n3 - 1;
        Color color3 = null;
        if (this._corner == 3 && (n5 & 1) == 0 && (object = paintContext.getPaintData(PivotTable.KEY_CORNER_BORDER_COLOR)) instanceof Color) {
            color3 = (Color)object;
        }
        if (color3 == null) {
            color3 = !bl ? uIDefaults.getColor(LookAndFeel.CONTROL_SHADOW) : uIDefaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
        }
        graphics.setColor(color3);
        graphics.drawLine(n, n6, n7, n6);
        graphics.drawLine(n7, n2, n7, n6);
        graphics.setColor(color);
    }

    protected boolean isBorderTransparent(PaintContext paintContext) {
        return false;
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return super.getRepaintFlags(paintContext) | 0x80;
    }
}

