/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.drawer.Drawer;
import oracle.bali.ewt.elaf.EWTDrawerUI;
import oracle.bali.ewt.elaf.basic.BasicUIUtils;
import oracle.bali.ewt.elaf.basic.DrawerBorderPainter;
import oracle.bali.ewt.elaf.basic.WhiteFilter;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleButtonPainter;
import oracle.bali.ewt.olaf.OracleButtonUI;
import oracle.bali.ewt.olaf.PainterButton;
import oracle.bali.ewt.painter.AndOrStatePainterSwitcher;
import oracle.bali.ewt.painter.FilledRectPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.FixedColorPainter;
import oracle.bali.ewt.painter.FixedImagePainter;
import oracle.bali.ewt.painter.InnerEdgeBorderPainterJoiner;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterStacker;
import oracle.bali.ewt.plaf.BorderAdapter;

public class OracleEWTDrawerUI
extends OracleButtonUI
implements EWTDrawerUI {
    private static Border[] _sBorders = new Border[8];
    private static final OracleEWTDrawerUI _sInstance = new OracleEWTDrawerUI();
    private static Painter[] _sArrowPainters = new Painter[4];

    public static ComponentUI createUI(JComponent jComponent) {
        return _sInstance;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        Border border = jComponent.getBorder();
        if (border == null || border instanceof UIResource) {
            jComponent.setBorder(this.getBorder(jComponent));
        }
    }

    public Border getDrawerBorder(JComponent jComponent) {
        int n = OracleEWTDrawerUI.getOrientation(jComponent);
        return DrawerBorderPainter.getDrawerBorder(n);
    }

    public Painter getPainter(JComponent jComponent) {
        return this.getPainter(jComponent, false);
    }

    public JButton getPopUpArrowButton(JComponent jComponent) {
        int n = (OracleEWTDrawerUI.getOrientation(jComponent) + 1) % 4 + 1;
        PainterButton painterButton = new PainterButton(OracleEWTDrawerUI.getArrowPainter(n));
        painterButton.setFocusable(false);
        return painterButton;
    }

    public int getPopUpOverlap(JComponent jComponent) {
        Painter painter = OracleEWTDrawerUI.getArrowPainter(4);
        PaintContext paintContext = JPaintContext.getPaintContext(jComponent);
        if (paintContext == null) {
            return 1;
        }
        return painter.getPreferredSize((PaintContext)paintContext).width + 1;
    }

    public int getPerpendicularInsets(JComponent jComponent) {
        return 1;
    }

    public static Painter getArrowPainter(int n) {
        Painter painter = _sArrowPainters[n - 1];
        if (painter == null) {
            Image image = BasicUIUtils.getArrow(n);
            image = ImageUtils.createFilteredImage(image, new WhiteFilter());
            OracleEWTDrawerUI._sArrowPainters[n - 1] = painter = new PainterStacker(new FixedColorPainter(FilledRectPainter.getPainter(), ColorScheme.NORMAL_INTENSITY), new FixedImagePainter(image, 0));
        }
        return painter;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.fillBackground(graphics, jComponent);
        this.paint(graphics, jComponent);
    }

    public Border getBorder(JComponent jComponent) {
        Border border;
        int n = OracleEWTDrawerUI.getOrientation(jComponent);
        boolean bl = jComponent.getParent() instanceof JToolBar;
        int n2 = n - 1;
        if (bl) {
            n2 += 4;
        }
        if ((border = _sBorders[n2]) == null) {
            int n3;
            Painter painter = OracleEWTDrawerUI.getArrowPainter(n);
            switch (n) {
                case 2: {
                    n3 = 3;
                    break;
                }
                case 4: {
                    n3 = 0;
                    break;
                }
                case 3: {
                    n3 = 2;
                    break;
                }
                default: {
                    n3 = 1;
                }
            }
            InnerEdgeBorderPainterJoiner innerEdgeBorderPainterJoiner = new InnerEdgeBorderPainterJoiner(new FixedBorderPainter(0, 2, 0, 2), new OracleButtonPainter(null, true, false, bl), new AndOrStatePainterSwitcher(new FixedBorderPainter(painter, -1, 0, 1, 0), painter, 2, 2, 0, 0), n3);
            border = OracleEWTDrawerUI._sBorders[n2] = new BorderAdapter(innerEdgeBorderPainterJoiner);
        }
        return border;
    }

    protected static int getOrientation(JComponent jComponent) {
        return ((Drawer)jComponent).getOrientation();
    }

    protected String getPropertyPrefix() {
        return "EWTDrawer.";
    }

    protected OracleEWTDrawerUI() {
    }
}

