/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dnd.impl;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragGestureListener;
import oracle.bali.ewt.dnd.DragGestureRecognizer;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DragSourceListener;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.dnd.impl.StaticListSelection;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.share.datatransfer.ObjectTransferable;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.bali.share.sort.Sort;

public abstract class ListDragger {
    private DropTarget _target;
    private int _sourceActions = 0;
    private boolean _reordering;
    private Adapter _adapter;
    private static boolean _sUsingImage;
    private static final DataFlavor _sStringFlavor;
    private static final DataFlavor _sArrayFlavor;
    private static final int _AUTOSCROLL_REGION = 8;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    protected ListDragger() {
        this(null);
    }

    protected ListDragger(JList jList) {
        this._adapter = new Adapter(jList);
        this._target = new DropTarget(jList, this._adapter);
        if (jList != null) {
            jList.updateUI();
        }
        if (jList == null) {
            this._target.setActive(true);
        }
        this.setReorderingAllowed(false);
        this.setTargetActions(0);
    }

    public JList getList() {
        return this._adapter.getList();
    }

    public void setList(JList jList) {
        this._adapter.setList(jList);
        this._target.setComponent(jList);
    }

    public void setActive(boolean bl) {
        this._target.setActive(bl);
    }

    public boolean isActive() {
        return this._target.isActive();
    }

    public void setTargetActions(int n) {
        this._target.setDefaultActions(n);
    }

    public int getTargetActions() {
        return this._target.getDefaultActions();
    }

    public void setSourceActions(int n) {
        this._sourceActions = n;
        this._updateSourceActions();
    }

    public int getSourceActions() {
        return this._sourceActions;
    }

    public void setReorderingAllowed(boolean bl) {
        this._reordering = bl;
        this._updateSourceActions();
    }

    public boolean isReorderingAllowed() {
        return this._reordering;
    }

    protected Image createDragImage(JList jList, int n) {
        return null;
    }

    protected abstract void addItems(Object[] var1, int var2);

    protected abstract void removeItems(int[] var1);

    protected abstract void reorderItems(int[] var1, int var2);

    protected Transferable createTransferable(JList jList) {
        int[] nArray = ListDragger._getSortedIndices(jList);
        String[] stringArray = new String[nArray.length];
        ListModel listModel = jList.getModel();
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = (String)listModel.getElementAt(nArray[n]);
            ++n;
        }
        return ObjectTransferable.createTransferable((Object)stringArray);
    }

    protected boolean isDragAcceptable(DropTargetDragEvent dropTargetDragEvent) {
        return dropTargetDragEvent.isDataFlavorSupported(_sArrayFlavor) || dropTargetDragEvent.isDataFlavorSupported(_sStringFlavor);
    }

    protected Object[] getDataFromDrop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        String[] stringArray = null;
        try {
            if (transferable.isDataFlavorSupported(_sArrayFlavor)) {
                stringArray = (String[])transferable.getTransferData(_sArrayFlavor);
            } else if (transferable.isDataFlavorSupported(_sStringFlavor)) {
                String string = (String)transferable.getTransferData(_sStringFlavor);
                stringArray = new String[]{string};
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    private void _updateSourceActions() {
        int n = this.getSourceActions();
        if (this.isReorderingAllowed()) {
            n |= 2;
        }
        this._adapter.setSourceActions(n);
    }

    private static int[] _getSortedIndices(JList jList) {
        int[] nArray = jList.getSelectedIndices();
        Sort.qSort((int[])nArray, (int)nArray.length, (boolean)true);
        return nArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _sStringFlavor = TransferUtils.getDataFlavor((Class)(class$java$lang$String == null ? (class$java$lang$String = ListDragger.class$("java.lang.String")) : class$java$lang$String));
        _sArrayFlavor = TransferUtils.getDataFlavor((Class)(array$Ljava$lang$String == null ? (array$Ljava$lang$String = ListDragger.class$("[Ljava.lang.String;")) : array$Ljava$lang$String));
    }

    private class Adapter
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        private JList _list;
        private DragGestureRecognizer _recognizer;
        private transient ListSelectionModel _savedSelection;
        private transient int _dropIndex;
        private transient boolean _canDrag;
        private transient boolean _inDrag;
        private transient boolean _inDrop;

        public Adapter(JList jList) {
            DragSource dragSource = DragSource.getDefaultDragSource();
            this._recognizer = dragSource.createDefaultDragGestureRecognizer(jList, 0, this);
            this._list = jList;
        }

        public JList getList() {
            return this._list;
        }

        public void setList(JList jList) {
            this._list = jList;
            this._recognizer.setComponent(jList);
        }

        public void setSourceActions(int n) {
            this._recognizer.setSourceActions(n);
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            JList jList = this._list;
            int n = jList.locationToIndex(dragGestureEvent.getDragOrigin());
            if (n >= 0 && jList.isSelectedIndex(n) && ListDragger.this.isActive()) {
                this._inDrag = true;
                this._savedSelection = jList.getSelectionModel();
                jList.setSelectionModel(new StaticListSelection(this._savedSelection));
                Transferable transferable = ListDragger.this.createTransferable(jList);
                Image image = ListDragger.this.createDragImage(jList, n);
                if (image == null || !ImageUtils.loadImage(image)) {
                    _sUsingImage = false;
                    dragGestureEvent.startDrag(null, transferable, this);
                } else {
                    _sUsingImage = true;
                    Point point = new Point(-image.getWidth(jList), -image.getHeight(jList));
                    dragGestureEvent.startDrag(null, image, point, transferable, this);
                }
            }
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (this._savedSelection != null) {
                this._list.setSelectionModel(this._savedSelection);
            }
            if (dragSourceDropEvent.getDropSuccess() && (ListDragger.this.getSourceActions() & 2) != 0 && dragSourceDropEvent.getDropAction() == 2) {
                int[] nArray = ListDragger._getSortedIndices(this._list);
                this._list.clearSelection();
                ListDragger.this.removeItems(nArray);
            }
            this._inDrag = false;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            this._inDrop = true;
            this._dropIndex = -1;
            this.dragOver(dropTargetDragEvent);
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            int n;
            int n2 = this._getDropAction(dropTargetDragEvent.getDropAction());
            if (n2 != 0 && !ListDragger.this.isDragAcceptable(dropTargetDragEvent)) {
                n2 = 0;
            }
            int n3 = this._dropIndex;
            if (n2 == 0) {
                dropTargetDragEvent.rejectDrag();
                n = -1;
            } else {
                dropTargetDragEvent.acceptDrag(n2);
                n = this._getDropIndex(dropTargetDragEvent.getLocation());
            }
            if (n3 != n) {
                this._eraseFeedback();
                this._dropIndex = n;
                this._drawFeedback();
            } else if (_sUsingImage) {
                this._drawFeedback();
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            this._eraseFeedback();
            this._inDrop = false;
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            boolean bl = false;
            this._eraseFeedback();
            int n = this._getDropAction(dropTargetDropEvent.getDropAction());
            if (n != 0) {
                JList jList = this._list;
                Object[] objectArray = ListDragger.this.getDataFromDrop(dropTargetDropEvent);
                if (objectArray != null && objectArray.length > 0) {
                    int n2 = this._getDropIndex(dropTargetDropEvent.getLocation());
                    int[] nArray = ListDragger._getSortedIndices(jList);
                    if (ListDragger.this.isReorderingAllowed() && this._inDrag) {
                        jList.setSelectionModel(this._savedSelection);
                        this._savedSelection = null;
                        if (nArray.length > 1 || n2 != nArray[0] && n2 != nArray[0] + 1) {
                            bl = true;
                            dropTargetDropEvent.acceptDrop(1);
                            jList.clearSelection();
                            int n3 = nArray.length - 1;
                            while (n3 >= 0) {
                                if (nArray[n3] < n2) {
                                    --n2;
                                }
                                --n3;
                            }
                            ListDragger.this.reorderItems(nArray, n2);
                        }
                    } else if (!this._inDrag) {
                        bl = true;
                        dropTargetDropEvent.acceptDrop(n);
                        jList.clearSelection();
                        ListDragger.this.addItems(objectArray, n2);
                    }
                }
            }
            if (!bl) {
                dropTargetDropEvent.rejectDrop();
            }
            dropTargetDropEvent.dropComplete(bl);
            this._inDrop = false;
        }

        private Rectangle _getFeedbackArea(int n) {
            Rectangle rectangle;
            int n2 = this._list.getModel().getSize();
            if (n2 == 0) {
                return new Rectangle(0, 0, this._list.getWidth(), 2);
            }
            if (n >= n2) {
                rectangle = this._list.getCellBounds(n2 - 1, n2 - 1);
                rectangle.y += rectangle.height - 1;
            } else {
                rectangle = this._list.getCellBounds(n, n);
            }
            rectangle.height = 2;
            return rectangle;
        }

        private void _eraseFeedback() {
            Rectangle rectangle;
            int n = this._dropIndex;
            if (n >= 0 && (rectangle = this._getFeedbackArea(n)) != null) {
                this._list.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        private void _drawFeedback() {
            Graphics graphics;
            int n = this._dropIndex;
            if (n >= 0 && (graphics = this._list.getGraphics()) != null) {
                try {
                    Rectangle rectangle = this._list.getVisibleRect();
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    Rectangle rectangle2 = this._getFeedbackArea(n);
                    graphics.setColor(Color.black);
                    graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    Object var6_5 = null;
                    graphics.dispose();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
        }

        private int _getDropIndex(Point point) {
            int n = this._list.getModel().getSize();
            int n2 = this._list.locationToIndex(point);
            if (n2 == -1 || n2 >= n) {
                n2 = n;
            } else {
                Rectangle rectangle = this._list.getCellBounds(n2, n2);
                if (point.y > rectangle.y + rectangle.height / 2) {
                    ++n2;
                }
            }
            return n2;
        }

        private int _getDropAction(int n) {
            int n2 = 0;
            if (ListDragger.this.isReorderingAllowed() && this._inDrag) {
                n2 = 2;
            } else if (!this._inDrag && (n2 = n) == 3) {
                n2 = 1;
            }
            return n2;
        }
    }
}

