/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.util.TooManyListenersException;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragGestureListener;
import oracle.bali.ewt.dnd.DragSource;

public abstract class DragGestureRecognizer {
    protected DragSource dragSource;
    protected Component component;
    protected DragGestureListener dragGestureListener;
    protected int sourceActions;
    private InputEvent _firstEvent;
    private InputEvent _lastEvent;

    protected DragGestureRecognizer(DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        if (dragSource == null) {
            throw new IllegalArgumentException("null DragSource");
        }
        this.dragSource = dragSource;
        this.component = component;
        this.sourceActions = n & 0x40000003;
        try {
            if (dragGestureListener != null) {
                this.addDragGestureListener(dragGestureListener);
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    protected DragGestureRecognizer(DragSource dragSource, Component component, int n) {
        this(dragSource, component, n, null);
    }

    protected DragGestureRecognizer(DragSource dragSource, Component component) {
        this(dragSource, component, 0);
    }

    protected DragGestureRecognizer(DragSource dragSource) {
        this(dragSource, null);
    }

    protected abstract void registerListeners();

    protected abstract void unregisterListeners();

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public synchronized Component getComponent() {
        return this.component;
    }

    public synchronized void setComponent(Component component) {
        if (this.component != null && this.dragGestureListener != null) {
            this.unregisterListeners();
        }
        this.component = component;
        if (this.component != null && this.dragGestureListener != null) {
            this.registerListeners();
        }
    }

    public synchronized int getSourceActions() {
        return this.sourceActions;
    }

    public synchronized void setSourceActions(int n) {
        this.sourceActions = n & 0x40000003;
    }

    public InputEvent getTriggerEvent() {
        return this._firstEvent;
    }

    public void resetRecognizer() {
        this._firstEvent = null;
        this._lastEvent = null;
    }

    public synchronized void addDragGestureListener(DragGestureListener dragGestureListener) throws TooManyListenersException {
        if (this.dragGestureListener != null) {
            throw new TooManyListenersException();
        }
        this.dragGestureListener = dragGestureListener;
        if (this.component != null) {
            this.registerListeners();
        }
    }

    public synchronized void removeDragGestureListener(DragGestureListener dragGestureListener) {
        if (this.dragGestureListener == null || !this.dragGestureListener.equals(dragGestureListener)) {
            throw new IllegalArgumentException();
        }
        this.dragGestureListener = null;
        if (this.component != null) {
            this.unregisterListeners();
        }
    }

    protected synchronized void fireDragGestureRecognized(int n, Point point) {
        if (this.dragGestureListener != null) {
            this.dragGestureListener.dragGestureRecognized(new DragGestureEvent(this, n, point, this._firstEvent, this._lastEvent));
        }
        this.resetRecognizer();
    }

    protected synchronized void appendEvent(InputEvent inputEvent) {
        if (this._firstEvent == null) {
            this._firstEvent = inputEvent;
        } else {
            this._lastEvent = inputEvent;
        }
    }
}

