/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dnd;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.JFCSupport;

class DnDUtils {
    private static final int _SOLARIS_OS = 1;
    private static final int _MAC_OS = 2;
    private static final int _WINDOWS_OS = 3;
    private static int _sOSVariant;

    DnDUtils() {
    }

    public static DropTarget getEWTDropTarget(Component component) {
        if (component instanceof JComponent) {
            return JFCSupport.getEWTDropTarget((JComponent)component);
        }
        return null;
    }

    public static void paintImmediate(Component component, int n, int n2, int n3, int n4) {
        if (component instanceof JComponent) {
            ((JComponent)component).paintImmediately(n, n2, n3, n4);
        } else if (component instanceof RootPaneContainer) {
            Container container;
            Container container2 = container = ((RootPaneContainer)((Object)component)).getContentPane();
            while (container2 != component) {
                Point point = container2.getLocation();
                n -= point.x;
                n2 -= point.y;
                container2 = container2.getParent();
            }
            DnDUtils.paintImmediate(container, n, n2, n3, n4);
        } else {
            Graphics graphics = component.getGraphics();
            try {
                graphics.clipRect(n, n2, n3, n4);
                component.update(graphics);
                Object var9_9 = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                graphics.dispose();
                throw throwable;
            }
        }
    }

    public static void setEWTDropTarget(Component component, DropTarget dropTarget) {
        if (component == null) {
            throw new NullPointerException();
        }
        if (!(component instanceof JComponent)) {
            throw new IllegalArgumentException("Illegal component type");
        }
        JFCSupport.setEWTDropTarget((JComponent)component, dropTarget);
    }

    public static Component getTopmostParent(Component component, Point point) {
        int n = point.x;
        int n2 = point.y;
        while (!(component instanceof Window) && component != null) {
            Container container;
            if (!JComponent.isLightweightComponent(component) || (container = component.getParent()) == null) break;
            Point point2 = component.getLocation();
            n += point2.x;
            n2 += point2.y;
            component = container;
        }
        point.x = n;
        point.y = n2;
        return component;
    }

    public static Component getTargetComponentOutside(Component component, Point point) {
        Component component2 = DnDUtils.getTopmostParent(component, point);
        return DnDUtils.getTargetComponent(component2, point);
    }

    public static Component getTargetComponent(Component component, Point point) {
        Object var2_2 = null;
        int n = point.x;
        int n2 = point.y;
        if (component instanceof Container) {
            Container container = (Container)component;
            Object object = container.getTreeLock();
            synchronized (object) {
                int n3 = container.getComponentCount();
                int n4 = 0;
                while (n4 < n3) {
                    Serializable serializable;
                    Component component2 = container.getComponent(n4);
                    if (!(!component2.isVisible() || component2 instanceof JPanel && (serializable = component2.getParent()) instanceof JRootPane && ((JRootPane)serializable).getGlassPane() == component2 || component2 == var2_2)) {
                        serializable = component2.getLocation();
                        int n5 = n - ((Point)serializable).x;
                        int n6 = n2 - ((Point)serializable).y;
                        if (component2.contains(n5, n6)) {
                            point.x = n5;
                            point.y = n6;
                            Component component3 = DnDUtils.getTargetComponent(component2, point);
                            return component3;
                        }
                    }
                    ++n4;
                }
            }
        }
        return component;
    }

    public static int getDefaultActions(int n) {
        int n2 = 3;
        switch (DnDUtils._getOS()) {
            case 1: 
            case 3: {
                if ((n & 2) == 0) break;
                n2 = 1;
                break;
            }
            case 2: {
                if ((n & 8) == 0) break;
                n2 = 1;
            }
        }
        return n2;
    }

    private static int _getOS() {
        int n = _sOSVariant;
        if (n == 0) {
            n = 3;
            String string = null;
            try {
                string = System.getProperty("os.name");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string != null) {
                if (string.startsWith("Solaris")) {
                    n = 1;
                } else if (string.startsWith("Mac")) {
                    n = 2;
                }
            }
            _sOSVariant = n;
        }
        return n;
    }
}

