/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dialog;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.PaintUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class JEWTDialog
extends JDialog {
    public static final int BUTTON_NONE = 0;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    public static final int BUTTON_HELP = 4;
    public static final int BUTTON_APPLY = 8;
    public static final int BUTTON_CLOSE = 16;
    public static final int BUTTON_DEFAULT = 7;
    public static final String PROPERTY_CLOSED = "closed";
    public static final String ACTION_APPLY = "apply";
    private static boolean _IS_LINUX;
    private static final Border _sOuterBorder;
    private static final Border _sInnerBorder;
    private static final Border _sButtonBorder;
    private static Border _sHeaderOuterBorder;
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_APPLY = "WIZARD.APPLY";
    private static final String _KEY_OK = "OK";
    private static final String _KEY_CANCEL = "CANCEL";
    private static final String _KEY_HELP = "HELP";
    private static final String _KEY_CLOSE = "JEWTDIALOG.CLOSE";
    private static final int _DEFAULT_CONTENT_GAP = 8;
    private int _buttonMask;
    private Vector _buttons = new Vector();
    private DialogButtonBar _bar;
    private GrayPane _pane;
    private StatusBarLabel _statusBarLabel;
    private JPanel _bottomPanel;
    private JPanel _mainContainer;
    private JPanel _contentContainer;
    private Component _header;
    private JButton _ok;
    private JButton _apply;
    private JButton _cancelClose;
    private JButton _help;
    private int _defaultButtonIndex;
    private boolean _cancelled;
    private UIListener _listener;
    private Component _centerOver;
    private PropertyChangeSupport _propertyChangeSupport;
    private VetoableChangeSupport _vetoableChangeSupport;
    private Component _initialFocus;
    private ListenerManager _actionListeners;
    private JButton _defaultButton;
    private int _prefWidth;
    private int _prefHeight;
    private Runnable _runnable;
    private int _minWidth = -1;
    private int _minHeight = -1;
    private int _initialWidth = 0;
    private int _initialHeight = 0;
    private int _dialogMaximumWidth = -1;
    private int _dialogMaximumHeight = -1;
    private boolean _isOKDefaulted = true;
    private boolean _isCancelDefaulted = true;
    private static final String _APPLY_NAME = "Apply_Button";
    private static final String _OK_NAME = "OK_Button";
    private static final String _CANCEL_NAME = "Cancel_Button";
    private static final String _HELP_NAME = "Help_Button";
    private static final String _CLOSE_NAME = "Close_Button";

    public static JEWTDialog createDialog(Component component, String string, int n) {
        JEWTDialog jEWTDialog = null;
        while (component != null) {
            if (component instanceof Dialog) {
                jEWTDialog = new JEWTDialog((Dialog)component, string, n);
                break;
            }
            if (component instanceof Frame) {
                jEWTDialog = new JEWTDialog((Frame)component, string, n);
                break;
            }
            component = SwingUtilities.getWindowAncestor(component);
        }
        if (jEWTDialog == null) {
            jEWTDialog = new JEWTDialog((Frame)null, string, n);
        }
        return jEWTDialog;
    }

    public JEWTDialog() {
        this((Frame)null);
    }

    public JEWTDialog(Frame frame) {
        this(frame, "JEWTDialog");
    }

    public JEWTDialog(Frame frame, String string) {
        this(frame, string, 1);
    }

    public JEWTDialog(Frame frame, String string, int n) {
        super(frame, string);
        WindowUtils.registerWindow(this);
        this.setModal(true);
        this.setResizable(false);
        this.dialogInit();
        this.setButtonMask(n);
        this.setDefaultButton(1);
    }

    public JEWTDialog(Dialog dialog) {
        this(dialog, "JEWTDialog");
    }

    public JEWTDialog(Dialog dialog, String string) {
        this(dialog, string, 1);
    }

    public JEWTDialog(Dialog dialog, String string, int n) {
        super(dialog, string);
        WindowUtils.registerWindow(this);
        this.setModal(true);
        this.setResizable(false);
        this.dialogInit();
        this.setButtonMask(n);
        this.setDefaultButton(1);
    }

    public Component getCenterOver() {
        return this._centerOver;
    }

    public void setCenterOver(Component component) {
        this._centerOver = component;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public boolean runDialog() {
        return this.runDialog(null);
    }

    public boolean runDialog(Runnable runnable) {
        this._runnable = runnable;
        this._initStrings();
        this.pack();
        Component component = this.getCenterOver();
        if (component == null) {
            component = this.getParent();
        }
        WindowUtils.centerWindow(this, component);
        this._cancelled = false;
        this._initialWidth = this.getWidth();
        this._initialHeight = this.getHeight();
        ((Component)this).setVisible(true);
        return !this._cancelled;
    }

    public void dispose() {
        if (this._contentContainer == null) {
            return;
        }
        WindowUtils.unregisterWindow(this);
        this.setCenterOver(null);
        this.setContent(null);
        this._contentContainer = null;
        this._bar.removeAll();
        this._bar = null;
        this._buttons.removeAllElements();
        this._buttons = null;
        if (this._ok != null) {
            this._ok.removeActionListener(this._listener);
            this._ok.removeFocusListener(this._listener);
        }
        if (this._cancelClose != null) {
            this._cancelClose.removeActionListener(this._listener);
            this._cancelClose.removeFocusListener(this._listener);
        }
        if (this._help != null) {
            this._help.removeActionListener(this._listener);
            this._help.removeFocusListener(this._listener);
        }
        if (this._apply != null) {
            this._apply.removeActionListener(this._listener);
            this._apply.removeFocusListener(this._listener);
        }
        this._listener = null;
        this._apply = null;
        this._help = null;
        this._cancelClose = null;
        this._ok = null;
        this._defaultButton = null;
        this._pane.setContent(null);
        this._pane = null;
        super.dispose();
    }

    public final void setPreferredSize(Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension(-1, -1);
        }
        this.setPreferredSize(dimension.width, dimension.height);
    }

    public void setPreferredSize(int n, int n2) {
        this._prefWidth = n;
        this._prefHeight = n2;
    }

    public final void setMinimumSize(Dimension dimension) {
        if (dimension == null) {
            this.setMinimumSize(-1, -1);
        } else {
            this.setMinimumSize(dimension.width, dimension.height);
        }
    }

    public void setMinimumSize(int n, int n2) {
        this._minWidth = n;
        this._minHeight = n2;
    }

    public Dimension getMinimumSize() {
        if (this._minWidth != -1 && this._minHeight != -1) {
            return new Dimension(this._minWidth, this._minHeight);
        }
        return new Dimension(this._initialWidth, this._initialHeight);
    }

    public final void setMaximumInitialSize(Dimension dimension) {
        if (dimension == null) {
            this.setMaximumInitialSize(-1, -1);
        } else {
            this.setMaximumInitialSize(dimension.width, dimension.height);
        }
    }

    public void setMaximumInitialSize(int n, int n2) {
        this._dialogMaximumWidth = n;
        this._dialogMaximumHeight = n2;
    }

    public Dimension getMaximunInitialSize() {
        if (this._dialogMaximumWidth != -1 && this._dialogMaximumHeight != -1) {
            return new Dimension(this._dialogMaximumWidth, this._dialogMaximumHeight);
        }
        return new Dimension(WindowUtils.DIALOG_MAXIMUM_WIDTH, WindowUtils.DIALOG_MAXIMUM_HEIGHT);
    }

    public Dimension getMaximumInitialSize() {
        return this.getMaximunInitialSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = null;
        dimension = this._prefWidth != -1 && this._prefHeight != -1 ? new Dimension(this._prefWidth, this._prefHeight) : super.getPreferredSize();
        Dimension dimension2 = this.getMaximumInitialSize();
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height > dimension2.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    public Component getContent() {
        return this._contentContainer == null || this._contentContainer.getComponentCount() == 0 ? null : this._contentContainer.getComponent(0);
    }

    public void setContent(Component component) {
        boolean bl = this.getContent() instanceof JTabbedPane;
        this._contentContainer.removeAll();
        if (component instanceof JTabbedPane && !bl) {
            JPanel jPanel = this._mainContainer;
            jPanel.remove(this._pane);
            jPanel.add("Center", this._contentContainer);
            this._contentContainer.setBorder(null);
        } else if (bl) {
            JPanel jPanel = this._mainContainer;
            jPanel.remove(this._contentContainer);
            this._pane = new GrayPane(this._contentContainer);
            jPanel.add("Center", this._pane);
            this._contentContainer.setBorder(_sInnerBorder);
        }
        if (component != null) {
            this._contentContainer.add("Center", component);
        }
        this._contentContainer.revalidate();
    }

    public int getButtonMask() {
        return this._buttonMask;
    }

    public void setButtonMask(int n) {
        if (n > 31) {
            throw new IllegalArgumentException("Button Mask out of range");
        }
        if ((n & 0x12) == 18) {
            throw new IllegalArgumentException("Cancel and Close buttons are exclusive");
        }
        if (n != this._buttonMask) {
            int n2 = this._buttonMask & ~n;
            if ((n2 & 1) > 0) {
                this._removeOk(this._bar);
            }
            if ((n2 & 2) > 0 || (n2 & 0x10) > 0) {
                this._removeCancelClose(this._bar);
            }
            if ((n2 & 4) > 0) {
                this._removeHelp(this._bar);
            }
            if ((n2 & 8) > 0) {
                this._removeApply(this._bar);
            }
            this._buttonMask = n;
            Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, locale);
            if ((this._buttonMask & 1) > 0) {
                this._addOk(resourceBundle, this._bar);
            }
            if ((this._buttonMask & 2) > 0 || (this._buttonMask & 0x10) > 0) {
                this._addCancelClose(resourceBundle, this._bar);
            }
            if ((this._buttonMask & 4) > 0) {
                this._addHelp(resourceBundle, this._bar);
            }
            if ((this._buttonMask & 8) > 0) {
                this._addApply(resourceBundle, this._bar);
            }
            this._contentContainer.revalidate();
        }
    }

    public void addCustomButton(Component component) {
        if (!this._buttons.contains(component)) {
            this._bar.add(component);
            this._buttons.addElement(component);
        }
    }

    public void removeCustomButton(Component component) {
        this._bar.remove(component);
        this._buttons.removeElement(component);
    }

    public int getCustomButtonCount() {
        return this._buttons.size();
    }

    public Component getCustomButton(int n) {
        if (this.getCustomButtonCount() > n) {
            return (Component)this._buttons.elementAt(n);
        }
        return null;
    }

    public int getDefaultButton() {
        return this._defaultButtonIndex;
    }

    public void setDefaultButton(int n) {
        if (n < 0 || n > 16) {
            throw new IllegalArgumentException("Undefined button constant");
        }
        if (n != this._defaultButtonIndex) {
            JButton jButton = this.getRootPane().getDefaultButton();
            if (jButton != null) {
                jButton.setDefaultCapable(false);
            }
            switch (n) {
                case 1: {
                    this._defaultButton = this._ok;
                    break;
                }
                case 2: {
                    if ((this.getButtonMask() & 2) == 0) {
                        throw new UnsupportedOperationException("Cancel button is unavailable in button mask");
                    }
                    this._defaultButton = this._cancelClose;
                    break;
                }
                case 4: {
                    this._defaultButton = this._help;
                    break;
                }
                case 8: {
                    this._defaultButton = this._apply;
                    break;
                }
                case 16: {
                    if ((this.getButtonMask() & 0x10) == 0) {
                        throw new UnsupportedOperationException("Close button is unavailable in button mask");
                    }
                    this._defaultButton = this._cancelClose;
                    break;
                }
                default: {
                    this._defaultButton = null;
                }
            }
            this._defaultButtonIndex = n;
            this.getRootPane().setDefaultButton(this._defaultButton);
            if (this._defaultButton != null) {
                this._defaultButton.setDefaultCapable(true);
            }
        }
    }

    public void setOKButtonEnabled(boolean bl) {
        if (this._ok != null) {
            this._ok.setEnabled(bl);
        }
    }

    public boolean isOKButtonEnabled() {
        return this._ok != null ? this._ok.isEnabled() : false;
    }

    public void setOKButtonText(String string) {
        if (this._ok == null) {
            this.setButtonMask(this.getButtonMask() | 1);
        }
        this._ok.setText(StringUtils.stripMnemonic((String)string));
        this._ok.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this._isOKDefaulted = false;
    }

    public String getOKButtonText() {
        return this._ok != null ? this._ok.getText() : null;
    }

    public int getOKButtonMnemonic() {
        return this._ok != null ? this._ok.getMnemonic() : -1;
    }

    public void setOKButtonMnemonic(int n) {
        if (this._ok == null) {
            this.setButtonMask(this.getButtonMask() | 1);
        }
        this._ok.setMnemonic(n);
    }

    public void setCancelButtonText(String string) {
        if ((this.getButtonMask() & 0x10) > 0) {
            throw new UnsupportedOperationException("Cancel button is unavailable in button mask");
        }
        if (this._cancelClose == null) {
            this.setButtonMask(this.getButtonMask() | 2);
        }
        this._cancelClose.setText(StringUtils.stripMnemonic((String)string));
        this._cancelClose.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this._isCancelDefaulted = false;
    }

    public String getCancelButtonText() {
        if ((this.getButtonMask() & 0x10) > 0) {
            return null;
        }
        return this._cancelClose != null ? this._cancelClose.getText() : null;
    }

    public int getCancelButtonMnemonic() {
        if ((this.getButtonMask() & 0x10) > 0) {
            return -1;
        }
        return this._cancelClose != null ? this._cancelClose.getMnemonic() : -1;
    }

    public void setCancelButtonMnemonic(int n) {
        if ((this.getButtonMask() & 0x10) > 0) {
            throw new UnsupportedOperationException("Cancel button is unavailable in button mask");
        }
        if (this._cancelClose == null) {
            this.setButtonMask(this.getButtonMask() | 2);
        }
        this._cancelClose.setMnemonic(n);
    }

    public int getButtonMnemonic(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                if (this._ok == null) break;
                n2 = this._ok.getMnemonic();
                break;
            }
            case 2: {
                if (this._cancelClose == null || (this.getButtonMask() & 2) <= 0) break;
                n2 = this._cancelClose.getMnemonic();
                break;
            }
            case 4: {
                if (this._help == null) break;
                n2 = this._help.getMnemonic();
                break;
            }
            case 8: {
                if (this._apply == null) break;
                n2 = this._apply.getMnemonic();
                break;
            }
            case 16: {
                if (this._cancelClose == null || (this.getButtonMask() & 0x10) <= 0) break;
                n2 = this._cancelClose.getMnemonic();
            }
        }
        return n2;
    }

    public void addActionListener(ActionListener actionListener) {
        if (this._actionListeners == null) {
            this._actionListeners = new ListenerManager();
        }
        this._actionListeners.addListener((EventListener)actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this._actionListeners != null) {
            this._actionListeners.removeListener((EventListener)actionListener);
        }
    }

    public void addNotify() {
        super.addNotify();
        final Window window = WindowUtils.getWindow(this);
        window.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                if (JEWTDialog.this._initialFocus != null) {
                    FocusUtils.requestFocus(JEWTDialog.this._initialFocus);
                } else {
                    Component component = null;
                    Component component2 = JEWTDialog.this.getContent();
                    if (component2 instanceof Container) {
                        component = FocusUtils.getFirstFocusableComponent((Container)component2);
                    } else if (component2 != null && FocusUtils.isFocusable(component2) && component2.isEnabled() && component2.isShowing()) {
                        component = component2;
                    }
                    if (component != null) {
                        FocusUtils.requestFocus(component);
                    } else if (JEWTDialog.this._defaultButton != null && JEWTDialog.this._defaultButton.isEnabled()) {
                        FocusUtils.requestFocus(JEWTDialog.this._defaultButton);
                    } else if (JEWTDialog.this._ok != null && JEWTDialog.this._ok.isEnabled()) {
                        FocusUtils.requestFocus(JEWTDialog.this._ok);
                    }
                }
                window.removeWindowListener(this);
            }
        });
    }

    public Component getInitialFocus() {
        return this._initialFocus;
    }

    public void setInitialFocus(Component component) {
        this._initialFocus = component;
    }

    public void setDialogHeader(Component component) {
        if (this._header != component) {
            if (this._header != null) {
                this.getContentPane().remove(this._header);
            }
            this._header = component;
            if (this._header != null) {
                this.getContentPane().add("North", this._header);
                this._mainContainer.setBorder(JEWTDialog._getHeaderOuterBorder());
            } else {
                this._mainContainer.setBorder(_sOuterBorder);
            }
        }
    }

    public Component getDialogHeader() {
        return this._header;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoableChangeSupport == null) {
            this._vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this._vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoableChangeSupport != null) {
            this._vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public final void closeDialog(boolean bl) {
        this.dismissDialog(bl);
    }

    public static boolean isDialogClosingEvent(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getOldValue();
        return PROPERTY_CLOSED.equals(string) && Boolean.TRUE.equals(object) && Boolean.FALSE.equals(object2);
    }

    public void pack() {
        if (_IS_LINUX && !this.isResizable()) {
            this._kdePackFix();
        } else {
            super.pack();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = super.getAccessibleContext();
            StatusBar statusBar = new StatusBar();
            this._statusBarLabel = new StatusBarLabel();
            statusBar.add(this._statusBarLabel);
            statusBar.setPreferredSize(new Dimension(0, 0));
            this._bottomPanel.add((Component)statusBar, "South");
        }
        return this.accessibleContext;
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        int n;
        int n2;
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() != 101) {
            return;
        }
        int n3 = n2 = this.getWidth();
        int n4 = n = this.getHeight();
        Dimension dimension = this.getMinimumSize();
        n3 = Math.max(dimension.width, n3);
        n4 = Math.max(dimension.height, n4);
        if (n2 != n3 || n != n4) {
            ((Component)this).setSize(n3, n4);
        }
    }

    protected void dialogInit() {
        super.dialogInit();
        this.enableEvents(1L);
        this.setPreferredSize(-1, -1);
        this.setResizable(false);
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, locale);
        this._listener = new UIListener();
        this._contentContainer = new JPanel(new BorderLayout());
        this._contentContainer.setBorder(_sInnerBorder);
        this._pane = new GrayPane(this._contentContainer);
        this._bar = new DialogButtonBar();
        this._bar.setBorder(_sButtonBorder);
        this._bottomPanel = new JPanel(new BorderLayout());
        this._bottomPanel.add(this._bar);
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        this._mainContainer = new JPanel(new BorderLayout(0, 8));
        this._mainContainer.setBorder(_sOuterBorder);
        this._mainContainer.add("Center", this._pane);
        this._mainContainer.add("South", this._bottomPanel);
        jComponent.add("Center", this._mainContainer);
        Color color = UIManager.getColor("EWTDialog.background");
        if (color != null) {
            ((Component)this).setBackground(color);
            this.getContentPane().setBackground(color);
        }
        this.enableEvents(64L);
        this._registerKeyboardActions();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.dismissDialog(true);
        } else if (windowEvent.getID() == 205 && this._statusBarLabel != null) {
            this._statusBarLabel.setText("");
            String string = this.getAccessibleContext().getAccessibleName();
            if (string != null && !string.equals(this.getTitle())) {
                this._statusBarLabel.setText(string);
            }
        }
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this._vetoableChangeSupport != null) {
            this._vetoableChangeSupport.fireVetoableChange(string, object, object2);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    protected void dismissDialog(boolean bl) {
        if (!bl) {
            try {
                this.fireVetoableChange(PROPERTY_CLOSED, Boolean.FALSE, Boolean.TRUE);
            }
            catch (PropertyVetoException propertyVetoException) {
                return;
            }
        }
        this._cancelled = bl;
        if (this.isVisible()) {
            ((Component)this).setVisible(false);
            if (!this._cancelled && this._runnable != null) {
                PaintUtils.invokeAfterRepaint(this._runnable);
                this._runnable = null;
            }
        }
        this.firePropertyChange(PROPERTY_CLOSED, Boolean.FALSE, Boolean.TRUE);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this._actionListeners == null) {
            return;
        }
        Enumeration enumeration = this._actionListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (actionEvent.getID()) {
            case 1001: {
                while (enumeration.hasMoreElements()) {
                    ((ActionListener)enumeration.nextElement()).actionPerformed(actionEvent);
                }
                break;
            }
        }
    }

    void fireHelpEvent() {
        try {
            Component component = this.getContent();
            if (component == null) {
                component = this;
            }
            HelpUtils.showHelp(component);
        }
        catch (HelpUnavailableException helpUnavailableException) {
            // empty catch block
        }
    }

    private void _registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this._listener, _KEY_CANCEL, KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this._listener, _KEY_HELP, KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this._listener, _KEY_HELP, KeyStroke.getKeyStroke(156, 0), 1);
    }

    private void _unregisterKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        jRootPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0));
        jRootPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(156, 0));
    }

    private void _initStrings() {
        String string;
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, locale);
        if (this._ok != null && this._isOKDefaulted) {
            string = resourceBundle.getString(_KEY_OK);
            this._ok.setText(StringUtils.stripMnemonic((String)string));
            this._ok.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        }
        if (this._apply != null) {
            string = resourceBundle.getString(_KEY_APPLY);
            this._apply.setText(StringUtils.stripMnemonic((String)string));
            this._apply.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        }
        if (this._cancelClose != null) {
            string = null;
            if ((this.getButtonMask() & 2) > 0) {
                if (this._isCancelDefaulted) {
                    string = resourceBundle.getString(_KEY_CANCEL);
                }
            } else if ((this.getButtonMask() & 0x10) > 0) {
                string = resourceBundle.getString(_KEY_CLOSE);
            }
            if (string != null) {
                this._cancelClose.setText(StringUtils.stripMnemonic((String)string));
                this._cancelClose.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            }
        }
        if (this._help != null) {
            string = resourceBundle.getString(_KEY_HELP);
            this._help.setText(StringUtils.stripMnemonic((String)string));
            this._help.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        }
    }

    private void _addOk(ResourceBundle resourceBundle, DialogButtonBar dialogButtonBar) {
        if (this._ok == null) {
            String string = resourceBundle.getString(_KEY_OK);
            this._ok = new JButton(StringUtils.stripMnemonic((String)string));
            this._ok.setDefaultCapable(true);
            this._ok.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this._ok.setActionCommand(_KEY_OK);
            this._ok.addActionListener(this._listener);
            this._ok.addFocusListener(this._listener);
            this._ok.setName(_OK_NAME);
        }
        dialogButtonBar.add((Component)this._ok, DialogButtonBar.CONSTRAINT_YES);
    }

    private void _addApply(ResourceBundle resourceBundle, DialogButtonBar dialogButtonBar) {
        if (this._apply == null) {
            String string = resourceBundle.getString(_KEY_APPLY);
            this._apply = new JButton(StringUtils.stripMnemonic((String)string));
            this._apply.setDefaultCapable(false);
            this._apply.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this._apply.setActionCommand(_KEY_APPLY);
            this._apply.addActionListener(this._listener);
            this._apply.addFocusListener(this._listener);
            this._apply.setName(_APPLY_NAME);
        }
        dialogButtonBar.add((Component)this._apply, DialogButtonBar.CONSTRAINT_APPLY);
    }

    private void _addCancelClose(ResourceBundle resourceBundle, DialogButtonBar dialogButtonBar) {
        if (this._cancelClose == null) {
            boolean bl = (this.getButtonMask() & 2) > 0;
            String string = bl ? resourceBundle.getString(_KEY_CANCEL) : resourceBundle.getString(_KEY_CLOSE);
            this._cancelClose = new JButton(StringUtils.stripMnemonic((String)string));
            this._cancelClose.setDefaultCapable(false);
            this._cancelClose.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this._cancelClose.setActionCommand(_KEY_CANCEL);
            this._cancelClose.addActionListener(this._listener);
            this._cancelClose.addFocusListener(this._listener);
            this._cancelClose.setName(bl ? _CANCEL_NAME : _CLOSE_NAME);
        }
        dialogButtonBar.add((Component)this._cancelClose, DialogButtonBar.CONSTRAINT_CANCEL);
    }

    private void _addHelp(ResourceBundle resourceBundle, DialogButtonBar dialogButtonBar) {
        if (this._help == null) {
            String string = resourceBundle.getString(_KEY_HELP);
            this._help = new JButton(StringUtils.stripMnemonic((String)string));
            this._help.setDefaultCapable(false);
            this._help.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this._help.setActionCommand(_KEY_HELP);
            this._help.addActionListener(this._listener);
            this._help.addFocusListener(this._listener);
            this._help.setName(_HELP_NAME);
        }
        dialogButtonBar.add((Component)this._help, DialogButtonBar.CONSTRAINT_HELP);
    }

    private void _removeOk(DialogButtonBar dialogButtonBar) {
        dialogButtonBar.remove(this._ok);
    }

    private void _removeApply(DialogButtonBar dialogButtonBar) {
        dialogButtonBar.remove(this._apply);
    }

    private void _removeCancelClose(DialogButtonBar dialogButtonBar) {
        dialogButtonBar.remove(this._cancelClose);
    }

    private void _removeHelp(DialogButtonBar dialogButtonBar) {
        dialogButtonBar.remove(this._help);
    }

    private void _kdePackFix() {
        this.setResizable(true);
        super.pack();
        this.setResizable(false);
    }

    private void _revalidate() {
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.revalidate();
    }

    private static Border _getHeaderOuterBorder() {
        if (_sHeaderOuterBorder == null) {
            _sHeaderOuterBorder = new EmptyBorder(1, 6, 8, 6);
        }
        return _sHeaderOuterBorder;
    }

    static {
        String string = System.getProperty("os.name");
        _IS_LINUX = string != null && string.indexOf("Linux") != -1;
        _sOuterBorder = new EmptyBorder(6, 6, 8, 6);
        _sInnerBorder = new EmptyBorder(10, 10, 10, 10);
        _sButtonBorder = new EmptyBorder(0, 10, 0, 10);
    }

    private class StatusBarLabel
    extends JLabel {
        private StatusBarLabel() {
        }

        public void setText(String string) {
            String string2 = this.getText();
            super.setText(string);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleName", string2, string);
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleStatusBarLabel();
            }
            return this.accessibleContext;
        }

        private class AccessibleStatusBarLabel
        extends JLabel.AccessibleJLabel {
            private AccessibleStatusBarLabel() {
                super(StatusBarLabel.this);
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                super.addPropertyChangeListener(propertyChangeListener);
                String string = StatusBarLabel.this.getText();
                if (string != null) {
                    StatusBarLabel.this.setText("");
                    StatusBarLabel.this.setText(string);
                }
            }
        }
    }

    private class UIListener
    implements ActionListener,
    FocusListener {
        private UIListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            JButton jButton;
            JButton jButton2 = JEWTDialog.this.getRootPane().getDefaultButton();
            if (jButton2 != (jButton = (JButton)focusEvent.getSource())) {
                if (jButton2 != null) {
                    jButton2.setDefaultCapable(false);
                }
                jButton.setDefaultCapable(true);
                JEWTDialog.this.getRootPane().setDefaultButton(jButton);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            JButton jButton;
            if (!focusEvent.isTemporary() && (jButton = (JButton)focusEvent.getSource()) != JEWTDialog.this._defaultButton) {
                jButton.setDefaultCapable(false);
                JEWTDialog.this.getRootPane().setDefaultButton(JEWTDialog.this._defaultButton);
                if (JEWTDialog.this._defaultButton != null) {
                    JEWTDialog.this._defaultButton.setDefaultCapable(true);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (JEWTDialog._KEY_OK.equals(string)) {
                JEWTDialog.this.dismissDialog(false);
            } else if (JEWTDialog._KEY_APPLY.equals(string)) {
                JEWTDialog.this.processEvent(new ActionEvent(JEWTDialog.this, 1001, JEWTDialog.ACTION_APPLY));
            } else if (JEWTDialog._KEY_CANCEL.equals(string)) {
                JEWTDialog.this.dismissDialog(true);
            } else if (JEWTDialog._KEY_HELP.equals(string)) {
                JEWTDialog.this.fireHelpEvent();
            }
        }
    }
}

