/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemEvent;
import oracle.bali.ewt.dTree.DTreeRange;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.dTree.DTreeSelectionManager;
import oracle.bali.ewt.event.Cancelable;

public class DTreeSingleSelectionManager
implements DTreeSelectionManager {
    private DTree _tree;
    private DTreeItem _selected;
    private PropertyChangeSupport _propSupport;
    private VetoableChangeSupport _vetoSupport;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propSupport == null) {
            this._propSupport = new PropertyChangeSupport(this);
        }
        this._propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoSupport == null) {
            this._vetoSupport = new VetoableChangeSupport(this);
        }
        this._vetoSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propSupport != null) {
            this._propSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoSupport != null) {
            this._vetoSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._propSupport != null) {
            this._propSupport.firePropertyChange(string, object, object2);
        }
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this._vetoSupport != null) {
            this._vetoSupport.fireVetoableChange(string, object, object2);
        }
    }

    public void setTree(DTree dTree) {
        if (dTree != this._tree) {
            this._tree = dTree;
            this._selected = null;
        }
    }

    public void extendSelection(DTreeItem dTreeItem) throws PropertyVetoException {
        this.selectItem(dTreeItem);
    }

    public boolean isSomethingSelected() {
        return this._selected != null;
    }

    public DTreeSelection getSelection() {
        DTreeItem dTreeItem;
        DTreeSelection dTreeSelection = new DTreeSelection();
        if (this._selected != null && (dTreeItem = this._selected.getParent()) != null) {
            int n = this._selected.getIndex();
            dTreeSelection.addRange(new DTreeRange(dTreeItem, n, 1));
        }
        return dTreeSelection;
    }

    public DTree getTree() {
        return this._tree;
    }

    public boolean isSelected(DTreeItem dTreeItem) {
        return dTreeItem == this._selected;
    }

    public void itemCollapsing(DTreeItemEvent dTreeItemEvent) {
        DTreeItem dTreeItem = dTreeItemEvent.getItem();
        if (this._selected != null && this._selected != dTreeItem && DTree.isItemDescendent(this._selected, dTreeItem)) {
            try {
                this.selectItem(dTreeItem);
            }
            catch (PropertyVetoException propertyVetoException) {
                ((Cancelable)((Object)dTreeItemEvent)).cancel();
            }
        }
    }

    public void itemsAdded(DTreeItem dTreeItem, int n, int n2) {
    }

    public void itemsRemoved(DTreeItem dTreeItem, int n, int n2) {
        if (this._selected != null && this._selected.getParent() == null) {
            this._selected = null;
            try {
                this._setSelection(null, null, true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void selectItem(DTreeItem dTreeItem) throws PropertyVetoException {
        this._setSelection(dTreeItem, dTreeItem, false);
    }

    public void setSelection(DTreeSelection dTreeSelection) throws PropertyVetoException {
        DTreeItem dTreeItem = null;
        if (dTreeSelection != null && dTreeSelection.getCount() > 0) {
            DTreeRange dTreeRange = dTreeSelection.getRange(0);
            int n = dTreeRange.getStartIndex();
            int n2 = dTreeRange.getCount();
            if (dTreeRange.getCount() > 0) {
                DTreeItem dTreeItem2 = dTreeRange.getParent();
                dTreeItem = dTreeItem2.getItem(dTreeRange.getStartIndex());
            }
        }
        this._setSelection(dTreeItem, null, false);
    }

    public void toggleItem(DTreeItem dTreeItem) throws PropertyVetoException {
        if (this.isSelected(dTreeItem)) {
            this.selectItem(null);
        } else {
            this.selectItem(dTreeItem);
        }
    }

    private void _setSelection(DTreeItem dTreeItem, DTreeItem dTreeItem2, boolean bl) throws PropertyVetoException {
        if (this._selected == dTreeItem && !bl) {
            return;
        }
        DTreeSelection dTreeSelection = this.getSelection();
        DTreeSelection dTreeSelection2 = new DTreeSelection();
        if (dTreeItem != null) {
            DTreeItem dTreeItem3 = dTreeItem.getParent();
            int n = dTreeItem.getIndex();
            dTreeSelection2.addRange(new DTreeRange(dTreeItem3, n, 1));
        }
        this.fireVetoableChange("selection", dTreeSelection, dTreeSelection2);
        this._selected = dTreeItem;
        if (dTreeItem2 != null) {
            this._tree.setFocusedItem(dTreeItem2);
        }
        this.firePropertyChange("selection", dTreeSelection, dTreeSelection2);
    }
}

